/**
 * Copyright rison ( http://wonderfl.net/user/rison )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oMbA
 */

package  
{
    /**
     * @see https://twitter.com/pixas_engine
     */
    import com.risonhuang.pixas.colors.CubeColor;
    import com.risonhuang.pixas.dimensions.CubeDms;
    import com.risonhuang.pixas.math.Coord3D;
    import com.risonhuang.pixas.objects.PixelObject;
    import com.risonhuang.pixas.objects.primitives.Cube;
    import fl.transitions.easing.Regular;
    import fl.transitions.Tween;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.utils.Timer;
    import flash.system.LoaderContext;
    
    public class Main extends Sprite
    {
        private var po:PixelObject;
        private var bmd:BitmapData;
        private var timer:Timer;
        private var vec:Vector.<PixelObject>;
        private static const CONSTRAIN_SIZE:uint = 50;
        private static const X_DMS:uint = 6;
        private static const Y_DMS:uint = 6;
        private static const Z_DMS:uint = 10;
        
        public function Main() 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            var url:String = "http://assets.wonderfl.net/images/related_images/0/0b/0bf4/0bf42615215276a1c7fca94dafba92893f19ea98m";
            var loader:Loader = new Loader();
            loader.load(new URLRequest(url), new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, __onPicLoad);
                    
        }
        
        private function __onPicLoad(e:Event):void
        {
            var img:Bitmap = e.target.loader.content as Bitmap;
            bmd = new BitmapData(CONSTRAIN_SIZE, CONSTRAIN_SIZE, false, 0xffcc00);
            bmd.draw(img, new Matrix(CONSTRAIN_SIZE / 200, 0, 0, CONSTRAIN_SIZE / 200));
            addChild(new Bitmap(bmd));
            
            po = new PixelObject();
            po.x = 280;
            po.y = Z_DMS + 5;
            addChild(po);
            
            timer = new Timer(30);
            timer.addEventListener(TimerEvent.TIMER, __onTimer);
            
            vec = new Vector.<PixelObject>;
            
            reset();
        }
        
        private function reset(e:Event = null):void
        {
            timer.stop();
            po.removeAllChildren();
            buildIso();
        }
        
        private function buildIso():void
        {
            var p_y:uint = 0;
            var p_x:uint = 0;
            
            for (p_y=0; p_y < CONSTRAIN_SIZE; p_y++)
            {
                for (p_x =0; p_x < CONSTRAIN_SIZE; p_x++)
                {
                    var c3d:Coord3D = new Coord3D(X_DMS * p_x, Y_DMS * p_y, 0);
                    var cubeDms:CubeDms = new CubeDms(X_DMS,Y_DMS,Z_DMS);
                    var cubeColor:CubeColor = CubeColor.getByHorizontalColor(bmd.getPixel(p_x,p_y));
                    var cube:Cube = new Cube(cubeDms,cubeColor,false);
                    var po_cube:PixelObject = new PixelObject(cube,c3d);
                    po_cube.addEventListener(MouseEvent.MOUSE_MOVE,__onMouseOver);
                    po.addChild(po_cube);
                    vec.push(po_cube);
                }
            }
            
            timer.start();
        }
        
        private function __onMouseOver(e:MouseEvent):void
        {
            var po_cube:PixelObject = e.target as PixelObject;
            var bm:Bitmap = po_cube.bitmap;
            if (bm.bitmapData.getPixel32(bm.mouseX, bm.mouseY) != 0)
            {
                vec.splice(vec.indexOf(po_cube), 1);
                po_cube.removeEventListener(MouseEvent.MOUSE_MOVE,__onMouseOver);
                var tween:Tween = new Tween(po_cube, "y", Regular.easeOut, po_cube.y, po_cube.y + 300, 1, true);
            }
        }
        
        private function __onTimer(e:TimerEvent):void
        {
            if (vec.length == 0) { timer.stop(); return; }
            var po_pop:PixelObject = vec.pop();
            po_pop.removeEventListener(MouseEvent.MOUSE_MOVE,__onMouseOver);
            var tween:Tween = new Tween(po_pop, "y", Regular.easeOut, po_pop.y, po_pop.y + 300, 1, true);
        }
    }
}