/**
 * Copyright beryu ( http://wonderfl.net/user/beryu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oM42
 */

/**
 * capsule「JUMPER」のPVの3:00過ぎあたりに出てくる"うねり"を再現。
 * PVとはうねりの方向が逆である事には後から気付いた。。。
 * 
 * http://www.youtube.com/results?search_query=JUMPER+capsule
 */
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.media.Camera;
    import flash.media.Video;
    
    [SWF(frameRate=30)]
    
    public class WaveCam extends Sprite {
        private const DIVIDE_NUM:Number = 70; // *****PCの性能に余裕がある人は、ここの数値を上げると"うねり"がもっと細かくなって楽しい*****
        private var _cam:Camera;
        private var _vid:Video;
        private var _bmp:Bitmap;
        private var _bmpDataSrcArr:Array = [];
        private var _bmpDataEffect:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight/DIVIDE_NUM+1, true);
        private var _bmpDataDst:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
        private var _curFrame:Number = 0;
        private var _curFrameCnt:Number = 0;
        
        public function WaveCam()
        {
            // ビデオ準備
            _cam = Camera.getCamera();
            _cam.setMode(stage.stageWidth, stage.stageHeight, 10);
            _vid = new Video(stage.stageWidth, stage.stageHeight);
            _vid.attachCamera(_cam);
            
            // ビデオ編集用BitmapData準備
            var tmpBmpDataSrcArr:Array;
            for(var i:Number=0; i<DIVIDE_NUM; i++)
            {
                _bmpDataSrcArr.push( new BitmapData(stage.stageWidth, stage.stageHeight, true) );
            }
            
            // 表示用Bitmapに出力用bitmapを関連づける
            _bmp = new Bitmap(_bmpDataDst);
            
            // stageにadd
            addChild(_bmp);
            
            // イベント
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            // 指定したframe毎に分割ビデオを切り替える
            _curFrame = (_curFrame+1) % DIVIDE_NUM;
            
            // 基になるビデオ
            _bmpDataSrcArr[_curFrame].draw(_vid);
            
            // ビデオ描画
            for(var i:Number=0; i<DIVIDE_NUM; i++)
            {
                _bmpDataEffect.draw( _bmpDataSrcArr[(_curFrame+i+1)%DIVIDE_NUM], new Matrix(1, 0, 0, 1, 0, i * stage.stageHeight/DIVIDE_NUM*-1) );
                _bmpDataDst.draw( _bmpDataEffect, new Matrix(1, 0, 0, 1, 0, i * stage.stageHeight/DIVIDE_NUM) );
            }
        }
    }
}