/**
 * Copyright milchreis ( http://wonderfl.net/user/milchreis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oLjL
 */

    package {
        import flash.geom.Point;
        import flash.geom.Rectangle;
        import flash.display.Sprite;
        public class Main extends Sprite 
        {
            public function Main() 
            {
                var factory:RandomPositionPolyFactory = new RandomPositionPolyFactory();
    
                //compose 3 rectangles            
                factory.addFactory(new RandomPositionFromRectFactory(new Rectangle(10, 10, 100, 100)));
                factory.addFactory(new RandomPositionFromRectFactory(new Rectangle(120, 120, 100, 100)));
                factory.addFactory(new RandomPositionFromRectFactory(new Rectangle(230, 230, 100, 100)));
    
                graphics.beginFill(0);
    
                for (var i:uint = 0; i< 1500; ++i)
                {
                    var pos:Point = factory.position; // get random position
                    graphics.drawCircle(pos.x, pos.y, 2); //draw dot
                }
    
                graphics.endFill();
            }
        }
    }
    import flash.geom.Rectangle;
    import flash.geom.Point;
    
    internal interface IRandomPositionFactory
    {
        function get position():Point;
        function get area():Number
    }
    
    // produces Point objects evenly randomly distributed in a given Rectangle
    internal class RandomPositionFromRectFactory implements IRandomPositionFactory
    {
        private var _rect:Rectangle;
        private var _area:Number;
    
        public function RandomPositionFromRectFactory(rect:Rectangle)
        {        
            _rect = rect;
            _area = (_rect.right - _rect.left) * (_rect.bottom - _rect.top);
        }
    
        public function get position():Point
        {
            return new Point(random(_rect.left, _rect.right), random(_rect.top, _rect.bottom));
        }       
    
        public function get area():Number
        {
            return _area;
        }
    }
    // has many RandomPositionFactories, distributes probability evenly over them to act as a single Factory
    internal class RandomPositionPolyFactory implements IRandomPositionFactory
    {
        private var _factories:Array;
        private var _area:Number;
    
        public function RandomPositionPolyFactory()
        {
            _factories = [];
            _area = 0;
        }
    
        public function addFactory(factory:IRandomPositionFactory):void
        {
            _factories.push(factory);
            _area += factory.area;;
        }
    
        public function get position():Point
        {
            var random:Number = Math.random() * _area;
            var sum:Number = 0;
            var factory:IRandomPositionFactory;
    
            for (var i:uint = 0; i < _factories.length; ++i)
            {
                factory = _factories[i];
    
                sum += factory.area;
    
                if (sum >= random)
                    return factory.position;
            }
    
            return new Point();
        }
    
        public function get area():Number
        {
            return _area;
        }
    }
    
    internal function random(min:Number, max:Number):Number
    {
        return Math.random()*(max-min) + min;
    }