/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oL6n
 */

// forked from soundkitchen's [1日1Wonderfl]3日目: 某的なアレ
// 1日1Wonderfl 3/30日目
/**
 *  某塊的なイントロ部分、どうやってるのかなー？って事で試してみた。
 *  あと幾何学模様を書きたがってる人からインスパイアされたり。
 *  まだまだ知らん事が山盛り。なるほど！の連続。楽しい :-)
 *
 *  @see http://katamari.co.jp/
 *  @see http://tirirenge.undo.jp/?p=1676
 */
package
{
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    //import flash.display.StageAlign;
    //import flash.display.StageQuality;
    //import flash.display.StageScaleMode;
    import flash.events.Event;
    	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Graphics;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event; 
	import flash.events.MouseEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	import frocessing.color.ColorHSV;
	import frocessing.color.ColorRGB;

    import com.flashdynamix.utils.SWFProfiler;

    import frocessing.color.ColorHSV;
    

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]

    /**
     *  今回は丸を重ねましょう
     */
    public class Main extends Sprite
    {
        public static const NUM_CIRCLES:uint = 20;
        public static const MAX_DISTANCE:uint = 200;
        public var _angle:Number = 0;
        public var POLARITY:int = 1;
        private var container:Sprite;
        private var circles:Array;
        
        private var afterBitmapData	:BitmapData = new BitmapData(465, 465, true, 0x00000000);
		private var afterImage		:Bitmap = new Bitmap(afterBitmapData, PixelSnapping.AUTO,  false);
		private var _canvas			:Sprite = new Sprite();

        /**
         *  コンストラクタ
         */
        public function Main()
        {
          
            addChild(afterImage);

            //  ステージ上で (ry
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        /**
         *  初期化 
         */
        private function initialize(evt:Event):void
        {
            //  立つ鳥後を濁さず
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            //  ステージの設定
            //stage.align = StageAlign.TOP_LEFT;
            //stage.quality = StageQuality.HIGH;
            //stage.scaleMode = StageScaleMode.NO_SCALE;

            //  プロファイラーを埋めこむ
            SWFProfiler.init(this);

            //  変数宣言とか
            var i:uint,
                cAngle:Number, nAngle:Number,
                hsv:ColorHSV,
                g:Graphics,
                sp:Shape;

            //  初期角度を 0 に
            cAngle = 0;

            //  360度（のラジアン）を丸の個数で割って、
            //  一個あたりの角度を計算しておく
            nAngle = Math.PI * 2 / NUM_CIRCLES;

            //  HSV 色空間での色定義
            //  @see http://ja.wikipedia.org/wiki/HSV%E8%89%B2%E7%A9%BA%E9%96%93
            hsv = new ColorHSV(cAngle, 1, 1, 0.5);

            //  ラップ用の Sprite を作る
            container = new Sprite();

            container.x = stage.stageWidth / 2;
            container.y = stage.stageHeight / 2;
                        container.blendMode = "add"
                        
            //  丸を入れとくための配列を初期化
            circles = [];

            //  指定個分だけ丸を作る
            for (i=0; i<NUM_CIRCLES; i++)
            {
                //  とりあえず Shape 作って
                sp = new Shape();

                //  blendMode を SUBTRACT に設定
                //  @see http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/display/BlendMode.html#SUBTRACT
                sp.blendMode = BlendMode.ADD;

                //  addChild より addChlidAt の方が速いと聞いて
                container.addChildAt(sp, 0);

                //  配列につっこんでおく
                circles[i] = sp;

                //  場所にあった色を設定
                hsv.h = cAngle / Math.PI * 180;

                //  丸を書く
                g = sp.graphics;
                g.beginFill(hsv.value, 0.8);
                g.drawCircle(0, 0, 4);
                g.endFill();

                //  次の角度に更新
                cAngle += nAngle;
            }

            //  イベントを設定
            addEventListener(Event.ENTER_FRAME, step);
            
            addChildAt(container, numChildren - 1);
        }

        /**
         *  毎フレーム呼ばれる処理
         */
        public function step(evt:Event):void
        {
            var i:uint,
                r:int, length:Number,
                cAngle:Number, nAngle:Number,
                sp:Shape;

            //  コンテナを回して角度を取りだす
            r = container.rotation += 2;

            //  コンテナの角度から距離を計算
           
            length = Math.sin(r / 180 * Math.PI) * MAX_DISTANCE;

            //  初期角度を 0 に
           

            //  一個あたりの角度を計算
           nAngle = Math.PI * 2 / NUM_CIRCLES  + _angle;
           
          //#onedayitwillmake: For some reason 1 degree * 0.25 gives such beautiful patterns!
           _angle += 0.0174532925 * 0.125 * POLARITY
            cAngle = _angle;
            
            if(Math.random() < 0.025) 
                (POLARITY == 1) ? POLARITY = -1 : POLARITY = 1;
                
            //  指定個分回して配置を更新
            for (i=0; i<NUM_CIRCLES; i++)
            {
                sp = circles[i];
                sp.x = Math.cos(cAngle) * length;
                sp.y = Math.sin(cAngle) * length;

                cAngle += nAngle;
            }
            
            afterBitmapData.colorTransform(afterBitmapData.rect, 
						new ColorTransform(1, 1, 1, 1, 0, 0, 0, -4));
			
			
			var mat:Matrix = new Matrix();
                        mat.rotate(-90 * Math.PI / 180);
                        mat.translate(container.x, container.y)                        
			afterBitmapData.draw(container, mat);
        }
    }
}

