/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oJoB
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.media.Camera;
	import flash.media.Video;
	
	public class Main extends Sprite
	{
		private var camera:Camera;
		private var bd:BitmapData;
		private var video:Video;
		
		public function Main()
		{	
			camera = Camera.getCamera();
			camera.setMode(stage.stageWidth, stage.stageHeight, 15);
			
			if (camera)
			{
				video = new Video(camera.width, camera.height);
				video.attachCamera(camera);
				
				bd = new BitmapData(camera.width, camera.height, false);
				addChild(new Bitmap(bd));
				
				addEventListener(Event.ENTER_FRAME, onEnterFrame);
			}
		}
		
		private function onEnterFrame(event:Event):void 
		{
			bd.draw(video);
			bd.threshold(bd, bd.rect, new Point(), "<", 0x7F, 0xFF000000, 0xFF);
			bd.threshold(bd, bd.rect, new Point(), "!=", 0x0, 0xFFFFFFFF, 0xFF);
		}
	}
}