/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oIWF
 */

// forked from ProjectNya's StarLight
////////////////////////////////////////////////////////////////////////////////
// StarLight
//
// [AS3.0] StarLightクラスだ！ (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1783
// [AS3.0] FontLoaderクラスに挑戦！ (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1337
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
     import flash.events.Event;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.geom.Point;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var image:ImageLoader;
        private var particle:BitmapData;
        private var loader:FontLoader;
        //private static var basePath:String = "";
        private static var basePath:String = "http://www.project-nya.jp/images/wonderfl/";
        private static var imagePath:String = "star.png";
        private static var fontPath:String = "MyriadProSemibold.swf";
        private static var className:String = "MyriadProSemibold";
        private var label:Label;
        private var light:StarLight;
        private var _point:Point = new Point(300, 200);

        public function Main() {
            //Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            image = new ImageLoader();
            image.addEventListener(ImageLoader.COMPLETE, initialize, false, 0, true);
            image.load(basePath + imagePath);
        }
        private function initialize(evt:Event):void {
            image.removeEventListener(ImageLoader.COMPLETE, initialize);
            //
            particle = image.content.bitmapData;
            //
            loader = new FontLoader();
            loader.addEventListener(FontLoader.COMPLETE, complete, false, 0, true);
            loader.load(basePath + fontPath, className);
        }
        private function complete(evt:Event):void {
            loader.removeEventListener(FontLoader.COMPLETE, complete);
            //
            label = new Label(200, 60, 60, Label.CENTER);
            addChild(label);
            label.x = 132;
            label.y = 202;
            label.textColor = 0xFFFFFF;
            label.alpha = 0.4;
            label.text = "SSN  Akijii";
            //
            light = new StarLight(new Rectangle(0, 0, 600, 400));
            addChild(light);
            light.initialize(particle);
            light.start();
            //
            stage.addEventListener(MouseEvent.MOUSE_MOVE, update, false, 0, true);
        }
        private function update(evt:MouseEvent):void {
            var point:Point = new Point(mouseX, mouseY);
            if (distance(point)) {
                light.setup(point);
            }
        }
        private function distance(point:Point):Boolean {
            var d:Number = Point.distance(point, _point);
            _point = point;
            if (d > 4) {
                return true;
            } else {
                return false;
            }
        }

    }

}


//////////////////////////////////////////////////
// StarLightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.filters.BlurFilter;

class StarLight extends Sprite {
    private var rect:Rectangle;
    private var particles:Array;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var container:Sprite;
    private static var colorTrans:ColorTransform;
    private static var point:Point = new Point();
    private static var blur:BlurFilter;

    public function StarLight(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        particles = new Array();
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        colorTrans = new ColorTransform(1, 1, 1, 0.4, 0, 0, 0, 0);
        blur = new BlurFilter(16, 16, 4);
    }
    public function initialize(particle:BitmapData):void {
        StarParticle.particle = particle;
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, update);
    }
    public function setup(pos:Object):void {
        var particle:StarParticle = new StarParticle(pos.x, pos.y);
        container.addChild(particle);
        particles.push(particle);
    }
    private function update(evt:Event):void {
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:StarParticle = particles[n];
            particle.update();
            if (particle.life < 0 || particle.x < 0 || particle.x >rect.width || particle.y < 0 || particle.y > rect.height) {
                container.removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
        draw();
    }
    private function draw():void {
        bitmapData.lock();
        bitmapData.draw(container, null, colorTrans);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
    }

}


//////////////////////////////////////////////////
// StarParticleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import frocessing.color.ColorHSV;

class StarParticle extends Sprite {
    public static var particle:BitmapData;
    private var time:Number = 0;
    private static var max:uint = 250;
    private static var unit:Number = 1/max;
    public var life:Number = 1;
    private var px:Number = 0;
    private var py:Number = 0;
    private var angle:Number = 0;
    private var vx:Number = 0;
    private var vy:Number = 0;
    private static var speed:Number = 250;
    private static var radian:Number = Math.PI/180;
    private static var acceleration:Number = -400;
    private static var tacceleration:Number = -120;
    private var _scale:Number = 1;
    private var color:ColorHSV;
    private var colorTrans:ColorTransform;

    public function StarParticle(sx:Number, sy:Number) {
        px = sx;
        py = sy;
        draw();
        init();
    }

    private function init():void {
        angle = Math.random()*360;
        vx = speed*Math.cos(angle*radian);
        vy = speed*Math.sin(angle*radian);
        x = px + vx*0.02;
        y = py + vy*0.02;
        color = new ColorHSV(- Math.random()*360, 0.5);
        colorTrans = new ColorTransform();
        colorTrans.color = color.value;
        transform.colorTransform = colorTrans;
        blendMode = BlendMode.ADD;
    }
    public function update():void {
        if (life < 0) return;
        time += unit;
        life = 1 - time*8;
        //
        var dx:Number = x - px;
        var dy:Number = y - py;
        var distance:Number = Math.sqrt(dx*dx + dy*dy);
        if (distance < 0.01) distance = 0.01;
        var rx:Number = dx/distance;
        var ry:Number = dy/distance;
        var tx:Number = rx;
        var ty:Number = ry;
        rx *= acceleration;
        ry *= acceleration;
        var _tx:Number = tx;
        tx = - ty*tacceleration;
        ty = _tx*tacceleration;
        vx += (rx + tx)*time;
        vy += (ry + ty)*time;
        x += vx*time;
        y += vy*time;
        scale = life;
        rotation = 360*time;
    }
    private function draw():void {
        var star:Bitmap = new Bitmap(particle.clone());
        addChild(star);
        star.x = - uint(star.width/2);
        star.y = - uint(star.height/2);
    }
    private function get scale():Number {
        return _scale;
    }
    private function set scale(value:Number):void {
        _scale = value;
        scaleX = scaleY = _scale;
    }

}


//////////////////////////////////////////////////
// ImageLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.LoaderContext;

class ImageLoader extends EventDispatcher {
    public var id:uint;
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:Bitmap;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function ImageLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(ImageLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(ImageLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(ImageLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        content = Bitmap(info.content);
        if (smoothing) {
            content.smoothing = true;
        }
        dispatchEvent(new Event(ImageLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        dispatchEvent(new Event(ImageLoader.COMPLETE));
    }

}


//////////////////////////////////////////////////
// FontLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.text.Font;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.ApplicationDomain;
import flash.system.SecurityDomain;
import flash.system.LoaderContext;
import flash.utils.getDefinitionByName;

class FontLoader extends EventDispatcher {
    public var id:uint;
    private var loader:Loader;
    private var info:LoaderInfo;
    private var _className:String;
    private var _font:Font;
    private var _fontName:String;
    private var embeded:Boolean = false;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function FontLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, name:String, e:Boolean = false):void {
        _className = name;
        embeded = e;
        info.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            var context:LoaderContext = new LoaderContext();
            context.applicationDomain = ApplicationDomain.currentDomain;
            context.securityDomain = SecurityDomain.currentDomain;
            loader.load(new URLRequest(file), context);
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(FontLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(FontLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(FontLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        dispatchEvent(new Event(FontLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        var FontClass:Class = Class(ApplicationDomain.currentDomain.getDefinition(className));
        if (!embeded) {
            Font.registerFont(FontClass);
            _font = Font(new FontClass());
        } else {
            var document:Object = new FontClass();
            _font = document.font;
        }
        _fontName = _font.fontName;
        dispatchEvent(new Event(FontLoader.COMPLETE));
    }
    public function get className():String {
        return _className;
    }
    public function get font():Font {
        return _font;
    }
    public function get fontName():String {
        return _fontName;
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "Myriad Pro Semibold";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        txt.embedFonts = true;
        txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
