/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oIBZ
 */

package {
    import flash.display.GradientType;
    import flash.display.InterpolationMethod;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;

    [SWF(width = '465', height = '465')]
    public class Holo2 extends Sprite
    {
        private var _holo2FX : Holo2FX;
        private var _emission : Emission;
        private var _container : Sprite;

        public function Holo2()
        {
            stage.stageFocusRect = tabChildren = tabEnabled = mouseChildren = mouseEnabled = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.MEDIUM;
            stage.fullScreenSourceRect = new Rectangle(0, 0, 465, 465);
            stage.frameRate = 64;
            opaqueBackground = stage.color = 0x0;

            /* */

            _container = new Sprite();

            var mtx : Matrix = new Matrix();
            mtx.createGradientBox(465, 465, 0, 0, 0);
            _container.graphics.beginGradientFill(GradientType.RADIAL, [0xF3F1EA, 0x48423F], [1, 1], [0, 255], mtx, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
            _container.graphics.drawRect(0, 0, 465, 465);
            _container.graphics.endFill();

            _container.addChild(_emission = new Emission());
            _emission.filters = [new GlowFilter(0x48423F, 0.85, 64.0, 64.0, 4, BitmapFilterQuality.LOW, false, true)];

            /* */

            _holo2FX = new Holo2FX();
            _holo2FX.opaqueBackground = 0x0;
            addChild(_holo2FX);

            /* */

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void {
            _emission.update();
            _holo2FX.update(_container);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.IBitmapDrawable;
import flash.display.Shape;
import flash.geom.Point;
import flash.geom.Rectangle;


internal class Holo2FX extends Bitmap {
    private var _srcBmd : BitmapData;
    private var _srcr : Rectangle;
    private var _dstp : Point;
    private var _lut : Vector.<Number>;
    private var _lutn : uint = uint(465 * Math.random());
    private var _fcnt : int = 7;

    function Holo2FX() {
        _srcBmd = new BitmapData(465, 465, false, 0x0);
        super(_srcBmd.clone());

        _srcr = new Rectangle(0, 0, 465, 1);
        _dstp = new Point();

        /* store perturbations in a LUT */

        _lut = new Vector.<Number>();

        var n : int = 465;
        while (--n != 0) {
            var line : uint = 465;
            while (line-- != 0) {
                _lut.push(8 * Math.tan(Math.cos((n / 465) * Math.PI * 2) * ((line / 465) * Math.PI * 2)));
            }
        }
        _lut.fixed = true;
    }

    public function update(src : IBitmapDrawable) : void {
        /* */

        _srcBmd.fillRect(_srcBmd.rect, 0x0);
        _srcBmd.draw(src);

        _fcnt++;

        /* */

        bitmapData.lock();

        var line : int = 465 - (_fcnt & 1);
        while (line >= 2) {
            line--;

            _lutn++;
            _lutn++;

            if (_lutn >= (_lut.length - 1)) _lutn = 0;

            _srcr.x = _lut[_lutn];
            _srcr.y = line;
            _dstp.y = line;

            bitmapData.copyPixels(_srcBmd, _srcr, _dstp);

            line--;

            _srcr.x = 0;
            _srcr.y = line;
            _dstp.y = line;

            bitmapData.copyPixels(_srcBmd, _srcr, _dstp);
        }

        bitmapData.unlock();
    }
}

internal class Emission extends Shape {
    private var a : Number = 0.0;

    function Emission() {
    }

    public function update() : void {
        a += 0.0033;
        var ampX : Number = 192 * Math.cos(a);
        var ampY : Number = 192 * Math.sin(a);

        graphics.clear();
        graphics.lineStyle(48, 0xFFFFFF, 1.0, false, 'none', 'none');
        graphics.drawCircle(232, 232, 96);
        graphics.moveTo(232 + ampX, 232 + ampY);
        graphics.lineTo(232 - ampX, 232 - ampY);
        graphics.moveTo(232 + ampX, 232 - ampY);
        graphics.lineTo(232 - ampX, 232 + ampY);
    }
}