/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oIAe
 */

/**
 * 文字を使って画像を描画してみた。
 * クリックで初期化。
 */
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="30")] 
	public class Main extends Sprite 
	{
		private var canvas:Bitmap;
		private var brush:Vector.<Brush>;
		private var lena:Bitmap;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			Wonderfl.capture_delay( 50 );
			var context:LoaderContext = new LoaderContext(true);
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE , this.loadCompleteHandler);
			loader.load(new URLRequest("http://demouth.net/wonderfl/src/?no=1"),context);
		}
		
		private function loadCompleteHandler(event:Event):void
		{
			this.lena = event.currentTarget.content as Bitmap;
			this.canvas = new Bitmap(new BitmapData(this.lena.bitmapData.width , this.lena.bitmapData.height));
			this.addChild(this.canvas);
			this.addEventListener(Event.ENTER_FRAME , this.enterFrameHandler);
			
			this.create();
			this.stage.addEventListener(MouseEvent.CLICK , this.reset);
		}
		private function reset(event:Event = null):void
		{
			var num:int = this.brush.length;
			for (var i:int = 0; i < num; i++) 
			{
				this.removeChild(this.brush[i]);
				this.brush[i] = null;
			}
			this.canvas.bitmapData = new BitmapData(this.lena.bitmapData.width , this.lena.bitmapData.height);
			this.create();
		}
		
		private function create():void
		{
			var num:int = 30;
			this.brush = new Vector.<Brush>(num);
			
			for (var i:int = 0; i < num; i++) 
			{
				this.brush[i] = new Brush(lena);
				this.addChild(this.brush[i]);
				this.brush[i].init(int((Math.random() * 30)+20), int(Math.random() * this.lena.bitmapData.width));
				this.brush[i].addEventListener("comp" , this.compHandler);
			}
		}
		
		private function compHandler(event:Event):void
		{
			var width:int = int((Math.random() * 15)+1);
			var x:int = int(Math.random() * this.lena.bitmapData.width);
			var speed:int = int(Math.random()*30)+5;
			if (Math.random() > 0.9) width += Math.random() * 40;
			else if(Math.random() < 0.3) width = int((Math.random() * 2)+1);
			event.target.init(width, x);
		}
		
		private function enterFrameHandler(event:Event):void
		{
			this.canvas.bitmapData.draw(this);
			
		}
		
	}
	
}
import flash.display.Bitmap;
import flash.display.Sprite
import flash.events.Event;
import flash.text.TextField;
class Brush extends Sprite
{
	private var r:uint = 0;
	private var g:uint = 0;
	private var b:uint = 0;
	private var brushWidth:int = 10;
	private var nowY:int = 0;
	private var nowX:int = 0;
	private var bitmap:Bitmap;
	
	private var text:TextField;
	
	public function Brush(bitmap:Bitmap)
	{
		this.setOriginal(bitmap);
	}
	
	public function init(brushWidth:int,x:int):void
	{
		if (this.hasEventListener(Event.ENTER_FRAME))
			this.removeEventListener(Event.ENTER_FRAME , this.next);
		this.nowX = x;
		this.nowY = 0;
		this.brushWidth = brushWidth;
		this.addEventListener(Event.ENTER_FRAME , this.next);
		
		if(this.text)this.removeChild(this.text);
		this.text = new TextField();
		this.addChild(this.text);
	}
	
	public function next(event:Event = null):void
	{
		var o:Object = this.getAverage();
		this.r = o.r; this.g = o.g; this.b = o.b;
		var color:uint = this.r << 16 | this.g << 8 | this.b;
		this.text.htmlText = "<font color='#"+color.toString(16)+"' size='"+ this.brushWidth +"'>" + this.getRandomString() + "</font>";
		this.text.x = this.nowX;
		this.text.y = this.nowY;
		this.nowY++;
		if (this.nowY > this.bitmap.bitmapData.height)
		{
			this.removeEventListener(Event.ENTER_FRAME , this.next);
			var e:Event = new Event("comp");
			this.dispatchEvent(e);
		}
	}
	
	private function getRandomString():String
	{
		//描画に使う適当な文字
		var ret:String = "a";
		var rand:Number = Math.random();
		if (rand < 0.1) ret = "a";
		else if (rand < 0.2) ret = "x";
		else if (rand < 0.3) ret = "e";
		else if (rand < 0.4) ret = "P";
		else if (rand < 0.5) ret = "N";
		else if (rand < 0.6) ret = "z";
		else if (rand < 0.7) ret = "3";
		else if (rand < 0.8) ret = "m";
		else if (rand < 0.9) ret = "t";
		
		return ret;
	}
	
	public function setOriginal(bitmap:Bitmap):void
	{
		this.bitmap = bitmap;
	}
	
	private function getAverage():Object
	{
		var length:int = this.brushWidth;
		var x:int = this.nowX;
		var y:int = this.nowY;
		var r:Number = 0;
		var g:Number = 0;
		var b:Number = 0;
		
		for (var i:int = 0; i < length; i++) 
		{
			var rgb:uint = this.bitmap.bitmapData.getPixel32(x + i, y);
			r += rgb>>16 & 0xFF;
			g += rgb>>8 & 0xFF;
			b += rgb & 0xFF;
		}
		r /= length;
		g /= length;
		b /= length;
		
		return {r:r , g:g ,b: b};
	}
	
}