/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oHwv
 */

package {
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    public class FlashTest extends Sprite {
        private var _cRect:Rect;
        private var _mRect:Rect;
        private var _yRect:Rect;
        
        public function FlashTest() {
            init();
        }
        private function init():void {
            _cRect = addRect(0x00FFFF);
            _mRect = addRect(0xFF00FF);
            _yRect = addRect(0xFFFF00);
            
            var timer:Timer = new Timer(1000);
            timer.addEventListener(TimerEvent.TIMER, moveRect);
            timer.start();
            moveRect(null);
        }
        
        private function addRect(color:Number):Rect {
            var rect:Rect = new Rect(color);
            rect.x = int(stage.stageWidth * Math.random());
            rect.y = int(stage.stageHeight * Math.random());
            addChild(rect);
            return rect;
        }
        
        private function moveRect(e:*):void {
            var toX:int = int(stage.stageWidth * Math.random());
            var toY:int = int(stage.stageHeight * Math.random());
            BetweenAS3.tween(
                _cRect,
                { x:toX, y:toY, _blurFilter:{blurX:0, blurY:0} },
                { _blurFilter:{blurX:10, blurY:10} },
                0.5,
                Back.easeOut
            ).play();
            BetweenAS3.delay(
                BetweenAS3.tween(
                    _mRect,
                    { x:toX+2, y:toY+2, _blurFilter:{blurX:0, blurY:0} },
                    { _blurFilter:{blurX:10, blurY:10} },
                    0.5,
                    Back.easeOut
                ),
                0.1
            ).play();
            BetweenAS3.delay(
                BetweenAS3.tween(
                    _yRect,
                    { x:toX+4, y:toY+4, _blurFilter:{blurX:0, blurY:0} },
                    { _blurFilter:{blurX:10, blurY:10} },
                    0.5,
                    Back.easeOut
                ),
                0.2
            ).play();
        }

    }
}

import flash.display.Sprite;
import flash.display.BlendMode;
internal class Rect extends Sprite {
    public function Rect(color:Number){
        graphics.beginFill(color);
        graphics.drawRect(-50, -50, 100, 100);
        graphics.endFill();
        blendMode = BlendMode.MULTIPLY;
    }
}