/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oHsT
 */

package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.utils.getTimer; 
	// @see http://projecteuler.net/index.php?section=problems&id=244
	public class Euler244 extends Sprite {
		private var _tf : TextField;
  
		public function Euler244() {
			_tf = new TextField();
			_tf.width = 465;
			_tf.height = 465;
			addChild(_tf);
			
			var s : int = getTimer();
			tr(solve());
			var g : int = getTimer();
			tr((g - s) + " ms");
		}

		private var NEXTS : Array = [
			[1, 4],
			[0, 2, 5],
			[1, 3, 6],
			[2, 7],
			[0, 5, 8],
			[1, 4, 6, 9],
			[2, 5, 7, 10],
			[3, 6, 11],
			[4, 9, 12],
			[5, 8, 10, 13],
			[6, 9, 11, 14],
			[7, 10, 15],
			[8, 13],
			[9, 12, 14],
			[10, 13, 15],
			[11, 14]
			];
			
		// 状態数が2^16*16程度なので普通にWFS
		// red,white:0, blue:1
		private function solve() : Number
		{
			var ASCII : Array = [];
			ASCII[-1] = 82;
			ASCII[1] = 76;
			ASCII[-4] = 68;
			ASCII[4] = 85;
			
			var state : Vector.<uint> = new Vector.<uint>((1 << 16) * 16);
			var queue : Vector.<uint> = new Vector.<uint>();
			state[0 << 16 | 0x3333] = 0;
			queue.push(0 << 16 | 0x3333);
			for(var step : uint = 0;step < 40 && !state[0x5a5a] && queue.length > 0;step++){
//				var next : Vector.<uint> = new Vector.<uint>();
				var next : Object = {};
				for each(var ind : uint in queue){
					var dir : int = (ind >> 20) - 4;
					ind &= 0xfffff;
					var s : uint = state[ind];
					var pos : uint = ind >> 16;
					for each(var p : uint in NEXTS[pos]){
						var c : uint = code(ind, pos, p);
						if(state[c] || c == 0x3333)continue;
						if(!next[c])next[c] = 0;
						next[c] += s * 243 + ASCII[p - pos];
						next[c] %= 100000007;
					}
				}
				
				queue = new Vector.<uint>();
				for(var key : String in next){
					queue.push(uint(key));
					state[uint(key)] = next[key];
				}
//					queue = next;
				tr(queue.length);
			}
			
			return state[0x5a5a];
		}
		
		private function code(s : uint, from : uint, to : uint) : uint
		{
			var f : uint = (s >> (15 - from)) & 1;
			var t : uint = (s >> (15 - to)) & 1;
			if(f != t){
				return to << 16 | ((s & 0xffff) ^ (1 << (15 - from)) ^ (1 << (15 - to)));
			}else{
				return to << 16 | (s & 0xffff);
			}
		}

		private function tr(...o : Array) : void
		{
			_tf.appendText(o + "\n");
			_tf.scrollV = _tf.maxScrollV;
		}
	}
}