/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oHVd
 */

//
// Conway's Game of Life running on all three channels independently, shader code in a comment at the end.
// http://johnblackburne.blogspot.co.uk/2012/03/3-channel-game-of-life-shader.html
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.ShaderFilter;
    import flash.geom.*;
    import mx.utils.*;

	[SWF(width="465", height="465", backgroundColor="#000000", frameRate="30")]
    public class Life2 extends Sprite {

        public static const asShader:Vector.<String> = Vector.<String>([
	"pQEAAACkBABMaWZloAxuYW1lc3BhY2UAAKAMdmVuZG9yAEpXQiBTb2Z0d2FyZQCg",
	"CHZlcnNpb24AAgCgDGRlc2NyaXB0aW9uAENvbndheSdzIGdhbWUgb2YgbGlmZQCh",
	"AQIAAAxfT3V0Q29vcmQAowAEc3JjAKECBAEAD2RzdAAyAAAgv4AAADIAABC/gAAA",
	"HQIAwQAAEAABAgDBAACwADADAPECABAAHQIA8wMAGwAyAAAgv4AAADIAABAAAAAA",
	"HQMAwQAAEAABAwDBAACwADAEAPEDABAAAQIA8wQAGwAyAAAgv4AAADIAABA/gAAA",
	"HQMAwQAAEAABAwDBAACwADAEAPEDABAAAQIA8wQAGwAyAAAgAAAAADIAABC/gAAA",
	"HQMAwQAAEAABAwDBAACwADAEAPEDABAAAQIA8wQAGwAyAAAgAAAAADIAABA/gAAA",
	"HQMAwQAAEAABAwDBAACwADAEAPEDABAAAQIA8wQAGwAyAAAgP4AAADIAABC/gAAA",
	"HQMAwQAAEAABAwDBAACwADAEAPEDABAAAQIA8wQAGwAyAAAgP4AAADIAABAAAAAA",
	"HQMAwQAAEAABAwDBAACwADAEAPEDABAAAQIA8wQAGwAyAAAgP4AAADIAABA/gAAA",
	"HQMAwQAAEAABAwDBAACwADAEAPEDABAAAQIA8wQAGwAyAAAgQEAAAB0AABACAAAA",
	"AgAAEAAAgAAYAAAgAADAADIAABA/AAAAKgAAIAAAwAAdAYCAAIAAADIAACA/gAAA",
	"MgAAEAAAAAAzAwCAAYAAAAAAgAAAAMAAHQAAIAMAAAAyAAAQQCAAAB0DAIACAAAA",
	"AgMAgAAAwAAYAAAQAwAAADIDAIA/gAAAKgAAEAMAAAAdAYCAAIAAADIAABA/gAAA",
	"MgMAgAAAAAAzAwBAAYAAAAAAwAADAAAAHQAAEAMAQAAwAwDxAAAQADIDAEA/AAAA",
	"KgMAQAMAAAAdAYCAAIAAADMDAIABgAAAAADAAAAAgAAdAwBAAwAAADIDAIBAQAAA",
	"HQMAIAIAQAACAwAgAwAAABgDAIADAIAAMgMAID8AAAAqAwCAAwCAAB0BgIAAgAAA",
	"MgMAgD+AAAAyAwAgAAAAADMDABABgAAAAwAAAAMAgAAdAAAgAwDAADIDAIBAIAAA",
	"HQMAIAIAQAACAwAgAwAAABgDAIADAIAAMgMAID+AAAAqAwCAAwCAAB0BgIAAgAAA",
	"MgMAgD+AAAAyAwAgAAAAADMDABABgAAAAwAAAAMAgAAdAAAQAwDAADAEAPEAABAA",
	"MgMAgD8AAAAqAwCABABAAB0BgIAAgAAAMwMAgAGAAAAAAMAAAACAAB0DACADAAAA",
	"MgMAgEBAAAAdAwAQAgCAAAIDABADAAAAGAMAgAMAwAAyAwAQPwAAACoDAIADAMAA",
	"HQGAgACAAAAyAwCAP4AAADIDABAAAAAAMwQAgAGAAAADAAAAAwDAAB0AACAEAAAA",
	"MgMAgEAgAAAdAwAQAgCAAAIDABADAAAAGAMAgAMAwAAyAwAQP4AAACoDAIADAMAA",
	"HQGAgACAAAAyAwCAP4AAADIDABAAAAAAMwQAgAGAAAADAAAAAwDAAB0AABAEAAAA",
	"MAQA8QAAEAAyAwCAPwAAACoDAIAEAIAAHQGAgACAAAAzAwCAAYAAAAAAwAAAAIAA",
	"HQMAEAMAAAAdBACAAwBAAB0EAEADAIAAHQQAIAMAwAAyAwCAP4AAAB0EABADAAAA",
	"HQEA8wQAGwA="])

        public var filter:ShaderFilter, shader:Shader;
        public var fX:Number, fY:Number, fZ:Number;
        public var iMode:int;
        public var dat:BitmapData, pt:Point = new Point(0, 0);
        
        function Life2() {
            Make();
        }
        
        public function Make():void {
			dat = new BitmapData(stage.stageWidth,stage.stageHeight);
			addChild(new Bitmap(dat));
        	var iR:uint, iG:uint, iB:uint;
        	var vec:Vector.<uint> = dat.getVector(dat.rect);
        	for (var i:int = vec.length - 1; i >= 0; i--) {
        		iR = Math.random() > 0.5 ? 0x00 : 0xff;
        		iG = Math.random() > 0.5 ? 0x00 : 0xff;
        		iB = Math.random() > 0.5 ? 0x00 : 0xff;
        		vec[i] = 0xff000000 + (((iR << 8) + iG) << 8) + iB;
        	}
        	dat.setVector(dat.rect, vec);
        	
            var dec:Base64Decoder = new Base64Decoder;
            dec.decode(asShader.join(""));
            filter = new ShaderFilter(shader = new Shader(dec.drain()));
            stage.addEventListener(Event.ENTER_FRAME, Tick);
        }
        
        public function Tick(ev:Event):void {
        	dat.applyFilter(dat, dat.rect, pt, filter);
        }
    }
}
/*
<languageVersion: 1.0;>

// Life:
kernel Life
<   namespace : "";
    vendor : "JWB Software";
    version : 2;
    description : "Conway's game of life"; >
{
    input image4 src;
    output float4 dst;
    
    // evaluatePixel(): The function of the filter that actually does the 
    //                  processing of the image.  This function is called once 
    //                  for each pixel of the output image.
    void
    evaluatePixel()
    {
        float4 neighbours = sampleNearest(src, outCoord() + float2(-1.0, -1.0));
        neighbours += sampleNearest(src, outCoord() + float2(-1.0, 0.0));
        neighbours += sampleNearest(src, outCoord() + float2(-1.0, 1.0));
        neighbours += sampleNearest(src, outCoord() + float2(0.0, -1.0));
        neighbours += sampleNearest(src, outCoord() + float2(0.0, 1.0));
        neighbours += sampleNearest(src, outCoord() + float2(1.0, -1.0));
        neighbours += sampleNearest(src, outCoord() + float2(1.0, 0.0));
        neighbours += sampleNearest(src, outCoord() + float2(1.0, 1.0));

        float deadTo = abs(neighbours.r - 3.0) < 0.5 ? 1.0 : 0.0;
        float liveTo = abs(neighbours.r - 2.5) < 1.0 ? 1.0 : 0.0;
        float goesToR = sampleNearest(src, outCoord()).r > 0.5 ? liveTo : deadTo;


        deadTo = abs(neighbours.g - 3.0) < 0.5 ? 1.0 : 0.0;
        liveTo = abs(neighbours.g - 2.5) < 1.0 ? 1.0 : 0.0;
        float goesToG = sampleNearest(src, outCoord()).g > 0.5 ? liveTo : deadTo;

        deadTo = abs(neighbours.b - 3.0) < 0.5 ? 1.0 : 0.0;
        liveTo = abs(neighbours.b - 2.5) < 1.0 ? 1.0 : 0.0;
        float goesToB = sampleNearest(src, outCoord()).b > 0.5 ? liveTo : deadTo;


        dst = float4(goesToR, goesToG, goesToB, 1.0);
    }
}
*/