/**
 * Copyright kanariia ( http://wonderfl.net/user/kanariia )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oHAk
 */

package {

	import flash.display.Sprite;
	import flash.display.Stage;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;


	[SWF(width="200", height="200", frameRate="60", backgroundColor="#ffffff")]

	public class PerlinNoiseTest extends Sprite {

		// -------------------- プロパティ --------------------
		private var bmd : BitmapData;
		private var w   : uint = 200;
		private var h   : uint = 200;

		// perlinNoise 用変数
		private var octaves  : uint  = 6;
		private var seed     : Number;
		private var channels : uint  = BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE;
		private var offset   : Array = new Array();
		private var offxy    : Array = new Array();
		private var dist     : uint  = 6;

		private var flg      : Boolean = false;


		// -------------------- メソッド --------------------
		// コンストラクタ
		public function PerlinNoiseTest() {
			if ( this.stage != null ) { init( this.stage ); }
		}


		public function init( s:Stage ):void {
			// create BitmapData and Bitmap
			bmd           = new BitmapData( w , h , false , 0x00cccccc );
			var bm:Bitmap = new Bitmap( bmd );
			addChild( bm );

			// setup value for perlinNoise
			setup();

			// handler
			stage.addEventListener( MouseEvent.CLICK , clickHandler );
                        addEventListener( Event.ENTER_FRAME , onEnterFrameHandler );
		}


		// setup value for perlinNoise
		private function setup():void {
			seed = Math.floor( Math.random()*0xffff );
			for ( var i:int=0; i<octaves; i++ ) {
				offset[i] = new Point( Math.random()*w , Math.random()*h );
				offxy[i]    = new Array(2);
				offxy[i][0] = Math.random()*dist - dist*0.5;
				offxy[i][1] = Math.random()*dist - dist*0.5;
			}
		}


		// handler
		private function clickHandler( e:MouseEvent ):void {
			flg = !flg;
			if ( flg ) {
				setup();
				addEventListener( Event.ENTER_FRAME , onEnterFrameHandler );
			} else {
				removeEventListener( Event.ENTER_FRAME , onEnterFrameHandler );
			}
		}

		private function onEnterFrameHandler( e:Event ):void {
			for ( var i:int=0; i<octaves; i++ ) {
				offset[i].x += offxy[i][0];
				offset[i].y += offxy[i][1];
			}
			bmd.perlinNoise( w , h , octaves , seed , false , true , channels , false , offset );
		}

	}
}
