/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oH2x
 */

package 
{
    import flash.display.StageAlign;
    import flash.display.StageDisplayState;
    import flash.display.StageScaleMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    import com.bit101.components.PushButton;
    
    /**
     * ...
     * @author gaina
     */
    public class Main extends Sprite 
    {
        
        private var w:Number;
        private var h:Number;
        
        private var w_text:TextField;
        private var h_text:TextField;
        
        private var sp_array:Array = [];
        
        private var btn:PushButton;
        
        public function Main():void 
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            w_text = new TextField();
            w_text.text = w.toString();
            w_text.autoSize = TextFieldAutoSize.LEFT;
            addChild(w_text);
            
            h_text = new TextField();
            h_text.text = h.toString();
            h_text.autoSize = TextFieldAutoSize.LEFT;
            addChild(h_text);
            h_text.y = w_text.height;
            
            sp_array = Circles();
            
            btn = new PushButton(stage, 0, 0, "FULL SCREEN", FullScreenMode);
            btn.x = w - btn.width;
            
            stage.addEventListener(Event.RESIZE, ResizeEventHandler);
        }
        
        private function FullScreenMode(e:Event):void
        {
            if (stage.displayState == StageDisplayState.NORMAL)
            {
                stage.displayState = StageDisplayState.FULL_SCREEN;
                btn.label = "NORMAL";
            }
            else
            {
                stage.displayState = StageDisplayState.NORMAL;
                btn.label = "FULL SCREEN";
            }
        }
        
        private function ResizeEventHandler(e:Event):void 
        {
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            w_text.text = w.toString();
            h_text.text = h.toString();
            
            btn.x = w - btn.width;
            
            for (var i:int; i < sp_array.length; i++)
            {
                var _sp:Sprite = sp_array[i] as Sprite;
                //_sp.x = 10 + 50 * i;
                _sp.y = h - 15;
            }
        }
        
        private function Circles():Array
        {
            var _array:Array = [];
            for (var i:int = 0; i < 12; i++)
            {
                var _sp:Sprite = new Sprite();
                _sp.graphics.beginFill(0);
                _sp.graphics.drawCircle(5, 5, 5);
                _sp.graphics.endFill();
                _sp.x = 10 + 30 * i;
                _sp.y = h - 15;
                addChild(_sp);
                _array.push(_sp);
            }
            return _array;
        }
        
    }
    
}