/**
 * Copyright 9balls ( http://wonderfl.net/user/9balls )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oH2rr
 */

package {
    import com.bit101.components.ColorChooser;
    import com.bit101.components.ComboBox;
    import com.bit101.components.Label;
    import com.bit101.components.NumericStepper;
    import com.bit101.components.Panel;
    import com.bit101.components.RadioButton;
    import com.bit101.components.Window;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.Font;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;

    public class Main extends Sprite {
        private var window:Window;
        private var data:Array;
        //
        private var tf:TextField = new TextField();
        private var format:TextFormat;
        private var panel:Panel;
        private var fontList:Array;

        public function Main(){
            //
            window = new Window(this, 0, 0, "");
            window.width = window.height = 465;
            window.draggable = false;

            var drop:DropShadow = new DropShadow(tf);
            var blur:Blur = new Blur(tf);
            var glow:Glow = new Glow(tf);
            var bevel:Bevel = new Bevel(tf);

            window.content.addChild(bevel);
            window.content.addChild(glow);
            window.content.addChild(blur);
            window.content.addChild(drop);

            panel = new Panel(window.content, 0, 0);
            panel.color = 0xffffff;
            panel.width = 465;
            panel.height = 180;
            panel.x = 0;
            panel.y = 30;
            //
            tf.text = "test";
            tf.autoSize = TextFieldAutoSize.CENTER;
            tf.type = TextFieldType.INPUT;
            tf.textColor = 0xED1A3D;
            format = new TextFormat();
            format.align = TextFormatAlign.CENTER;
            format.size = 60;
            setTf();
            panel.addChild(tf);
            //
            var allFonts:Array = Font.enumerateFonts(true);
            allFonts.sortOn("fontName", Array.CASEINSENSITIVE);
            fontList = [];
            var fontNameList:Array = [];
            var length:int = allFonts.length;
            var n:uint = 0;
            for (var i:int = 0; i < length; i++){
                var fontName:String = allFonts[i].fontName;
                if (strIsEnglish(fontName)){
                    fontNameList.push(n + " : " + fontName);
                    fontList.push(fontName);
                    n++;
                }
            }

            var fontComnbo:ComboBox = new ComboBox(window.content, 5, 0, "font", fontNameList);
            //fontComnbo.addEventListener(Event.SELECT, onFont);
            fontComnbo.width = 200;
            fontComnbo.selectedItem = "Times New Roman";
            var fontStepper:NumericStepper = new NumericStepper(window.content, 220, 0, onFont);
            fontStepper.minimum = 0;
            fontStepper.maximum = n;
            fontStepper.value = 0;
            var alpha1:Label = new Label(window.content, 100, 210, "font size");
            var stepper:NumericStepper = new NumericStepper(window.content, 100, 230, onFontSize);
            stepper.minimum = 10;
            stepper.maximum = 127;
            stepper.value = 60;
            new Label(window.content, 5, 210, "Background Color");
            var cc:ColorChooser = new ColorChooser(window.content, 5, 230, 0xffffff, onPanelColor);
            cc.usePopup = true;

            data = [drop, glow, bevel, blur];

            var d:RadioButton = new RadioButton(window.titleBar, 5, 6, "DropShadow", true, toggle);
            var g:RadioButton = new RadioButton(window.titleBar, 105, 6, "Glow", false, toggle);
            var be:RadioButton = new RadioButton(window.titleBar, 205, 6, "Bevel", false, toggle);
            var b:RadioButton = new RadioButton(window.titleBar, 305, 6, "Blur", false, toggle);
            d.name = "0", b.name = "3", be.name = "2", g.name = "1";

            d.groupName = b.groupName = be.groupName = g.groupName = "parent";
        }

        private function toggle(event:Event):void {
            for (var i:int = 0; i < data.length; i++)
                data[i].visible = false;
            data[int(event.currentTarget.name)].selected();
        }

        private function onFont(e:Event):void {
            //format.font = fontList[(e.currentTarget as ComboBox).selectedIndex];
            format.font = fontList[(e.currentTarget as NumericStepper).value];
            setTf();
        }

        private function onFontSize(e:Event):void {
            format.size = (e.currentTarget as NumericStepper).value;
            setTf();
        }

        private function onPanelColor(e:Event):void {
            panel.color = (e.currentTarget as ColorChooser).value;
        }

        private function setTf():void {
            tf.setTextFormat(format);
            tf.x = (465 - tf.width) / 2;
            tf.y = (180 - tf.height) / 2;
        }

        public function strIsEnglish(str:String):Boolean {
            var length:uint = str.length
            for (var i:int = 0; i < length; i++){
                if (str.charCodeAt(i) >= 256){
                    return false;
                }
            }
            return true;
        }


    }
}


import com.bit101.components.CheckBox;
import com.bit101.components.ColorChooser;
import com.bit101.components.HUISlider;
import com.bit101.components.Label;
import com.bit101.components.NumericStepper;
import com.bit101.components.Panel;
import com.bit101.components.PushButton;
import com.bit101.components.RadioButton;
import com.bit101.components.Window;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.*;
import flash.system.System;
import flash.text.TextField;

class DropShadow extends Sprite {
    private var window:Panel;
    private var distance:HUISlider;
    private var angle:HUISlider;
    private var cc:ColorChooser;
    private var stepper:NumericStepper;
    private var stepper2:NumericStepper;
    private var scc:ColorChooser;
    private var blurX:HUISlider;
    private var blurY:HUISlider;
    private var strength:HUISlider;
    private var inner:CheckBox;
    private var knockout:CheckBox;
    private var hide:CheckBox;
    private var quality:Window;
    private var low:RadioButton;
    private var medium:RadioButton;
    private var high:RadioButton;
    //
    private var tf:TextField;

    public function DropShadow(tf:TextField){
        this.tf = tf;
        //
        window = new Panel(this, 0, 0);
        window.width = window.height = 465;
        distance = new HUISlider(window.content, 5, 280, "distance", onChange);
        angle = new HUISlider(window.content, 5, 300, "angle", onChange);

        new Label(window.content, 5, 340, "Color");
        cc = new ColorChooser(window.content, 5, 360, 0x0, function(event:Event):void {
                tf.textColor = cc.value;
            });
        var alpha1:Label = new Label(window.content, 100, 340, "alpha");
        stepper = new NumericStepper(this, 100, 360, function(event:Event):void {
                tf.alpha = stepper.value;
            });

        new Label(window.content, 5, 400, "Color of the shadow");
        scc = new ColorChooser(window.content, 5, 420, 0x0, onChange);
        var alpha2:Label = new Label(window.content, 100, 400, "alpha");
        stepper2 = new NumericStepper(this, 100, 420, onChange);

        blurX = new HUISlider(window.content, 280, 280, "blurX", onChange);
        blurY = new HUISlider(window.content, 280, 300, "blurY", onChange);
        strength = new HUISlider(window.content, 280, 320, "strength", onChange);

        inner = new CheckBox(window.content, 280, 360, "inner", onChange);
        knockout = new CheckBox(window.content, 280, 380, "knockout", onChange);
        hide = new CheckBox(window.content, 280, 400, "hideObject", onChange);

        quality = new Window(window.content, 360, 340, "quality");
        low = new RadioButton(quality.content, 5, 5, "LOW", true, onChange);
        medium = new RadioButton(quality.content, 5, 25, "MEDIUM", false, onChange);
        high = new RadioButton(quality.content, 5, 45, "HIGH", false, onChange);
        low.groupName = medium.groupName = high.groupName = "dropshadow";

        distance.value = 4;
        angle.value = 45;
        angle.maximum = 360;
        blurX.value = blurY.value = 4;
        strength.minimum = strength.value = 1;
        strength.maximum = 30;
        cc.value = 0xED1A3D;
        cc.usePopup = scc.usePopup = true;
        cc.popupAlign = scc.popupAlign = ColorChooser.TOP;
        stepper.step = stepper2.step = 0.1;
        stepper.value = stepper2.value = stepper.maximum = stepper2.maximum = 1.0;
        stepper.minimum = stepper2.minimum = 0;

        onChange();

        new PushButton(window, 365, 0, "Copy to Clipboard", copy);
    }

    private function copy(event:Event):void {
        var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
        var str:String = "new DropShadowFilter(" + distance.value + "," + angle.value + ",0x" + scc.value.toString(16).toUpperCase() + "," + stepper2.value.toFixed(1) + "," + blurX.value + "," + blurY.value + "," + strength.value + "," + q + "," + inner.selected + "," + knockout.selected + "," + hide.selected + ")";
        System.setClipboard(str);
    }

    private function onChange(event:Event = null):void {
        var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
        tf.filters = [new DropShadowFilter(distance.value, angle.value, scc.value, stepper2.value, blurX.value, blurY.value, strength.value, q, inner.selected, knockout.selected, hide.selected)];
    }

    public function selected():void {
        this.visible = true;
        tf.textColor = cc.value;
        tf.alpha = stepper.value;
        onChange(null);
    }
}

class Glow extends Sprite {
    private var window:Panel;
    private var cc:ColorChooser;
    private var stepper:NumericStepper;
    private var stepper2:NumericStepper;
    private var scc:ColorChooser;
    private var blurX:HUISlider;
    private var blurY:HUISlider;
    private var strength:HUISlider;
    private var inner:CheckBox;
    private var knockout:CheckBox;
    private var quality:Window;
    private var low:RadioButton;
    private var medium:RadioButton;
    private var high:RadioButton;
    //
    private var tf:TextField;


    public function Glow(tf:TextField){
        this.tf = tf;
        //
        window = new Panel(this, 0, 0);
        window.width = window.height = 465;

        new Label(window.content, 5, 280, "Color");
        cc = new ColorChooser(window.content, 5, 300, 0x0, function(event:Event):void {
                tf.textColor = cc.value;
            });
        var alpha1:Label = new Label(window.content, 100, 280, "alpha");
        stepper = new NumericStepper(this, 100, 300, function(event:Event):void {
                tf.alpha = stepper.value;
            });

        new Label(window.content, 5, 340, "Color of the shadow");
        scc = new ColorChooser(window.content, 5, 360, 0x0, onChange);
        var alpha2:Label = new Label(window.content, 100, 340, "alpha");
        stepper2 = new NumericStepper(this, 100, 360, onChange);

        blurX = new HUISlider(window.content, 280, 280, "blurX", onChange);
        blurY = new HUISlider(window.content, 280, 300, "blurY", onChange);
        strength = new HUISlider(window.content, 280, 320, "strength", onChange);

        inner = new CheckBox(window.content, 280, 360, "inner", onChange);
        knockout = new CheckBox(window.content, 280, 380, "knockout", onChange);

        quality = new Window(window.content, 360, 340, "quality");
        low = new RadioButton(quality.content, 5, 5, "LOW", true, onChange);
        medium = new RadioButton(quality.content, 5, 25, "MEDIUM", false, onChange);
        high = new RadioButton(quality.content, 5, 45, "HIGH", false, onChange);
        low.groupName = medium.groupName = high.groupName = "glow";

        blurX.value = blurY.value = 4;
        strength.minimum = strength.value = 1;
        strength.maximum = 30;
        cc.value = 0x0;
        scc.value = 0x009AD6;
        cc.usePopup = scc.usePopup = true;
        cc.popupAlign = scc.popupAlign = ColorChooser.TOP;
        stepper.step = stepper2.step = 0.1;
        stepper.value = stepper2.value = stepper.maximum = stepper2.maximum = 1.0;
        stepper.minimum = stepper2.minimum = 0;

        onChange();

        new PushButton(window, 365, 0, "Copy to Clipboard", copy);
    }

    private function copy(event:Event):void {
        var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
        var str:String = "new GlowFilter(0x" + scc.value.toString(16).toUpperCase() + "," + stepper2.value.toFixed(1) + "," + blurX.value + "," + blurY.value + "," + strength.value + "," + q + "," + inner.selected + "," + knockout.selected + ")";
        System.setClipboard(str);
    }

    private function onChange(event:Event = null):void {
        var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
        tf.filters = [new GlowFilter(scc.value, stepper2.value, blurX.value, blurY.value, strength.value, q, inner.selected, knockout.selected)];
    }

    public function selected():void {
        this.visible = true;
        tf.textColor = cc.value;
        tf.alpha = stepper.value;
        onChange(null);
    }
}

class Bevel extends Sprite {
    private var window:Panel;
    private var cc:ColorChooser;
    private var distance:HUISlider;
    private var angle:HUISlider;
    private var stepper:NumericStepper;
    private var stepper2:NumericStepper;
    private var stepper3:NumericStepper;
    private var scc:ColorChooser;
    private var hcc:ColorChooser;
    private var blurX:HUISlider;
    private var blurY:HUISlider;
    private var strength:HUISlider;
    private var knockout:CheckBox;
    private var quality:Window;
    private var type:Window;
    private var inner:RadioButton;
    private var outer:RadioButton;
    private var full:RadioButton;
    private var low:RadioButton;
    private var medium:RadioButton;
    private var high:RadioButton;
    //
    private var tf:TextField = new TextField();


    public function Bevel(tf:TextField){
        this.tf = tf;
        //
        window = new Panel(this, 0, 0);
        window.width = window.height = 465;


        new Label(window.content, 5, 280, "Color");
        cc = new ColorChooser(window.content, 5, 300, 0x0, function(event:Event):void {
                tf.textColor = cc.value;
            });
        new Label(window.content, 100, 280, "alpha");
        stepper = new NumericStepper(this, 100, 300, function(event:Event):void {
                tf.alpha = stepper.value;
            });

        new Label(window.content, 5, 340, "Color of the shadow");
        scc = new ColorChooser(window.content, 5, 360, 0x0, onChange);
        new Label(window.content, 100, 340, "alpha");
        stepper2 = new NumericStepper(this, 100, 360, onChange);

        new Label(window.content, 5, 400, "Color of the highlight");
        hcc = new ColorChooser(window.content, 5, 420, 0x0, onChange);
        new Label(window.content, 100, 400, "alpha");
        stepper3 = new NumericStepper(this, 100, 420, onChange);

        distance = new HUISlider(window.content, 280, 220, "distance", onChange);
        angle = new HUISlider(window.content, 280, 240, "angle", onChange);
        blurX = new HUISlider(window.content, 280, 260, "blurX", onChange);
        blurY = new HUISlider(window.content, 280, 280, "blurY", onChange);
        strength = new HUISlider(window.content, 280, 300, "strength", onChange);
        knockout = new CheckBox(window.content, 280, 320, "knockout", onChange);

        type = new Window(window.content, 240, 340, "type");
        inner = new RadioButton(type.content, 5, 5, "INNER", true, onChange);
        outer = new RadioButton(type.content, 5, 25, "OUTER", false, onChange);
        full = new RadioButton(type.content, 5, 45, "FULL", false, onChange);
        inner.groupName = outer.groupName = full.groupName = "bevel_type";

        quality = new Window(window.content, 360, 340, "quality");
        low = new RadioButton(quality.content, 5, 5, "LOW", true, onChange);
        medium = new RadioButton(quality.content, 5, 25, "MEDIUM", false, onChange);
        high = new RadioButton(quality.content, 5, 45, "HIGH", false, onChange);
        low.groupName = medium.groupName = high.groupName = "bevel_quality";

        distance.value = 4;
        angle.value = 45;
        angle.maximum = 360;
        blurX.value = blurY.value = 4;
        strength.minimum = strength.value = 1;
        strength.maximum = 30;
        cc.value = 0xED1A3D;
        scc.value = 0x0;
        hcc.value = 0xFFFFFF;
        cc.usePopup = scc.usePopup = hcc.usePopup = true;
        cc.popupAlign = scc.popupAlign = hcc.popupAlign = ColorChooser.TOP;
        stepper.step = stepper2.step = stepper3.step = 0.1;
        stepper.value = stepper2.value = stepper3.value = stepper.maximum = stepper2.maximum = stepper3.maximum = 1.0;
        stepper.minimum = stepper2.minimum = stepper3.minimum = 0;

        onChange();

        new PushButton(window, 365, 0, "Copy to Clipboard", copy);
    }

    private function copy(event:Event):void {
        var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
        var t:String = (inner.selected) ? "inner" : (outer.selected) ? "outer" : "full";
        var str:String = "new BevelFilter(" + distance.value + "," + angle.value + ",0x" + hcc.value.toString(16).toUpperCase() + "," + stepper3.value.toFixed(1) + ",0x" + scc.value.toString(16).toUpperCase() + "," + stepper2.value.toFixed(1) + "," + blurX.value + "," + blurY.value + "," + strength.value + "," + q + ",\"" + t + "\"," + knockout.selected + ")";
        System.setClipboard(str);
    }

    private function onChange(event:Event = null):void {
        var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
        var t:String = (inner.selected) ? "inner" : (outer.selected) ? "outer" : "full";
        tf.filters = [new BevelFilter(distance.value, angle.value, hcc.value, stepper3.value, scc.value, stepper2.value, blurX.value, blurY.value, strength.value, q, t, knockout.selected)];
    }

    public function selected():void {
        this.visible = true;
        tf.textColor = cc.value;
        tf.alpha = stepper.value;
        onChange(null);
    }
}

class Blur extends Sprite {
    private var window:Panel;
    private var cc:ColorChooser;
    private var stepper:NumericStepper;
    private var blurX:HUISlider;
    private var blurY:HUISlider;
    private var quality:Window;
    private var low:RadioButton;
    private var medium:RadioButton;
    private var high:RadioButton;
    private var rect:Sprite;
    //
    private var tf:TextField = new TextField();


    public function Blur(tf:TextField){
        this.tf = tf;
        //
        window = new Panel(this, 0, 0);
        window.width = window.height = 465;

        new Label(window.content, 5, 280, "Color");
        cc = new ColorChooser(window.content, 5, 300, 0x0, function(event:Event):void {
                tf.textColor = cc.value;
            });
        var alpha1:Label = new Label(window.content, 100, 280, "alpha");
        stepper = new NumericStepper(this, 100, 300, function(event:Event):void {
                tf.alpha = stepper.value;
            });

        blurX = new HUISlider(window.content, 280, 280, "blurX", onChange);
        blurY = new HUISlider(window.content, 280, 300, "blurY", onChange);

        quality = new Window(window.content, 360, 340, "quality");
        low = new RadioButton(quality.content, 5, 5, "LOW", true, onChange);
        medium = new RadioButton(quality.content, 5, 25, "MEDIUM", false, onChange);
        high = new RadioButton(quality.content, 5, 45, "HIGH", false, onChange);
        low.groupName = medium.groupName = high.groupName = "blur";

        blurX.value = blurY.value = 4;
        stepper.value = stepper.maximum = 1.0;
        stepper.step = 0.1;
        stepper.minimum = 0;
        cc.value = 0xED1A3D;
        cc.usePopup = true;
        cc.popupAlign = ColorChooser.BOTTOM;

        onChange();

        new PushButton(window, 365, 0, "Copy to Clipboard", copy);
    }

    private function copy(event:Event):void {
        var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
        var str:String = "new BlurFilter(" + blurX.value + "," + blurY.value + "," + q + ")";
        System.setClipboard(str);
    }

    private function onChange(event:Event = null):void {
        var q:int = (low.selected) ? 1 : (medium.selected) ? 2 : 3;
        tf.filters = [new BlurFilter(blurX.value, blurY.value, q)];
    }

    public function selected():void {
        this.visible = true;
        tf.textColor = cc.value;
        tf.alpha = stepper.value;
        onChange(null);
    }
}