/**
 * Copyright Thumasz ( http://wonderfl.net/user/Thumasz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oGsL
 */

// forked from Thumas's Circular Arkanoid
package {
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.display.BitmapData;
    import flash.display.Bitmap
    import flash.display.Sprite;
    import flash.display.GradientType
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width=465, height=465, frameRate=30, backgroundColor=0)]
    public class FlashTest extends Sprite {
        public var staticBmd:BitmapData;
        public var parBmd:BitmapData;
        public var backBmd:BitmapData;//Cannot get backgroundcolor working :/
        public var showBmd:BitmapData;
        
        public var backBit:Bitmap;
        
        public var w:int = 465;
        public var h:int = 465;
        
        public var paddle:Sprite;
        
        public var parList:Vector.<Object>;
        
        private var _lux:LuxMod;
        
        public function FlashTest() {
            
            showBmd = new BitmapData(w,h, true, 0xFF000000);
            
            staticBmd = new BitmapData(w,h,true,0);
            parBmd = new BitmapData(w,h,true,0);
            backBmd = new BitmapData(w,h,false,0);
            
            parList = new Vector.<Object>();
            
            paddle = new Sprite();
            
            paddle.graphics.beginFill(0x00FF00,1);
            paddle.graphics.drawRect(-50,-10,100,20);
            paddle.graphics.endFill();
            
            var circle:Sprite = new Sprite();
            var mat:Matrix=new Matrix();
            
            var colors:Array=[0xFF0000,0xFFFF00,0x00FF00,0x00FFFF,0x0000FF,0xFF00FF,0xFF0000];
            var alphas:Array=[1,1,1,1,1,1,1];
            var ratios:Array=[0,5,10,15,20,25,30];
            circle.graphics.beginGradientFill(GradientType.RADIAL,colors,alphas,ratios,mat);
            circle.graphics.drawCircle(0,0,100);
            circle.graphics.endFill();
            
            backBit = new Bitmap(showBmd);
            
            addChild(paddle);
            
            mat.translate(w*0.5,h*0.5);
            
            staticBmd.draw(circle,mat);
            
            _lux = new LuxMod(backBit);

            addChild(_lux);
            
            addEventListener(Event.ENTER_FRAME,update);
            
            backBit.addEventListener(MouseEvent.CLICK,click);
        }
        
        public function click(e:MouseEvent):void{
            if(stage.displayState == "fullScreen"){
                stage.displayState = "normal";
            }else{
                stage.displayState = "fullScreen";
            }
        }

        
        public function update(e:Event):void{
            
            showBmd.fillRect(showBmd.rect,0xFF000000);
            
            parBmd.colorTransform(parBmd.rect,new ColorTransform(1,1,1,0.9,0,0,0,0));
            
            var dx:Number = mouseX-(w*0.5);
            var dy:Number = mouseY-(h*0.5);
            var ang:Number = Math.atan2(dy,dx);
            
            paddle.x = Math.cos(ang)*(w*0.5)+w*0.5;
            paddle.y = Math.sin(ang)*(h*0.5)+h*0.5;
            paddle.rotation = ang*180/Math.PI+90
            
            if(parList.length ==0){
                createParticle(paddle.x,paddle.y,Math.cos(ang)*2,Math.sin(ang)*2,0xFFFFFFFF);
            }
            
            for(var i:int = 0;i<parList.length;i++){
                var p:Object = parList[i];
                
                p.x += p.vx;
                p.y += p.vy;
                
                parBmd.setPixel32(p.x,p.y,p.c);
                
                if(staticBmd.getPixel32(p.x,p.y)!=0){
                    createParticle(p.x,p.y,-p.vx,-p.vy,staticBmd.getPixel32(p.x,p.y));
                    staticBmd.setPixel32(p.x,p.y,0);
                    
                     p.dx= p.x - (w*0.5);
                     p.dy= p.y - (h*0.5);
                     p.ang = Math.atan2(p.dy,p.dx);
                     p.x += Math.cos(p.ang)*5
                     p.y += Math.sin(p.ang)*5
                     p.vx = Math.cos(p.ang+Math.random()*0.15-0.075)*2
                     p.vy = Math.sin(p.ang+Math.random()*0.15-0.075)*2
                }
                   
                if(paddle.hitTestPoint(p.x,p.y,true)){
                    p.dx= p.x - (w*0.5);
                     p.dy= p.y - (h*0.5);
                     p.ang = Math.atan2(p.dy,p.dx);
                     
                     var dif:Number = (p.ang-ang)*4;
                     p.vx = -Math.cos(ang+dif)*2
                     p.vy = -Math.sin(ang+dif)*2
                }

                
                if(p.x>w||p.x<0||p.y>h||p.y<0){
                    parList.splice(i,1)
                }

            }
          
             // _lux.lightX = stage.stageWidth >> 1;
           // _lux.lightY = stage.stageHeight >> 1;
           
            _lux.lightX = parList[0] != null ? parList[0].x : stage.stageWidth >> 1;
            _lux.lightY = parList[0] != null ? parList[0].y : stage.stageWidth >> 1;
            var m:Matrix = new Matrix();
            m.rotate(paddle.rotation / 180 * Math.PI);
            m.translate(paddle.x, paddle.y);
            
            showBmd.draw(backBit);
            showBmd.draw(parBmd);
            showBmd.draw(staticBmd);
            showBmd.draw(paddle, m);

        }
        
        public function createParticle(x:Number,y:Number,vx:Number,vy:Number,color:uint):void{
            var p:Object = new Object();
            p.x = x;
            p.y = y;
            p.vx = vx;
            p.vy = vy;
            p.c = color
            parList.push(p);
        }


    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.DisplayObject;
import flash.display.LineScaleMode;
import flash.display.PixelSnapping;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.GlowFilter;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.geom.Vector3D;
    internal class LuxMod extends Sprite {
    public var lightX : Number;
    public var lightY : Number;
    /* */
    private var _passes : uint = 6;
    private var _scale : Number = 2.2;
    private var _smooth : Boolean = true;
    /* */
    private var _src : DisplayObject;
    private var _light : Bitmap = new Bitmap(null, PixelSnapping.AUTO, false);
    private var _cth : ColorTransform = new ColorTransform(0.5, 0.5, 0.5);
    private var _baseBmd : BitmapData;
    private var _offscrBmd : BitmapData;
    private var _bufferSize : uint = 0x8000;
    private var _bufferWidth : uint;
    private var _bufferHeight : uint;
    private var _sw : int;
    private var _sh : int;
    private var _matrix : Matrix = new Matrix();
    private var _tmp : BitmapData;

    public function LuxMod(emission : DisplayObject) {

        addChild(_src = emission);
        addChild(_light).blendMode = BlendMode.ADD;

        stage ? onStage(null) : addEventListener(Event.ADDED_TO_STAGE, onStage, false, 0, true);
    }

    private function onStage(e : Event) : void {
        if (e) removeEventListener(Event.ADDED_TO_STAGE, onStage);

        stage.addEventListener(Event.RESIZE, resize, false, 0, true);
        resize(null);

        go();
    }

    private function render(e : Event) : void {
        copyMatrix(_src.transform.matrix, _matrix);
        _matrix.scale(_bufferWidth / _sw, _bufferHeight / _sh);

        _baseBmd.fillRect(_baseBmd.rect, 0);
        _baseBmd.draw(_src, _matrix, null);

        var s : Number = 1 + (_scale - 1) / (1 << _passes);
        var dx : Number = lightX / _sw * _bufferWidth;
        var dy : Number = lightY / _sh * _bufferHeight;

        _matrix.identity();
        _matrix.translate(-dx, -dy);
        _matrix.scale(s, s);
        _matrix.translate(dx, dy);

        _light.bitmapData = modify(_baseBmd, _offscrBmd, _matrix, _passes);
        _light.width = _sw;
        _light.height = _sh;
        _light.smoothing = _smooth;
    }

    private function modify(source : BitmapData, buffer : BitmapData, matrix : Matrix, passes : uint) : BitmapData {
        while (passes--) {
            source.colorTransform(source.rect, _cth);

            buffer.copyPixels(source, source.rect, source.rect.topLeft);
            buffer.draw(source, matrix, null, BlendMode.ADD, null, true);
            matrix.concat(matrix);

            _tmp = source;
            source = buffer;
            buffer = _tmp;
        }

        return source;
    }

    private function resize(e : Event) : void {
        _sw = stage.stageWidth;
        _sh = stage.stageHeight;

        lightX = _sw >> 1;
        lightY = _sh >> 1;

        scrollRect = new Rectangle(0, 0, width, height);

        var aspect : Number = _sw / _sh;

        _bufferHeight = Math.max(1, Math.sqrt(_bufferSize / aspect));
        _bufferWidth = Math.max(1, _bufferHeight * aspect);

        if (_baseBmd) _baseBmd.dispose();
        if (_offscrBmd) _offscrBmd.dispose();

        _baseBmd = _offscrBmd = _light.bitmapData = null;

        _baseBmd = new BitmapData(_bufferWidth, _bufferHeight, false, 0);
        _offscrBmd = new BitmapData(_bufferWidth, _bufferHeight, false, 0);
    }

    public function go() : void {
        if (!hasEventListener(Event.ENTER_FRAME)) addEventListener(Event.ENTER_FRAME, render, false, 0, true);
    }

    public function no_go() : void {
        if (hasEventListener(Event.ENTER_FRAME)) removeEventListener(Event.ENTER_FRAME, render);
    }

    private function copyMatrix(src : Matrix, dst : Matrix) : void {
        dst.a = src.a;
        dst.b = src.b;
        dst.c = src.c;
        dst.d = src.d;
        dst.tx = src.tx;
        dst.ty = src.ty;
    }
}
