/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oGr0
 */

// forked from tkinjo's Menu
// forked from tkinjo's KeyState クラス
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * Menu
     * 
     * ↑↓　…　マーカーの移動
     * ←→　…　値の増減
     * z 　　…　SharedObject に値を保存
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        public static const APPLICATION_NAME:String = "Menu";
        
        private var gameSetting:GameSettingScene;
        
        private var scene:IScene;
        
        public function Main() 
        {
            gameSetting = GameSettingScene.instance;
            addChild( gameSetting );
            
            scene = gameSetting;
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
            stage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            scene.run();
            scene.paint();
        }
        
        private function keyDownHandler( event:KeyboardEvent ):void {
            
            KeyState.pressAtKeyCode( event.keyCode );
        }
        
        private function keyUpHandler( event:KeyboardEvent ):void {
            
            KeyState.releaseAtKeyCode( event.keyCode );
        }
    }
    
}
import flash.display.Sprite;
import flash.errors.IllegalOperationError;
import flash.net.SharedObject;
import flash.text.TextField;
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.geom.Matrix;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;
import flash.utils.Dictionary;

class GameSettingScene extends Sprite implements IScene {
    
    private var textField:TextField;
    
    private const MENU_ITEM_SIZE:Number = 30;
    private const MENU_ITEM_Y:Number = 100;
    private const MENU_ITEM_NAME_X:Number = 100;
    private const MENU_ITEM_VALUE_X:Number = 300;
    
    private const MENU_FONT:String = "_sans";
    private const MENU_FONT_SIZE:Number = 20;
    private const MENU_FONT_BOLT:Boolean = true;
    
    private const SELECT_MARKER_RADIUS:Number = 5;
    private const SELECT_MARKER_OFFSET_X:Number = -10;
    private const SELECT_MARKER_OFFSET_Y:Number = MENU_FONT_SIZE / 2 + 4;
    
    private const KEY_FIRST_REPEAT_INTERVAL:Number = 20;
    private const KEY_REPEAT_INTERVAL:Number = 2;
    
    private var selectedIndex:uint;
    private var keyRepeatedCounter:Number;
    
    
    public function GameSettingScene():void {
        
        if ( _instance )
            throw new IllegalOperationError ("Use Setting.instance to get the instance");
        
        textField = new TextField();
        textField.autoSize = TextFieldAutoSize.LEFT;
        textField.defaultTextFormat = new TextFormat( MENU_FONT, MENU_FONT_SIZE, null, MENU_FONT_BOLT );
    }
    
    public function run():void {
        
        var keyRepeatCount:uint;
        
        if ( KeyState.getRepeated( Setting.keySettingValues[ Setting.KEY_SETTING_VALUE_UP_INDEX ] ) && selectedIndex > 0 ) {
            
            if ( isChangeValue( Setting.keySettingValues[ Setting.KEY_SETTING_VALUE_UP_INDEX ] ) )
                selectedIndex--;
            
        } else if ( KeyState.getRepeated( Setting.keySettingValues[ Setting.KEY_SETTING_VALUE_DOWN_INDEX ] ) && selectedIndex < Setting.GAME_SETTINGS.length - 1 ) {
            
            if ( isChangeValue( Setting.keySettingValues[ Setting.KEY_SETTING_VALUE_DOWN_INDEX ] ) )
                selectedIndex++;
            
        } else if ( KeyState.getRepeated( Setting.keySettingValues[ Setting.KEY_SETTING_VALUE_LEFT_INDEX ] ) && 
                Setting.gameSettingValues[ selectedIndex ] > Setting.GAME_SETTINGS[ selectedIndex ][ Setting.GAME_SETTING_ITEM_MIN_VALUE_INDEX ] ) {
            
            if ( isChangeValue( Setting.keySettingValues[ Setting.KEY_SETTING_VALUE_LEFT_INDEX ] ) )
                Setting.gameSettingValues[ selectedIndex ]--;
            
        } else if ( KeyState.getRepeated( Setting.keySettingValues[ Setting.KEY_SETTING_VALUE_RIGHT_INDEX ] ) && 
                Setting.gameSettingValues[ selectedIndex ] < Setting.GAME_SETTINGS[ selectedIndex ][ Setting.GAME_SETTING_ITEM_MAX_VALUE_INDEX ] ) {
            
            if ( isChangeValue( Setting.keySettingValues[ Setting.KEY_SETTING_VALUE_RIGHT_INDEX ] ) )
                Setting.gameSettingValues[ selectedIndex ]++;
            
        } else if ( KeyState.getReleased( "z" ) ) {
            
            Setting.flushGameSettingValues();
        }
    }
    
    private function isChangeValue( keyString:String ):Boolean {
        
        return KeyState.getPressed( keyString ) || isRepeatInterval( keyString );
    }
    
    private function isRepeatInterval( keyString:String ):Boolean {
        
        KeyState.manualRepeatCount( keyString );
        
        var keyRepeatCount:uint = KeyState.getManualRepeatedCount( keyString );
        
        if ( 
            keyRepeatCount == KEY_FIRST_REPEAT_INTERVAL || 
            ( 
                keyRepeatCount > KEY_FIRST_REPEAT_INTERVAL && 
                ( keyRepeatCount - KEY_FIRST_REPEAT_INTERVAL ) % KEY_REPEAT_INTERVAL == 0 
            )
        ) {
            return true;
        }
        
        return false;
    }
    
    public function paint():void {
        
        graphics.clear();
        
        for ( var i:uint = 0; i < Setting.GAME_SETTINGS.length; i++ )
            drawString( graphics, textField, MENU_ITEM_NAME_X, MENU_ITEM_Y + MENU_ITEM_SIZE * i, Setting.GAME_SETTINGS[ i ][ Setting.GAME_SETTING_ITEM_NAME_INDEX ] );
        
        for ( i = 0; i < Setting.GAME_SETTINGS.length; i++ )
            drawString( graphics, textField, MENU_ITEM_VALUE_X, MENU_ITEM_Y + MENU_ITEM_SIZE * i, Setting.gameSettingValues[ i ].toString() );
        
        graphics.beginFill( 0 );
        graphics.drawCircle( MENU_ITEM_NAME_X + SELECT_MARKER_OFFSET_X, MENU_ITEM_Y + MENU_ITEM_SIZE * selectedIndex + SELECT_MARKER_OFFSET_Y, SELECT_MARKER_RADIUS );
        graphics.endFill();
    }
    
    
    
    private static var _instance:GameSettingScene;
    public static function get instance():GameSettingScene {
        
        if ( _instance == null )
            _instance = new GameSettingScene();
        
        return _instance;
    }
}

interface IScene {
    
    function run():void;
    function paint():void;
}

class KeyState {
    
    private static var repeated:Vector.<uint> = new Vector.<uint>( 255 );
    private static var pressed :Vector.<Boolean> = new Vector.<Boolean>( 255 );
    private static var released:Vector.<Boolean> = new Vector.<Boolean>( 255 );
    
    private static var manualRepeatedCounter:Vector.<uint> = new Vector.<uint>( 255 );
    
    /** --------------------------------------------------
     * 
     */
    
    public static const SHIFT:String = "shift";
    public static const CTRL :String = "ctrl";
    public static const ALT  :String = "alt";
    
    public static const LEFT :String = "left";
    public static const UP   :String = "up";
    public static const RIGHT:String = "right";
    public static const DOWN :String = "down";
    
    /** --------------------------------------------------
     * 
     */
    
    public static const KEY_SHIFT:uint = 16;
    public static const KEY_CTRL :uint = 17;
    public static const KEY_ALT  :uint = 18;
    
    public static const KEY_LEFT :uint = 37;
    public static const KEY_UP   :uint = 38;
    public static const KEY_RIGHT:uint = 39;
    public static const KEY_DOWN :uint = 40;
    
    
    
    public static const CHAR_LARGE_A:uint = 65;
    public static const CHAR_SMALL_A:uint = 97;
    public static const KEY_A       :uint = 65;
    
    public static const NUM_ALPHABET:uint = 26;
    
    
    
    public static const CHAR_0      :uint = 48;
    public static const KEY_0       :uint = 0;
    public static const KEY_NUMPAD_0:uint = 96;
    
    public static const NUM_NUMBER:uint = 10;
    
    
    /** ==================================================
     * 
     */
    
    public static function press( string:String ):void {
        
        var keyCode:Number = getKeyCode( string );
        
        if ( keyCode > 0 )
            pressAtKeyCode( keyCode );
    }
    
    public static function release( string:String ):void {
        
        var keyCode:Number = getKeyCode( string );
        
        if ( keyCode > 0 )
            releaseAtKeyCode( keyCode );
    }
    
    public static function manualRepeatCount( string:String ):void {
        
        var keyCode:Number = getKeyCode( string );
        
        if ( keyCode > 0 )
            manualRepeatCountAtKeyCode( keyCode );
    }
    
    /** --------------------------------------------------
     * 
     */
    
    public static function pressAtKeyCode( keyCode:uint ):void {
        
        if ( repeated[ keyCode ] ) {
            repeated[ keyCode ]++;
            return;
        }
        
        repeated[ keyCode ] = 1;
        pressed[  keyCode ] = true;
        released[ keyCode ] = false;
        
        manualRepeatedCounter[ keyCode ] = 1;
    }
    
    public static function releaseAtKeyCode( keyCode:uint ):void {
        
        repeated[ keyCode ] = 0;
        pressed[  keyCode ] = false;
        released[ keyCode ] = true;
        
        manualRepeatedCounter[ keyCode ] = 0;
    }
    
    public static function manualRepeatCountAtKeyCode( keyCode:uint ):void {
        
        manualRepeatedCounter[ keyCode ]++;
    }
    
    
    
    /** --------------------------------------------------
     * 
     */
    
    public static function getRepeated( string:String ):Boolean {
        
        var keyCode:Number = getKeyCode( string );
        
        if( keyCode > 0 )
            return getRepeatedAtKeyCode( keyCode );
        
        return false;
    }
    public static function getRepeatedCount( string:String ):uint {
        
        var keyCode:Number = getKeyCode( string );
        
        if( keyCode > 0 )
            return getRepeatedCountAtKeyCode( keyCode );
        
        return 0;
    }
    
    public static function getReleased( string:String ):Boolean {
        
        var keyCode:Number = getKeyCode( string );
        
        if( keyCode > 0 )
            return getReleasedAtKeyCode( keyCode );
        
        return false;
    }
    
    public static function getPressed( string:String ):Boolean {
        
        var keyCode:Number = getKeyCode( string );
        
        if( keyCode > 0 )
            return getPressedAtKeyCode( keyCode );
        
        return false;
    }
    
    public static function getManualRepeatedCount( string:String ):uint {
        
        var keyCode:Number = getKeyCode( string );
        
        if( keyCode > 0 )
            return getManualRepeatedCountAtKeyCode( keyCode );
        
        return 0;
    }
    
    
    /** --------------------------------------------------
     * 
     */
    
    public static function getRepeatedAtKeyCode( keyCode:uint ):Boolean {
        
        return ( repeated[ keyCode ] > 0 ) ? true : false;
    }
    public static function getRepeatedCountAtKeyCode( keyCode:uint ):uint {
        
        return repeated[ keyCode ];
    }
    
    public static function getReleasedAtKeyCode( keyCode:uint ):Boolean {
        
        var result:Boolean = released[ keyCode ];
        released[ keyCode ] = false;
        
        return result;
    }
    
    public static function getPressedAtKeyCode( keyCode:uint ):Boolean {
        
        var result:Boolean = pressed[ keyCode ];
        pressed[ keyCode ] = false;
        
        return result;
    }
    
    public static function getManualRepeatedCountAtKeyCode( keyCode:uint ):uint {
        
        return manualRepeatedCounter[ keyCode ];
    }
    
    
    /** --------------------------------------------------
     * 
     */
    
    public static function getKeyCode( string:String ):Number {
        
        if( string.length == 1 ) {
            
            return charCodeToKeyCode( string.charCodeAt() );
        }
        
        switch ( string ) {
            
            case SHIFT:
                return KEY_SHIFT;
            
            case CTRL:
                return KEY_CTRL;
            
            case ALT:
                return KEY_ALT;
            
            case LEFT:
                return KEY_LEFT;
            
            case UP:
                return KEY_UP;
            
            case RIGHT:
                return KEY_RIGHT;
            
            case DOWN:
                return KEY_DOWN;
        }
        
        return -1;
    }
    
    
    
    public static function charCodeToKeyCode( charCode:uint ):Number {
        
        // A-Z
        if ( CHAR_LARGE_A <= charCode && ( charCode - CHAR_LARGE_A ) < NUM_ALPHABET ) {
            
            return charCode;
            
        // a-z
        } else if ( CHAR_SMALL_A <= charCode && ( charCode - CHAR_SMALL_A ) < NUM_ALPHABET ) {
            
            return KEY_A + ( charCode - CHAR_SMALL_A );
            
        // 0-9
        } else if ( CHAR_0 <= charCode && ( charCode - CHAR_0 ) < NUM_NUMBER ) {
            
            return charCode;
        }
        
        return -1;
    }
}



var drawStringMatrix:Matrix = new Matrix();

function drawString( graphics:Graphics, textField:TextField, x:Number, y:Number, text:String = "" ):void {
    
    if ( text )
        textField.text = text;
    
    var bitmapData:BitmapData = new BitmapData( textField.width, textField.height, true, 0 );
    
    bitmapData.draw( textField );
    
    drawStringMatrix.identity();
    drawStringMatrix.translate( x, y );
    
    graphics.beginBitmapFill( bitmapData, drawStringMatrix );
    graphics.drawRect( x, y, textField.width, textField.height );
    graphics.endFill();
}



class Setting {
    
    public static const GAME_SETTING_ITEM_NAME_INDEX:uint          = 0;
    public static const GAME_SETTING_ITEM_DEFAULT_VALUE_INDEX:uint = 1;
    public static const GAME_SETTING_ITEM_MIN_VALUE_INDEX:uint     = 2;
    public static const GAME_SETTING_ITEM_MAX_VALUE_INDEX:uint     = 3;
    public static const GAME_SETTINGS:Array  = [ 
            [ "ITEM 1" , 10, 0, 100  ], 
            [ "ITEM 2" , 10, 0, 100 ], 
            [ "ITEM 3" , 10, 0, 100 ], 
            [ "ITEM 4" , 10, 0, 100 ], 
            [ "ITEM 5" , 10, 0, 100 ] 
        ];
    
    
    /** --------------------------------------------------
     * 
     */
    
    public static const KEY_SETTING_ITEM_NAME_INDEX:uint          = 0;
    public static const KEY_SETTING_ITEM_DEFAULT_VALUE_INDEX:uint = 1;
    public static const KEY_SETTINGS:Array  = [ 
            [ "LEFT" , KeyState.LEFT  ], 
            [ "UP"   , KeyState.UP    ], 
            [ "RIGHT", KeyState.RIGHT ], 
            [ "DOWN" , KeyState.DOWN  ], 
            [ "OK"    , "z" ], 
            [ "CANCEL", "x" ] 
        ];
    
    public static const KEY_SETTING_VALUE_LEFT_INDEX:uint  = 0;
    public static const KEY_SETTING_VALUE_UP_INDEX:uint    = 1;
    public static const KEY_SETTING_VALUE_RIGHT_INDEX:uint = 2;
    public static const KEY_SETTING_VALUE_DOWN_INDEX:uint  = 3;
    public static const KEY_SETTING_VALUE_OK_INDEX:uint     = 4;
    public static const KEY_SETTING_VALUE_CANCEL_INDEX:uint = 5;
    
    /** ==================================================
     * 
     */
    private static var sharedObject:SharedObject;
    
    public static var gameSettingValues:Vector.<Number>;
    public static var keySettingValues:Vector.<String>;
    
    
    /** ==================================================
     * 
     */
    
    public function Setting():void {
        
        if ( _instance )
            throw new IllegalOperationError ("Use Setting.instance to get the instance");
        
        
        
        // load
        sharedObject = SharedObject.getLocal( Main.APPLICATION_NAME );
        
        
        
        // clear
        //sharedObject.clear();
        
        
        
        var i:uint;
        
        
        
        //gameSettingValues
        var tempGameSettingValues:Vector.<Number> = sharedObject.data.gameSettingValues as Vector.<Number>;
        
        if ( !tempGameSettingValues ) {
            
            gameSettingValues = new Vector.<Number>( GAME_SETTINGS.length )
            
            for ( i = 0; i < GAME_SETTINGS.length; i++ )
                gameSettingValues[ i ] = GAME_SETTINGS[ i ][ GAME_SETTING_ITEM_DEFAULT_VALUE_INDEX ];
            
        } else {
            
            gameSettingValues = tempGameSettingValues.concat();
        }
        
        
        
        
        //keySettingValues
        //keySettingValues = sharedObject.data.keySettingValues; //cast error
        var tempKeySettingValues:Vector.<Object> = sharedObject.data.keySettingValues as Vector.<Object>;
        if ( tempKeySettingValues ) {
            
            keySettingValues = new Vector.<String>( KEY_SETTINGS.length );
            
            for ( var key:String in tempKeySettingValues )
                keySettingValues[ key ] = KEY_SETTINGS[ key ][ KEY_SETTING_ITEM_DEFAULT_VALUE_INDEX ];
        }
        
        if ( !keySettingValues ) {
            
            keySettingValues = new Vector.<String>( KEY_SETTINGS.length );
            
            for ( i = 0; i < KEY_SETTINGS.length; i++ )
                keySettingValues[ i ] = KEY_SETTINGS[ i ][ KEY_SETTING_ITEM_DEFAULT_VALUE_INDEX ];
        }
    }
    
    public static function flush():void {
        
        sharedObject.data.gameSettingValues = gameSettingValues;
        sharedObject.data.keySettingValues = keySettingValues;
        sharedObject.flush();
    }
    
    public static function flushGameSettingValues():void {
        
        sharedObject.data.gameSettingValues = gameSettingValues;
        sharedObject.flush();
    }
    
    public static function flushKeySettingValues():void {
        
        sharedObject.data.keySettingValues = keySettingValues;
        sharedObject.flush();
    }
    
    private static var _instance:Setting = instance;
    public static function get instance():Setting {
        
        if ( _instance == null )
            _instance = new Setting();
        
        return _instance;
    }
    
}