/**
 * Copyright yamadori ( http://wonderfl.net/user/yamadori )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oGNa
 */

/*
Bitmapにして高速化しました。
漢字もある程度つぶれないよ！
*/
// forked from 7kamura's 電光掲示板的なものをつくりたい

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    import net.hires.debug.Stats;

    public class Main extends Sprite
    {
        private const W:Number = stage.stageWidth;
        private const H:Number = stage.stageHeight;

        private var bd:BitmapData;
        private var tfBd:BitmapData;

        private var frameCount:int;

        private var size:int = 5;

        private var lightDot:BitmapData;
        private var darkDot:BitmapData;

        public function Main()
        {
            bd = new BitmapData(W, H, false, 0x000000);
            addChild(new Bitmap(bd));

            var lightColor:Array = [0x00EE00, 0x007700];
            var darkColor:Array = [0x002200, 0x001100];
            var alphas:Array = [1,1];
            var ratios:Array = [0,255];
            var mat:Matrix =new Matrix();
            mat.createGradientBox(size*2, size*2, 0, 0, 0);
            // 明るいドット
            var sp:Shape = new Shape();
            with(sp.graphics)
            {
                beginGradientFill(GradientType.RADIAL, lightColor, alphas, ratios, mat);
                drawCircle(size, size, size);
                endFill();
            }
            lightDot = new BitmapData(size*2, size*2, true, 0x0);
            lightDot.draw(sp);
            // 暗いドット
            with(sp.graphics)
            {
                clear();
                beginGradientFill(GradientType.RADIAL, darkColor, alphas, ratios, mat);
                drawCircle(size, size, size);
                endFill();
            }
            darkDot = new BitmapData(size*2, size*2, true, 0x0);
            darkDot.draw(sp);
            
            // 元となる文字をbitmapDataにdraw
            var fmt:TextFormat = new TextFormat("Arial", 36, 0xFFFFFF);
            fmt.letterSpacing = 3;
            var tf:TextField=new TextField();
            tf.defaultTextFormat = fmt;
            tf.background = true;
            tf.backgroundColor = 0x000000;
            tf.autoSize = "left";
            tf.text = "http://wonderfl.net";
            tfBd = new BitmapData(tf.width, tf.height);
            tfBd.draw(tf);

            frameCount = -55;
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            addChild(new Stats());
        }
        
        public function enterFrameHandler(e:Event):void
        {
            bd.lock();
            bd.fillRect(bd.rect, 0x000000);

            frameCount++;
            if(frameCount > tfBd.width)
            {
                frameCount = -55;
            }

            for (var x:int=0; x<W/size/2; x++)
            {
                for (var y:int=0; y<H/size/2; y++)
                {
                    var pixel:int;
                    
                    if (x + frameCount < 0 || tfBd.width < x + frameCount)
                    {
                        pixel = 0;
                    }
                    else
                    {
                        pixel = tfBd.getPixel(x+frameCount, y);
                    }
                    if (pixel == 0)
                    {
                        bd.copyPixels(darkDot, darkDot.rect, new Point(x*2*size, y*2*size));
                    }
                    else
                    {
                        bd.copyPixels(lightDot, lightDot.rect, new Point(x*2*size, y*2*size));
                    }
                }
            }
            bd.unlock();
        }
    }
}