/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oFyR
 */

// forked from checkmate's Checkmate vol.5 Professenal
// ワンコといえばワンコそば。いろんな動きをするワンコを捕まえて食べよう！
// え、わんこはお椀のことだって？細かいことは( ﾟεﾟ)ｷﾆｼﾅｲ!!
// 申し訳程度に音も出るよ
package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.net.*;
	import flash.system.*;
	import flash.text.*;
	import flash.utils.*;
	import jp.progression.commands.*;
	import jp.progression.commands.lists.*;
	import jp.progression.commands.display.*;
	import jp.progression.commands.net.*;
	import jp.progression.commands.tweens.*;
	import jp.progression.events.*;
	import org.si.sion.*;
	
	[SWF(frameRate="30", backgroundColor="#aaaa55")]
	public class WankoSoba extends Sprite {
		public static var GRAPHICS_URL:String = "http://swf.wonderfl.net/static/assets/checkmate05/wancoProfessional.swf";
		
		public var stayMotion:MovieClip;
		public var jumpMotion:MovieClip;
		public var highJumpMotion:MovieClip;
		public var walkMotion:MovieClip;
		public var runMotion:MovieClip;
		public var squatMotion:MovieClip;
		public var questionMotion:MovieClip;
		public var exclamationMotion:MovieClip;
		public var heartMotion:MovieClip;
		public var poutMotion:MovieClip;
		public var starMotion:MovieClip;
		public var singMotion:MovieClip;
		public var sleepMotion:MovieClip;
		public var wakeMotion:MovieClip;
		

		
		public function WankoSoba(){
			super();
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
                        Wonderfl.capture_delay(5);

			var com:SerialList = new SerialList();
			com.addCommand(
				new LoadSWF( new URLRequest( GRAPHICS_URL ) ),
				function():void {
					var loader:Loader = Loader( this.latestData );
					var domain:ApplicationDomain = loader.contentLoaderInfo.applicationDomain;
					
					stayMotion = new ( domain.getDefinition( "StayMotion" ) as Class );
					jumpMotion = new ( domain.getDefinition( "JumpMotion" ) as Class );
					highJumpMotion = new ( domain.getDefinition( "HighJumpMotion" ) as Class );
					walkMotion = new ( domain.getDefinition( "WalkMotion" ) as Class );
					runMotion = new ( domain.getDefinition( "RunMotion" ) as Class );
					squatMotion = new ( domain.getDefinition( "SquatMotion" ) as Class );
					questionMotion = new ( domain.getDefinition( "QuestionMotion" ) as Class );
					exclamationMotion = new ( domain.getDefinition( "ExclamationMotion" ) as Class );
					heartMotion = new ( domain.getDefinition( "HeartMotion" ) as Class );
					poutMotion = new ( domain.getDefinition( "PoutMotion" ) as Class );
					starMotion = new ( domain.getDefinition( "StarMotion" ) as Class );
					singMotion = new ( domain.getDefinition( "SingMotion" ) as Class );
					sleepMotion = new ( domain.getDefinition( "SleepMotion" ) as Class );
					wakeMotion = new ( domain.getDefinition( "WakeMotion" ) as Class );
					
				}
			);

			// お椀を描く
			var mat : Matrix = new Matrix();
			mat.scale(1/1638*465/2* 2, 1/1638*465/2*RATIO*2);
			mat.translate(465 / 2, 280);
			graphics.lineStyle(2, 0x000000);
			graphics.beginGradientFill(GradientType.RADIAL, [0xaa0000, 0x440000], [1, 1], [100, 255], mat);
			var W : Number = 465 * 0.4;
			graphics.drawEllipse(465/2 - W, 250 - W * RATIO, W * 2, W * RATIO * 2);
		
			_sd = new SiONDriver();
			
			_tf = new TextField();
			addChild(_tf);
			
			_tfScore = new TextField();
			_tfScore.autoSize = "left";
			_tfScore.defaultTextFormat = new TextFormat("fantasy", 30);
			_tfScore.selectable = false;
			addChild(_tfScore);
			
			_tfTime = new TextField();
			_tfTime.autoSize = "right";
			_tfTime.x = 465;
			_tfTime.defaultTextFormat = new TextFormat("fantasy", 30);
			_tfTime.selectable = false;
			addChild(_tfTime);
			
			_tfStart = new TextField();
			_tfStart.autoSize = "center";
			_tfStart.x = 465 / 2;
			_tfStart.y = 420;
			_tfStart.defaultTextFormat = new TextFormat("fantasy", 40, 0xffdd33);
			_tfStart.text = " START ";
			_tfStart.background = true;
			_tfStart.backgroundColor = 0x773333;
			_tfStart.selectable = false;
			addChild(_tfStart);

			com.addEventListener(ExecuteEvent.EXECUTE_COMPLETE,onLoadSWF);
			com.execute();
		}

		private const RATIO : Number = 200 / (465 / 2.0);
		private var _tf : TextField; // デバッグ用
		private var _tfScore : TextField; // スコア表示
		private var _tfTime : TextField; // 残り時間表示
		private var _tfStart : TextField; // スタートボタン
		private var _sd : SiONDriver;
		
		private const LIMTIME : int = 30 * 1000; // 時間制限
		private var _endTime : int;
		
		private var _sobaClips : Array; // モーション配列
		private var _sobaKind : int;

		// 0 :
		// 1 : 落下中
		// 2 : 回転中
		private var _state : int;
		private var _frameCount : int;
		private var _score : int;
	
		private var _soba : MovieClip;
	
		private function onLoadSWF(e:Event):void {
			_sobaClips = [
				stayMotion, jumpMotion, highJumpMotion, 
				walkMotion, runMotion, squatMotion,
				questionMotion, exclamationMotion, heartMotion, 
				poutMotion, starMotion, singMotion, 
				sleepMotion
				];
			_tfStart.addEventListener(MouseEvent.CLICK, onStart);
		}
				
		private function onStart(e : MouseEvent) : void
		{
			initGame();
		}
				
		private function initGame() : void
		{
			_tfStart.visible = false;
			_score = 0;
			_endTime = getTimer() + LIMTIME;
			_tfScore.text = "スコア : " + 0 + "杯\n";
			appendSoba();
		}
		private function endGame() : void
		{
			removeSoba();
			_tfStart.visible = true;
			_state = 0;
		}

		private function appendSoba() : void
		{
			_sobaKind = Math.random() * _sobaClips.length;
			_soba = _sobaClips[_sobaKind];
			_soba.x = 0;
			_soba.y = 0;
			_soba.z = -400;
			_soba.r = 465 * 0.3 * (1.0 - Math.random() * Math.random()); 
			_soba.theta = Math.random() * 2 * Math.PI;
			_soba.omega = Math.random() * 0.4 - 0.2;
			if(_soba === runMotion){
				_soba.omega = Math.random() * 1.2 - 0.6;
			}
			_soba.vz = 25;
			_soba.gotoAndStop(1);
			addChild(_soba);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			_frameCount++;
			
			_state = 1;
		}

		private function removeSoba() : void
		{
			_soba.removeEventListener(MouseEvent.MOUSE_DOWN, onSobaMouseDown);
			_soba.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
			removeChild(_soba);
		}

		private function onEnterFrame(e : Event) : void
		{
			_frameCount++;
			if(_state == 1){
				// 落下
				_soba.vz += 2;
				_soba.z += _soba.vz;
				if(_soba.z > 0){
					_soba.z = 0;
					_soba.play();
					_state = 2;
					_frameCount = 0;
					// star:n体分身
					if(_soba == starMotion){
						_soba.nBody = int(Math.random() * 4) + 2;
					}
					_soba.addEventListener(MouseEvent.MOUSE_DOWN, onSobaMouseDown);
					return;
				}
			}else{
				// 回転
				_soba.r *= 0.98;
				_soba.omega *= 0.98;
				_soba.theta += _soba.omega;
				// question:ワープ
				if(_soba == questionMotion && _frameCount % 15 == 0){
					_soba.theta = Math.random() * Math.PI * 2;
				}
				// exclamation:とびあがる
				if(_soba == exclamationMotion){
					if(_soba.z == 0 && _soba.hitTestPoint(mouseX, mouseY, true)){
						_soba.vz = -70;
						_soba.z += _soba.vz;
					}else{
						if(_soba.z != 0){
							_soba.vz+=7;
							_soba.z += _soba.vz;
							if(_soba.z > 0)_soba.z = 0;
						}
					}
				}
				// exclamation:逃げる
				if(_soba == sleepMotion){
					if(Math.abs(_soba.omega) < 0.1 && _soba.hitTestPoint(mouseX, mouseY, true)){
						_soba.omega = Math.random() < 0.5 ? 0.4 : -0.4;
					}
				}
				// sing:再加速
				if(_soba == singMotion && _frameCount % 10 == 0){
					_soba.omega = Math.random() * 0.8 - 0.4;
				}
				// star:n体分身
				if(_soba == starMotion){
					_soba.omega = 6.28 / _soba.nBody;
				}
				// pout:小さくなる
				if(_soba == poutMotion){
					var scale : Number = (2 + Math.cos(_frameCount * 10 / 180 * 3.14)) / 3;
					_soba.scaleX = scale;
					_soba.scaleY = scale;
				}
				// heart:外側に移動する
				if(_soba == heartMotion){
					_soba.r *= Math.pow(465 / 3 / _soba.r, 1 / 4);
				}
				// squat:その場に止まる
				if(_soba == squatMotion){
					_soba.r /= 0.98;
					_soba.omega = 0;
				}
				// walk:角速度が減衰しない
				if(_soba == walkMotion){
					_soba.r /= 0.98;
				}
			}
			_soba.x = _soba.r * Math.cos(_soba.theta) + 465 / 2;
			_soba.y = _soba.r * Math.sin(_soba.theta) * RATIO + 250 + 20;
			turn(_soba);
			
			var leftTime : int = _endTime - getTimer();
			if(leftTime > 0){
				_tfTime.text = "残り " + int(leftTime / 1000) + "秒";
			}else{
				endGame();
			}
		}

		// ワンコが押されたとき
		private function onSobaMouseDown(e : MouseEvent) : void
		{
			_sd.play("%5 @5 t180l16o6ecec");
			_score++;
			_tfScore.text = "スコア : " + _score + "杯\n";
			
			removeSoba();
			appendSoba();
		}
		
		// マウスポインタの方を向く
		private function turn(m : MovieClip) : void
		{
			var y : Number = stage.mouseY - m.y;
			var x : Number = stage.mouseX - m.x;
			var t : Number = Math.atan(y / x);
			if(x < 0)t += Math.PI;
			t = ((Math.PI / 2 + 2 * Math.PI / 20 * 2.5) + 2 * Math.PI - t) % (2 * Math.PI);
		
			m.wc2.wc3.gotoAndStop(int(t / (Math.PI * 2) * 20));
		}
	}
}
