/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oFRK
 */

// forked from greentec's Away3D Terrain - use PerlinNoise
package 
{
    import away3d.cameras.Camera3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.controllers.HoverController;
    import away3d.debug.AwayStats;

    import away3d.extrusions.Elevation;
    import away3d.lights.DirectionalLight;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.materials.TextureMaterial;
    import away3d.primitives.SkyBox;
    import away3d.textures.BitmapCubeTexture;
    import away3d.utils.Cast;
    
    import flash.display.*;
    import flash.events.*;
    import flash.net.URLRequest;
    import flash.geom.Matrix;    
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = "465", height = "465")]
    public class Main extends Sprite 
    {        
        public var view:View3D;
        public var scene:Scene3D;
        public var camera:Camera3D;
        public var awayStats:AwayStats;
        
        public var cameraController:HoverController;
        
        public var light:DirectionalLight;
        public var lightPicker:StaticLightPicker;
        
        public var terrainMaterial:TextureMaterial;
        public var terrainBitmapData:BitmapData;
        public var heightBitmapData:BitmapData;
        
        public var terrain:Elevation;
        
        //navigation variables
        private var move:Boolean = false;
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        
        private var bitmap:Bitmap;
        //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);
            
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            Wonderfl.disable_capture();
            //addChild(new Bitmap(source));
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            initialize();
            /*
            var priority:String;
            var loader:Loader;
            for (priority in loadInfo)
            {
                loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
                loader.load(new URLRequest(loadInfo[priority]));

            }*/
            
        }
        
        private function initialize():void
        {
            initEngine();
            initLight();
            initMaterial();
            initObject();
            initListener();
        }
        
        private function initEngine():void
        {
            view = new View3D();
            view.antiAlias = 4;
            
            scene = view.scene;
            camera = view.camera;
            
            cameraController = new HoverController(camera);
            cameraController.distance = 1500;
            cameraController.minTiltAngle = 10;
            cameraController.maxTiltAngle = 90;
            cameraController.panAngle = 45;
            cameraController.tiltAngle = 20;
            
            awayStats = new AwayStats(view);
        }
        
        private function initLight():void
        {
            light = new DirectionalLight( -0.5, -1, -1);
            light.color = 0xffffff;
            light.ambient = 1;
            scene.addChild(light);
            
            lightPicker = new StaticLightPicker([light]);
        }
        
        private function initMaterial():void
        {
            /*
            skyboxTexture = new BitmapCubeTexture(Cast.bitmapData(skyboxBitmapArray[0]),
                                                  Cast.bitmapData(skyboxBitmapArray[1]),
                                                  Cast.bitmapData(skyboxBitmapArray[2]),
                                                  Cast.bitmapData(skyboxBitmapArray[3]),
                                                  Cast.bitmapData(skyboxBitmapArray[4]),
                                                  Cast.bitmapData(skyboxBitmapArray[5]));
            */
            
            heightBitmapData = new BitmapData(128, 128, false, 0x0);
            heightBitmapData.perlinNoise(64, 64, 7, Math.random() * int.MAX_VALUE, false, true, 7, true);
            
            var i:int;
            var j:int;
            var color:uint;
            var num:Number;
            
            for (i = 0; i < 128; i += 1)
            {
                for (j = 0; j < 128; j += 1)
                {
                    color = heightBitmapData.getPixel(i, j);
                    color = color & 0xff;
                    
                    num = color / 255.0;
                    num -= 0.5;
                    num *= 2;
                    num = Math.abs(num);
                    
                    num = 1 - num;
                    num *= num * num * num;
                    
                    color = num * 255;
                    
                    color = color << 16 | color << 8 | color;
                    heightBitmapData.setPixel(i, j, color);
                    
                }

            }

            
            terrainMaterial = new TextureMaterial(Cast.bitmapTexture(heightBitmapData));
            terrainMaterial.lightPicker = lightPicker;
            terrainMaterial.ambientColor = 0x303030;
            terrainMaterial.ambient = 1;
            terrainMaterial.specular = .25;
            
        }
        
        private function initObject():void
        {
            ////scene.addChild(new SkyBox(skyboxTexture));
            
            terrain = new Elevation(terrainMaterial, Cast.bitmapData(heightBitmapData), 2000, 400, 2000, 64, 64);
            scene.addChild(terrain);
        }
        
        private function initListener():void
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(Event.RESIZE, resizeHandler);
            addEventListener(Event.ENTER_FRAME, render);
            
            
            addChild(view);
            addChild(awayStats);
            
            bitmap = new Bitmap(heightBitmapData);
            bitmap.x = stage.stageWidth - bitmap.width;
            
            addChild(bitmap);
        }

        private function render(e:Event):void
        {
            if (move)
            {
                cameraController.panAngle = 0.3 * (stage.mouseX - lastMouseX) + lastPanAngle;
                cameraController.tiltAngle = 0.3 * (stage.mouseY - lastMouseY) + lastTiltAngle;
            }
           
            /*
            if (Math.random() < 0.1)
            {
                var circle:Shape = new Shape();
                
                if (Math.random() < 0.5)
                {
                    circle.graphics.beginFill(0xffffff, 0.7);
                }
                else
                {
                    circle.graphics.beginFill(0x000000, 0.7);
                }
                circle.graphics.drawCircle(0, 0, 1);
                circle.graphics.endFill();
                heightBitmapData.draw(circle, new Matrix(1, 0, 0, 1, Math.random() * 128, Math.random() * 128));
                
                scene.removeChild(terrain);
                terrain = null;
                terrain = new Elevation(terrainMaterial, Cast.bitmapData(heightBitmapData), 2000, 400, 2000, 64, 64);
                scene.addChild(terrain);

            }
            */
            
            view.render();
            //view.renderer.queueSnapshot(source);
        }
        
        private function onMouseDown(e:MouseEvent):void
        {
            lastPanAngle = cameraController.panAngle;
            lastTiltAngle = cameraController.tiltAngle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            move = true;
            
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            move = false;
        }
        
        private function resizeHandler(e:Event):void
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
            
            bitmap.x = stage.stageWidth - bitmap.width;
        }
    }
    
}