/**
 * Copyright akeyama ( http://wonderfl.net/user/akeyama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oFCu
 */

package {
    import flash.display.*;
    import flash.events.*;
    import com.bit101.components.*;

    [SWF(backgroundColor="0", frameRate="30")]
    public class FlashTest extends Sprite {

        public var workArea:WorkArea;
        public var workMask:Sprite;
        
        public function FlashTest() {
            // write as3 code here..

            addChild(workArea = new WorkArea());

            workMask= new Sprite();
            var g:Graphics= workMask.graphics;
            g.beginFill(0x000000);
            g.drawRect(0,0,200,200);
            workArea.mask = workMask;
            addChild(workMask);

            workArea.x = workMask.x = 20;
            workArea.y = workMask.y = 20;
            workMask.width  = stage.stageWidth-60;
            workMask.height = stage.stageHeight-60;

            //　横スライダー作成
　            var myHSlider:HSlider = new HSlider(this, 0, stage.stageHeight-20, onChangedHSlider);
            myHSlider.width = stage.stageWidth-20;
            myHSlider.height = 20;


            // 縦スライダー作成
              var myVSlider:VSlider = new VSlider(this, stage.stageWidth-20, 0 , onChangedVSlider);
            myVSlider.height = stage.stageHeight-20;
            myVSlider.width = 20;
            myVSlider.value = myVSlider.maximum;
            
        }

        /**
         * 横スライダーを動かした
         */
        public function onChangedHSlider(e:Event):void
        {
            var rate:Number = e.currentTarget.value/e.currentTarget.maximum;
            workArea.x = -rate*(workArea.width-workMask.width)+workMask.x;
        }

        /**
         * 縦スライダーを動かした
         */
        public function onChangedVSlider(e:Event):void
        {
            var rate:Number = 1.0-e.currentTarget.value/e.currentTarget.maximum;
            workArea.y = -rate*(workArea.height-workMask.height)+workMask.y;
        }
    }

}


import flash.display.*;

//　スクロールさせる描画オブジェクト
class WorkArea extends Sprite {
    public static const SIZE:int = 100;
    public static const NUM:int = 7;

    public function WorkArea()
    {
        // 虹色タイル描画
        var g:Graphics = this.graphics;
        var color:Array = [0x880000,0x888800,0x008800,0x008888,0x000088,0x880088];
        for(var i:int=0;i<NUM*NUM;i++){
            g.beginFill(color[i%6]);
            g.drawRect(Math.floor(i/NUM)*SIZE, i%NUM*SIZE ,SIZE,SIZE);
        }
    }
}