/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oE9V
 */

// forked from Nyarineko's forked from: PV3Dその3(Tweenerをbetweenas3に)
// forked from sake's PV3Dその3
/*
	typographyとbetweenas3の練習用
	*クリックでスローモーション
*
/*
    Vectorvision3DがPV3Dに統合されたらしいと。
    ただ、Word3D → text3Dと、VectorShapeMaterial → Letter3DMaterial　となってる。
    ここ以外はたぶん同じ。
*/
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.utils.setInterval;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.typography.Text3D;
	import org.papervision3d.typography.fonts.HelveticaBold;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.view.layer.ViewportLayer;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.events.TweenEvent;
	import org.libspark.betweenas3.tweens.ITween;

	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]
	
	public class Typography extends Sprite
	{
		private var container:Sprite;
		private var viewport:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var render:BasicRenderEngine;
		private var rootNode:DisplayObject3D;
		private var words:Text3D;
		private var theta:Number;
		private var delayTime:Number;
		private var WordMoveType:Number;

		private const zoom:Number=20;
		private const focus:Number=30;
		private const distance:Number=600;
		
		private var _tween:ITween;
		private var _twscale:Number = 0.5;

		public function Typography()
		{
			theta=0;
			WordMoveType=0;
			delayTime=0;

			container=new Sprite();
			addChild(container);
			container.x=stage.stageWidth / 2;
			container.y=stage.stageHeight / 2;

			viewport=new Viewport3D(0, 0, true, true);
			scene=new Scene3D();
			camera=new Camera3D();
			render=new BasicRenderEngine();
			rootNode=scene.addChild(new DisplayObject3D("rootNode"));
			addChild(viewport);
			camera.target=DisplayObject3D.ZERO;
			camera.zoom=zoom;
			camera.focus=focus;

			var mat:Letter3DMaterial=new Letter3DMaterial();
			mat.fillColor=0xFFFFFF;
			mat.doubleSided=true;
			mat.doubleSided=mat.interactive=true;
			words=new Text3D("Sample of Papervision3D", new HelveticaBold(), mat);
			rootNode.addChild(words);
			words.y=0;
			words.scale=0.4;

			dispersionWords(words);
			addEventListener(Event.ENTER_FRAME, onFrame);
			stage.addEventListener(MouseEvent.CLICK,evClick);
		}

		private function evClick(e:MouseEvent):void
		{
			if(_twscale > 1){
				_twscale = 0.2
			}else{
				_twscale = 5
			}
			_tween.stop();
			var pos:Number = _tween.position / _tween.duration;
			_tween = BetweenAS3.scale(_tween, _twscale);
			_tween.gotoAndPlay(_tween.duration * pos);
		}
		
		private function dispersionWords(words:Text3D):void
		{
			var base:Array = [];
			for each(var word:DisplayObject3D in words.letters)
			{
				word.extra={x:word.x, y:word.y, z:word.z};
				var tw:ITween;
				tw = 
					BetweenAS3.parallel(
					BetweenAS3.tween(word,{x:Math.random() * 1000 - 500},{x:word.x},3,Elastic.easeOut),
					BetweenAS3.tween(word,{y:Math.random() * 1000 - 500},{y:word.y},3,Elastic.easeOut),
					BetweenAS3.tween(word,{z:Math.random() * 1000 - 500},{z:word.z},3,Elastic.easeOut),
					BetweenAS3.tween(word,{rotationX:Math.random() * 360},{rotationX:0},4,Elastic.easeOut),
					BetweenAS3.tween(word,{rotationY:Math.random() * 360},{rotationY:0},4,Elastic.easeOut),
					BetweenAS3.tween(word,{rotationZ:Math.random() * 360},{rotationZ:0},4,Elastic.easeOut)
					);
				base.push(tw);
			}
			_tween = BetweenAS3.serial( BetweenAS3.parallelTweens(base) );
			_tween.addEventListener(TweenEvent.COMPLETE, resetWords); 
			_tween.play();
		}
		private function resetWords(e:TweenEvent):void
		{
			_tween.removeEventListener(TweenEvent.COMPLETE, resetWords); 
			var base:Array = [];
			for each(var word:DisplayObject3D in words.letters)
			{
				var tw:ITween;
				tw = BetweenAS3.delay(
						BetweenAS3.parallel(
						BetweenAS3.tween(word,{x:word.extra.x},{x:word.x},2,Elastic.easeOut),
						BetweenAS3.tween(word,{y:word.extra.y},{y:word.y},2,Elastic.easeOut),
						BetweenAS3.tween(word,{z:word.extra.z},{z:word.z},2,Elastic.easeOut),
						BetweenAS3.tween(word,{rotationX:0},{rotationX:word.rotationX},2,Elastic.easeOut),
						BetweenAS3.tween(word,{rotationY:0},{rotationY:word.rotationY},2,Elastic.easeOut),
						BetweenAS3.tween(word,{rotationZ:0},{rotationZ:word.rotationZ},2,Elastic.easeOut)
						),delayTime);
				delayTime+=0.1;
				base.push(tw);
			}
			_tween = BetweenAS3.serial( BetweenAS3.parallelTweens(base) );
			_tween.addEventListener(TweenEvent.COMPLETE, rollWords); 
			_tween.play();
		}
		private function rollWords(e:TweenEvent):void
		{
			_tween.removeEventListener(TweenEvent.COMPLETE, rollWords); 
			var base:Array = [];
			for each(var word:DisplayObject3D in words.letters)
			{
				
				var tw:ITween;
				tw = BetweenAS3.delay(
						BetweenAS3.parallel(
						BetweenAS3.tween(word,{rotationY:720},{rotationY:word.rotationY},1,Elastic.easeOut)
						),delayTime);
				delayTime+=0.1;
				base.push(tw);
			}
			_tween = BetweenAS3.serial( BetweenAS3.parallelTweens(base) );
			_tween.addEventListener(TweenEvent.COMPLETE, breakWords); 
			_tween.play();
		}

		private function breakWords(e:TweenEvent):void
		{
			_tween.removeEventListener(TweenEvent.COMPLETE, breakWords); 
			var base:Array = [];
			for each(var word:DisplayObject3D in words.letters)
			{
				var tw:ITween;
				tw = BetweenAS3.delay(
					BetweenAS3.parallel(
					BetweenAS3.tween(word,{x:Math.random() * 1000 - 500},{x:word.x},2,Elastic.easeOut),
					BetweenAS3.tween(word,{y:Math.random() * 1000 - 500},{y:word.y},2,Elastic.easeOut),
					BetweenAS3.tween(word,{z:Math.random() * 1000 - 500},{z:word.z},2,Elastic.easeOut),
					BetweenAS3.tween(word,{rotationX:Math.random() * 360},{rotationX:0},2,Elastic.easeOut),
					BetweenAS3.tween(word,{rotationY:Math.random() * 360},{rotationY:0},2,Elastic.easeOut),
					BetweenAS3.tween(word,{rotationZ:Math.random() * 360},{rotationZ:0},2,Elastic.easeOut)
					),1);
				base.push(tw);
			}
			_tween = BetweenAS3.serial( BetweenAS3.parallelTweens(base) );
			_tween.addEventListener(TweenEvent.COMPLETE, resetWords); 
			_tween.play();
		}

		private function onFrame(e:Event):void
		{
			camera.x=distance * Math.sin(theta * Math.PI / 180);
			camera.z=distance * Math.cos(theta * Math.PI / 180);
			theta+=0.5;

			setBlur(words);
			render.renderScene(scene, camera, viewport);
		}

		private function DistanceFromCamera(obj:DisplayObject3D):Number
		{
			var vecX:Number=obj.sceneX - camera.x;
			var vecY:Number=obj.sceneY - camera.y;
			var vecZ:Number=obj.sceneZ - camera.z;
			return Math.sqrt((vecX * vecX) + (vecY * vecY) + (vecZ * vecZ));
		}

		private function setBlur(words:Text3D):void
		{
			for each(var word:DisplayObject3D in words.letters)
			{
				var vpl:ViewportLayer=word.createViewportLayer(viewport, true);
				var d:Number=Math.abs(DistanceFromCamera(word) - distance) / 40;
				vpl.filters=[new BlurFilter(d, d, 1)];
			}
		}
	}
}