/**
 * Copyright tororo_zz ( http://wonderfl.net/user/tororo_zz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oE8K
 */

/* ---------------------------------------------------------------------------
 * クウォータービューのキャラチップの表示
 * 
 * 今作ろうとしてるゲームのマップ表示をwonderflで表示できるかテスト
 * 昔作った作品のコードを見ながら再構築してるのですが
 * 自分でかいた過去のコードがサッパリ読めなくて困ってますｗｗｗ
 *
 * キャラチップを分解して適当にオブジェクト管理をする。
 * ---------------------------------------------------------------------------
 */

/* ---------------------------------------------------------------------------
 * Main
 * --------------------------------------------------------------------------- */
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;

    [SWF(frameRate="36")]
    　
    public class Main extends MovieClip
    {
        //*--クラスとステージ500
        public var main:Main
        public var sT:Stage = stage;
        public var baseSp:Sprite = new Sprite;
                
        //*--インターフェイスオブジェクト
        public var charaObj:Object = { } //キャラBitmapData格納
        
        public var mainEF:String = "mEnterFrame"
        
        //*--チップサイズ
        public var chipSize:int = 32; //チップサイズ
                
        //*---URLの格納
        public var urlAry:Array = [ "http://assets.wonderfl.net/images/related_images/a/a7/a70a/a70a6384cdd81f51123a8df8720dd180a9bf7fe3" ]
        
        //*--画像アクセスプロパティ
        public var bmdObj:Object = { } //一時的に読込クラスの格納
        public var chNum:int = 1 //現在の職業数
        
        //*--繰返し使用
        public var point:Point = new Point( 0, 0 )
        public var rct:Rectangle = new Rectangle( 0, 0, 32, 32 )
        public var chbmd:BitmapData = new BitmapData( 32, 32, true, 0x00ffffff )
        //*----------    
        
        public function Main():void
        {
            main = this
            
            sT.addChildAt( baseSp, 0);
            baseSp.addChildAt( new Sprite, 0 )
            
            init();
        }//Main
        
        public function init():void
        {
            //*--EventGroupでイベント登録
            var eGrp:EventGroup = new EventGroup( imgLoadEnd );
            
            //*--画像読込
            new LoaderChara( main, chNum - 1, eGrp );  //chara読込み

        }//init

        public function imgLoadEnd( event:Event ):void
        {
            charaObj = bmdObj[chNum - 1].retnObj(); //画像読込chaObjに格納
            
            //*--受渡し処理が完了したので一時データ廃棄
            bmdObj = null
            urlAry = null
            
            
            main.addEventListener( Event.ENTER_FRAME, mainEnterFrame );
            testChAdd();
            
        }//mgLoadEnd
        
        public function mainEnterFrame( event:Event ):void
        {
            main.dispatchEvent( new Event( "mEnterFrame"))
        }//mainEnterFrame
        
        public function testChAdd():void
        {
            new CharaMain( main )
        }//testChAdd
    }//class Main
}//package

/* ---------------------------------------------------------------------------
 * LoaderChara
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    /**-public**/ class LoaderChara extends Bitmap
    {
        public var main:Main;
        public var bmdObj:Object = { }
        public var loaderA:Loader = new Loader();
        public var loaderB:Loader = new Loader();
        public var bmdc:BitmapData//雛形コピー用
        public var chip:int;
        
        public function LoaderChara( _main:Main, num:int, eGrp:EventGroup ):void
        {
            main = _main
            chip = main.chipSize
            bmdc = new BitmapData(chip, chip, true, 0xffffffff);//雛形コピー用
            
            main.bmdObj[num] = this
            
            eGrp.addEvent(this, Event.COMPLETE);
          
            loaderA.load( new URLRequest( main.urlAry[num] ) );
            loaderA.contentLoaderInfo.addEventListener(Event.COMPLETE, initHandler);
            

        }//LoaderMap
        
        private function initHandler(event:Event):void
        {    
            loaderB.contentLoaderInfo.addEventListener(Event.INIT, completeHandler);
            loaderB.loadBytes(loaderA.contentLoaderInfo.bytes);
        }//initHandler
        
        public function completeHandler( event:Event ):void
        {
            var num:int
            
            var loadimg:Loader = event.currentTarget.loader;
            var bmp:Bitmap = new Bitmap();
            var bd:BitmapData = new BitmapData(loadimg.width, loadimg.height, false);
            bd.draw(loadimg);
            bmp.bitmapData = bd
                        
            for ( var i:int = 0; i < 4; i++ ) //方向番号　1～4
            {
                var h:int = i + 1
                bmdObj[h] = { }
                for ( var v:int = 0; v < 11; v++ ) //モーション番号　1～11
                {
                    var w:int = v + 1
                    bmdObj[h][w] = bmpch( bmp, v, i ); //読込んだ画像をBitmapDataに変換
                }
            }
            
            dispatchEvent(new Event(Event.COMPLETE));
            
        }//completeHandler
        
        /**-ビットマップデータ切取
         * @param tage　読込んだBitmap
         * @param v　X軸修正値
         * @param i　Y軸修正値**/
        public function bmpch(tage:Bitmap, w:int = 0, h:int = 0):BitmapData
        {

            var tagebmd:BitmapData = tage.bitmapData;
            var clipbmd:BitmapData = bmdc.clone()
            clipbmd.copyPixels( tagebmd, tagebmd.rect, new Point( ( -chip) * w, ( -chip) * h ) );//clipbmdに描画
            clipbmd.threshold(clipbmd, clipbmd.rect, new Point(), "==", 0xFFFFFFFF, 0x0, 0x00FFFFFF);//透過処理        

            return clipbmd
        }//bmpch

        public function retnObj():Object
        {
            return bmdObj;
        }//completeHandler
        
    }//class LoaderMap
//}package

/* ---------------------------------------------------------------------------
 * EventGroup
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.events.EventDispatcher;
    import flash.events.Event;
    
    /**-public**/ class EventGroup extends EventDispatcher
    {
        private var eventCount:uint;
        
        /**-コンストラクタ
         * @param func　DispatchEventで起動させる関数**/
        public function EventGroup( func:Function ):void
        {
            this.addEventListener(Event.COMPLETE, func);
        }//EventGroup
        
        /**-イベント追加
         * @param target　イベント追加するオブジェクト
         * @param type　イベント追加するイベント名**/
        public function addEvent( target:EventDispatcher, type:String ) : void
        {
            target.addEventListener(type, onEvent);
            eventCount++;
        }//addEvent
        
        /**-イベント発生**/
        private function onEvent( event:* ):void
        {
            event.target.removeEventListener( event.type, onEvent );
            eventCount--;
            if (eventCount == 0)
            {
                dispatchEvent(new Event(Event.COMPLETE));//グループイベント完了
            }
        }//onEvent
    }//class EventGroup
//}package

//package
//{
    import flash.display.*;
    import flash.events.*;
    
    /**-public**/ class CharaMain extends Bitmap
    {
        //*--キャラ表示用ビットマップ
        public var tesbmp1:Bitmap
        public var tesbmp2:Bitmap
        public var tesbmp3:Bitmap
        public var tesbmp4:Bitmap
        
        
        //*--クラスとステージ関連付け
        protected var main:Main
        protected var chara:CharaMain
        protected var baseSp:Sprite
        //*----------
        
        //*--アクション関連
        public var fre:int = 0 //Frameカウント用
        
        /* ---------------------------------------------------------------------------
         * Main　キャラアクションの設定
         * --------------------------------------------------------------------------- */
        //*--フレーム
        public var f0:int = 1
        public var f1:int = 12
        public var f2:int = f1*2
        public var f3:int = f1*3
        public var f4:int = f1*4
        //*----------
        
        //*--キャラアクションの設定
        public var acObj:Array =
        [
            [ f2, 1, f1, 2 ], //1:待機
            [ f3, 1, f1, 2, f2, 5 ], //3:攻撃
            [ f3, 1, f1, 8, f2, 9 ], //4:死亡
            [ f3, 1, f1, 2, f2, 10 ], //5:万歳
            [ f4, 6, f2, 7 ], //6:首振
            [ f3, 1, f2, 11 ], //7:ダメージ
            [ f4, 1, f2, 4 ], //8:ジャンプ
        ]
        
        //*--フレーム処理用
        public var acObjCut:int = 0
        public var chAcCut:Object
        
        public var cutNum:int = 0
        public var chAcNum:int
        
        //*----------
        /**-コンストラクタ
         * @param _main Mainプロパティアクセス用**/
        public function CharaMain( _main:Main ):void
        {            
            //*--クラスとステージ関連
            main = _main
            chara = this
            baseSp = main.baseSp
                        
            //*--キャラ行動起動
            charaAdd()
            
        }//CharaHei
        
        /**-キャラデータ表示**/
        public function charaAdd():void
        {    
            
            main.addEventListener( main.mainEF, chEnterFrame );
                        
            tesbmp1 = bmpchara(0, 50)
            tesbmp2 = bmpchara(50, 50)
            tesbmp3 = bmpchara(50, 0)
            tesbmp4 = bmpchara(0, 0)
        }//charaAdd
        
        public function bmpchara( _x:Number, _y:Number):Bitmap
        {
            var tesbmp:Bitmap = new Bitmap();
            tesbmp.scaleX = tesbmp.scaleY = 2;
            tesbmp.x = _x;
            tesbmp.y = _y;
            main.sT.addChild(tesbmp);
            
            return tesbmp
        }//bmpchara
                
        /**
         *--func関数に格納したしたモーションを起動 CharaMotion.charaMotionで初期化
         **/
        public function chEnterFrame( event:Event ):void
        {
            chCut()
            fre++;
        }//chEnterFrame
        

        
        //*--キャラクターモーション代入 特定フレームでBitmapDataをキャラに代入
        public function chCut():void
        {
            chAcCut = acObj[acObjCut]
            
            if ( fre == chAcCut[cutNum] )
            {
                trace("tes")
                cutNum++
                chBmdCh(chAcCut[cutNum])
                cutNum++
                
            }
            
            if ( acObj[acObjCut].length == cutNum ) { acObjCut++; cutNum = 0 }
            if ( acObj.length == acObjCut ) { acObjCut = 0 }
            
        }//chCut
        
        //*--キャラの配列を代入
        public function chBmdCh(freCut:int):void
        {
            tesbmp1.bitmapData = main.charaObj[1][ freCut ];
            tesbmp2.bitmapData = main.charaObj[2][ freCut ];
            tesbmp3.bitmapData = main.charaObj[3][ freCut ];
            tesbmp4.bitmapData = main.charaObj[4][ freCut ];
            
            fre = 0
        }//chBmdCh
        
    }//class CharaMain
//}package


