/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oDzU
 */

/**
 * CirclesLoveLines step 2
 * @Revision 
 * 		- Lets project a line segment from lineA to circlaA!
 * 
 * @author Mario Gonzalez
 * @see http://onedayitwillmake.com/
 * @note: This series of experiments is being created because.
 */
package
{ 
		
    import flash.display.Sprite;
	
	[SWF(frameRate="60", width="465", height="465", backgroundColor="#00ffcc")]
	
    public class CircleLineSegmentTest extends Sprite
    {
    	public function CircleLineSegmentTest():void
    	{
    		var a1:Vector2D = new Vector2D(stage.stageWidth * 0.5, stage.stageHeight);
    		var b1:Vector2D = new Vector2D(Math.random() * stage.stageWidth, Math.random() * stage.stageHeight);
    		var lineA:Line = new Line(a1, b1, 0xff0000);
    			addChild(lineA);
    		
    		var x1:Vector2D = new Vector2D(232, 232);
    		var circleA:Circle = new Circle(b1, 8);
    			addChild(circleA);
    			
    		var lineB:Line = new Line(a1, x1.subtract(a1)); 
    			addChild(lineB);
    	}
    	/**
    	 * Find the closest point in a linesegment given point X  
    	 * @param X	Point to test against. 
    	 * @param A LineSegment point A
    	 * @param B LineSegment point B
    	 */    	
    	public static function closestPointLineSegment(X:Vector2D, A:Vector2D, B:Vector2D):void
    	{
    	
    	}
    }
}

import flash.geom.Point;
import flash.display.Shape;
import flash.display.Sprite;

internal class Vector2D
{
	public var x:Number, y:Number
	public function Vector2D(x1:Number, y1:Number):void
	{
		x = x1;
		y = y1;
	}
	
	public function subtract(from:Vector2D):Vector2D
	{
		return new Vector2D(x - from.x, y - from.y);
	}
}

internal class Line extends Shape
{
	public var A:Vector2D, B:Vector2D; //A |----| B
	
	//Draw
	public var _color		:uint = 0x666666;
	public var __isDirty	:Boolean = false;
	public function Line(a:Vector2D, b:Vector2D, color:uint = 0x666666):void
	{
		A = a;
		B = b;
		_color = color;
		_isDirty = true;
	}
	
	public function draw():void
	{
		resetGraphics();
		graphics.moveTo(A.x, A.y);
		graphics.lineTo(B.x, B.y);
	}
	
	public function resetGraphics():void
	{
		graphics.clear();
		graphics.lineStyle(2, _color, 0.75);
	}
	
	public function get _isDirty():Boolean { return __isDirty };
	public function set _isDirty(value:Boolean):void
	{
		__isDirty = value;
		draw();
	}
}

internal class Circle extends Sprite
{
	public var _center	:Vector2D;
	public var _radius	:int;
	
	public function Circle(center:Vector2D, radius:int):void
	{
		_center = center;
		_radius = radius;
		
		x = _center.x;
		y = _center.y;
		
		//Draw
		graphics.beginFill(0xffffff, 1)
			graphics.drawCircle(0, 0, 2);
			graphics.drawCircle(0, 0, 6);
			graphics.drawCircle(0, 0, 7);
		graphics.endFill();
	}
	
	public function resetGraphics():void
	{
		graphics.clear();
		graphics.lineStyle(1, 0x666666, 1);
	}
}