/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oDkG
 */


package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.ui.*;
    import flash.text.*;
    
    public class FlashTest extends Sprite 
    {
        public  const SW           :Number   =  stage.stageWidth        
        public  const SH           :Number   =  stage.stageHeight 
        public  const nodeSize         :Number   =  10             
        public  var   NODE_01          :Sprite   =  new Sprite()
        public  var   NODE_02          :Sprite   =  new Sprite()
        public  var   LINE_0102        :Sprite   =  new Sprite()
        public  var   focalLength      :Number   =  1000
        

                
        public function FlashTest()
        {   
            this.focalLength = 1000
            // ENTRY POINT:
            
            var p1Vec3D            :Vector3D     =  new Vector3D(  100,SH/2,000               ) 
            var p2Vec3D            :Vector3D     =  new Vector3D(  250,SH/2+60,400               )       
            var point_1            :Point        =  new Point(     p1Vec3D.x,p1Vec3D.y      )
            var point_2            :Point        =  new Point(     p2Vec3D.x,p2Vec3D.y      )
          //var p2D_1              :Point        =  new Point(     p1Vec3D.x*t1,p1Vec3D.y*t1)  // p1Vec3D.x,p1Vec3D.y  )
          //var p2D_2              :Point        =  new Point(     p2Vec3D.x*t2,p2Vec3D.y*t2)  // p2Vec3D.x,p2Vec3D.y  )
            
            //NODE_01.scaleX   =   NODE_01.scaleY  =  1 * t1; // 1 * 0.0 == 0.0;
            //NODE_02.scaleX   =   NODE_02.scaleY  =  1 * t2; // 1 * 0.9 == 0.9;

            var angleBetween       :Number       =  Vector3D.angleBetween( p1Vec3D,p2Vec3D ) * (180/Math.PI)  
            var distanceBetween    :Number       =  Point.distance(point_1, point_2)       
            var t1                 :Number       =  ( (focalLength) / (focalLength) + p1Vec3D.z)     
            var t2                 :Number       =  ( (focalLength) / (focalLength) + p2Vec3D.z)     
            var interpDist:Number = new Number()//  p1Vec3D.interpolate.distance(point_1, point_2)  )       
            var distanceTxt :TextField = new TextField();
            var angleTxt    :TextField = new TextField();
            var format:TextFormat = new TextFormat();
            
            stage.addEventListener( Event.ENTER_FRAME,drawNodes )
            stage.addEventListener( Event.ENTER_FRAME,drawLines )
                        
            function drawNodes(event:Event):void
            {        
                stage.removeEventListener( Event.ENTER_FRAME,drawNodes )              
                
                NODE_01.graphics.beginFill( 0x0066FF,1 )
                NODE_01.graphics.drawCircle(  0,0,nodeSize  )
                //NODE_01.graphics.endFill()
                NODE_01.x = p1Vec3D.x
                NODE_01.y = p1Vec3D.y
                NODE_01.z = p1Vec3D.z
                addChild( NODE_01 )
              
                NODE_02.graphics.beginFill( 0xFF0000,1 )
                NODE_02.graphics.drawCircle(  0,0,nodeSize  )
                //NODE_02.graphics.endFill()                
                NODE_02.x = p2Vec3D.x
                NODE_02.y = p2Vec3D.y
                NODE_02.z = p2Vec3D.z
                addChild( NODE_02 )
            } 
            function drawLines(event:Event):void
            {    
                //var vLine:Rectangle = new Rectangle( 0,0,50,3 )    
                LINE_0102.graphics.beginFill( 0x131413,1 )
                LINE_0102.graphics.drawRect( 0,0,distanceBetween,3 ) 
                LINE_0102.x = NODE_01.x  //  NODE_01.local3DToGlobal(p1Vec3D).x 
                LINE_0102.y = NODE_01.y  //  NODE_01.local3DToGlobal(p1Vec3D).y                
                LINE_0102.z = NODE_01.z  //  
                LINE_0102.rotationZ  =  angleBetween   //Math.atan2(NODE_02.y,NODE_01.x)//  radians * 180 / Math.PI  // angleBetween
                
                //LINE_0102.graphics.lineStyle( 3,0x000000,1 )
                //LINE_0102.graphics.moveTo( NODE_02.x,NODE_02.y ) //NODE_01.local3DToGlobal(p1Vec3D).x,NODE_01.local3DToGlobal(p1Vec3D).y )   // NODE_01.x,NODE_01.y )   // NODE_02.local3DToGlobal(p1Vec3D).x,NODE_02.local3DToGlobal(p1Vec3D).y ) 
                //LINE_0102.graphics.moveTo( NODE_02.local3DToGlobal(p2Vec3D).x,NODE_02.local3DToGlobal(p2Vec3D).y ) //.x,NODE_02.y )
                //LINE_0102.graphics.moveTo( NODE_02.x,NODE_02.y )
                
                addChild( LINE_0102 )
            }    
            

            
            format.size = 11;
            
            distanceTxt.defaultTextFormat = format;                        
            distanceTxt.text = "distanceBetween:      " + distanceBetween.toString();
            distanceTxt.x = 30;
            distanceTxt.y = 100;
            distanceTxt.width = 300;
            stage.addChild( distanceTxt );
            
            angleTxt.defaultTextFormat = format;      
            angleTxt.text = "angleBetween (deg): " + angleBetween.toString();
            angleTxt.x = 30;
            angleTxt.y = 110;
            angleTxt.width = 300;
            stage.addChild( angleTxt );                  

        }
    }
}







/*
example (in pseudo code);

focalLength = 1000;
         
        point3d.x = 100;
        point3d.y = 50;
        point3d.z = 100;
         
        t = focalLength / (focalLength + point3d.z); // 1000 / (1000+100) == 0.9;
         
        point2d.x = point3d.x * t;  // 100 * 0.9 == 90;
        point2d.y = point3d.y * t; // 50 * 1.1 == 45;
        point2d.scale = 1 * t; // 1 * 0.9 == 0.9;
         
        /* The projected version of 3dPoint (100, 50, 100)
        is therefore point2d (90, 45); with a scale of 0.9
        
*/    