/**
 * Copyright shevchenko ( http://wonderfl.net/user/shevchenko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oDRp
 */

import org.papervision3d.scenes.*;
import org.papervision3d.cameras.*;
import org.papervision3d.objects.*;
import org.papervision3d.objects.special.*;
import org.papervision3d.objects.primitives.*;
import org.papervision3d.materials.*;
import org.papervision3d.materials.special.*;
import org.papervision3d.materials.shaders.*;
import org.papervision3d.materials.utils.*;
import org.papervision3d.render.*;
import org.papervision3d.view.*;
import org.papervision3d.events.*;
import org.papervision3d.core.utils.*;
import org.papervision3d.core.utils.virtualmouse.VirtualMouse;
import org.papervision3d.core.geom.TriangleMesh3D;
import org.papervision3d.core.math.Number3D;
import org.papervision3d.core.math.Quaternion;
import org.papervision3d.core.proto.CameraObject3D;
import org.papervision3d.lights.PointLight3D;
import org.papervision3d.objects.parsers.DAE;
import org.papervision3d.objects.special.ParticleField;
import org.papervision3d.view.layer.util.ViewportLayerSortMode;
import ShadowCaster;
import ShadowRayCasting;
 
 
//to cast shadows we will need dummy sprite object
//that we can draw our shadows into using the ShadowCaster object
var spr:Sprite;
//That dummy sprite will then be passed into a moviematerial
//where we can project our shadows into our 3D scene
var sprMaterial:MovieMaterial;
var shadowPlane:Plane;
var wire:WireframeMaterial;
var color:ColorMaterial;
var composite:CompositeMaterial;
var cylinder:Cylinder;
var shadowCaster:ShadowCaster;
 
//Instantiate your dummy sprite
spr = new Sprite();
//draw a rectangle into your dummy sprite
//note that if you don't want your plane to show in the scene
//but you do want shadows, you can set the alpha of the
//beginFill method to 0 (shadows will be drawn but the plane color fill will not)
spr.graphics.beginFill(0xFFFFFF,0);
 
//the larger the "drawRect" shape the better the quality of your shadows
spr.graphics.drawRect(0,0, 500, 500);
 
//Add the dummy sprite to a MovieMaterial object
sprMaterial = new MovieMaterial(spr, true, true, true);
 
//create a plane and apply your dummy sprite MovieMaterial to it
shadowPlane = new Plane(sprMaterial, 2000, 2000, 1, 1);
//rotate and orient your plane so that it is aligned as the floor/ground
shadowPlane.rotationX = 90;
shadowPlane.y = -400;
 
//Instantiate your shadowCaster object
//The parameters are as follows
//ShadowCaster("name", shadow color, blend mode, shadow alpha, [filters]);
shadowCaster = new ShadowCaster("shadow", 0x000000, BlendMode.MULTIPLY, .1, [new BlurFilter(20,20, 1)]);
//Set the light type (options are SPOTLIGHT and DIRECTIONAL)
shadowCaster.setType(ShadowCaster.SPOTLIGHT);
 
 
 
 
 
stage.quality = "medium";
var viewport:Viewport3D = new Viewport3D(0, 0, true , true);
addChild(viewport);
viewport.buttonMode = true;
viewport.interactive =true;
 
var renderer:BasicRenderEngine = new BasicRenderEngine();
 
var scene:Scene3D = new Scene3D();
 
var camera:Camera3D = new Camera3D();
camera.zoom = 11;
camera.focus = 100;
camera.y =0;
camera.z = -1500;
const MAX_VELOCITY:Number = 4;
var xDist:Number = 0;
var yDist:Number = 0;
var paperCanvas:Sprite;
//var flatShaderMat:FlatShadeMaterial;
 
// light
var pointLight = new PointLight3D (true, false);// 2nd would be true for collada
pointLight.x = 0;
pointLight.y = 500;
pointLight.z = -1000;
 
 
 
var materials = new MaterialsList ();
 
var mm0:MovieMaterial = new MovieMaterial(face1);
var phongShader0:PhongShader = new PhongShader(pointLight, 0xFFFFFF, 0x999999 , 50);
var shadedMaterial0:ShadedMaterial = new ShadedMaterial(mm0, phongShader0);
shadedMaterial0.interactive = true;
//shadedMaterial0.animated = true;
shadedMaterial0.smooth = true;
materials.addMaterial(shadedMaterial0, "front");
 
var mm1:MovieMaterial = new MovieMaterial(face2);
var phongShader1:PhongShader = new PhongShader(pointLight, 0xFFFFFF, 0x999999 , 50);
var shadedMaterial1:ShadedMaterial = new ShadedMaterial(mm1, phongShader1);
shadedMaterial1.interactive = true;
//shadedMaterial1.animated = true;
shadedMaterial1.smooth = true;
materials.addMaterial(shadedMaterial1, "back");
 
var mm2:MovieMaterial = new MovieMaterial(face3);
var phongShader2:PhongShader = new PhongShader(pointLight, 0xFFFFFF, 0x999999 , 50);
var shadedMaterial2:ShadedMaterial = new ShadedMaterial(mm2, phongShader2);
shadedMaterial2.interactive = true;
//shadedMaterial2.animated = true;
shadedMaterial2.smooth = true;
materials.addMaterial(shadedMaterial2, "left");
 
var mm3:MovieMaterial = new MovieMaterial(face4);
var phongShader3:PhongShader = new PhongShader(pointLight, 0xFFFFFF, 0x999999 , 50);
var shadedMaterial3:ShadedMaterial = new ShadedMaterial(mm3, phongShader3);
shadedMaterial3.interactive = true;
//shadedMaterial3.animated = true;
shadedMaterial3.smooth = true;
materials.addMaterial(shadedMaterial3, "right");
 
var mm4:MovieMaterial = new MovieMaterial(face5);
var phongShader4:PhongShader = new PhongShader(pointLight, 0xFFFFFF, 0x999999 , 50);
var shadedMaterial4:ShadedMaterial = new ShadedMaterial(mm4, phongShader4);
shadedMaterial4.interactive = true;
//shadedMaterial4.animated = true;
shadedMaterial4.smooth = true;
materials.addMaterial(shadedMaterial4, "bottom");
 
var mm5:MovieMaterial = new MovieMaterial(face6);
var phongShader5:PhongShader = new PhongShader(pointLight, 0xFFFFFF, 0x999999 , 50);
var shadedMaterial5:ShadedMaterial = new ShadedMaterial(mm5, phongShader5);
shadedMaterial5.interactive = true;
//shadedMaterial5.animated = true;
shadedMaterial5.smooth = true;
materials.addMaterial(shadedMaterial5, "top");
 
 
var cube:Cube = new Cube(materials,150, 150, 150 , 5 , 5 , 5);
cube.z = -200;
paperCanvas = new Sprite();
paperCanvas.x = stage.stageWidth/2;
paperCanvas.y = stage.stageHeight/2;
scene.addChild(cube);
scene.addChild(pointLight);
scene.addChild(shadowPlane);
addChild(paperCanvas);
 
addEventListener(Event.ENTER_FRAME, loop);
 
function loop(e:Event):void
{
 
 
 
    if (mouseX > stage.stageWidth/2+150 || mouseX < stage.stageWidth/2-150)
    {
        xDist += -paperCanvas.mouseX/1000;
    }
    else
    {
        xDist -= xDist / 15;
    }
    xDist = Math.min(Math.max(-MAX_VELOCITY,xDist), MAX_VELOCITY);
 
    if (mouseY > stage.stageHeight/2+150 || mouseY < stage.stageHeight/2-150)
    {
        yDist += -paperCanvas.mouseY / 1000;
    }
    else
    {
        yDist -= yDist / 15;
    }
    yDist = Math.min(Math.max(-MAX_VELOCITY, yDist), MAX_VELOCITY);
 
 
    //the invalidate() method basically clears the previously drawn shadow
    shadowCaster.invalidate();
    //the castModel method casts the shadow of an object in your scene
    //castModel parameters are as follows
    //castModel(object to cast shadow from, light, plane to cast the shadow onto
    shadowCaster.castModel(cube, pointLight, shadowPlane);
    cube.rotationY -= xDist * 3;
    cube.rotationX -= yDist * 3;
    renderer.renderScene(scene,camera,viewport);
 
 
}