/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oDNL
 */

////////////////////////////////////////////////////////////////////////////////
// EmitPanda
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import net.hires.debug.Stats;

    [SWF(backgroundColor="#FFFFFF",width="465",height="465",frameRate="60")]

    public class PandaEmitter extends Sprite {
        private static const PATH:String = "http://www.project-nya.jp/images/flash/panda2d.swf";
        private var Panda:Class;
        private var emit:EmitParticle;

        public function PandaEmitter(){
            Security.allowDomain("www.project-nya.jp");
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
            loader.load(new URLRequest(PATH), new LoaderContext(true));
        }

        private function completeHandler(evt:Event):void {
            removeEventListener(Event.COMPLETE, arguments.callee);
            var content:MovieClip = MovieClip(evt.target.content);
            //Pandaクラス
            Panda = MovieClip(content.panda).constructor;
            emit = new EmitParticle(Panda);
            addChild(emit);
            addChild(new Stats());
            
            mouseChildren = false;
            mouseEnabled = false;
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

/** EmitParticleクラス */
internal final class EmitParticle extends Sprite {
    private static const MAX_NUM:uint = 3000;
    private static const EMIT_NUM:Number = 30;
    private static const GRAVITY:Number = 0.5;
    private static const FRICTION:Number = 0.98;

    private var particles:Vector.<Particle>;
    private var count:int = 0;
    private var orijinal:BitmapData;
    private var canvas:BitmapData;

    public function EmitParticle(panda:Class){

        var disp:DisplayObject = new panda();

        // 元絵
        orijinal = new BitmapData(disp.width, disp.height, true, 0x0);
        orijinal.draw(disp, new Matrix(1, 0, 0, 1, 30, 60));

        // キャンバス
        canvas = new BitmapData(465, 465, false, 0xFFFFFFFF);
        addChild(new Bitmap(canvas));

        // オブジェクトプール
        particles = new Vector.<Particle>(MAX_NUM, true);
        for (var i:int = 0; i < MAX_NUM; i++){
            var p:Particle = new Particle();
            // どっかにいってもらう
            p.x = int.MAX_VALUE;
            p.y = int.MAX_VALUE;

            particles[i] = p;
        }
        addEventListener(Event.ENTER_FRAME, update);
    }

    private function emit():void {
        var p:Particle = particles[count];
        p.enable = true;
        p.vx = 20 * (Math.random() - 0.5);
        p.vy = -20 * (Math.random() - 0.5);
        p.x = mouseX;
        p.y = mouseY;

        count++;
        if (count == particles.length)
            count = 0;
    }

    private function hideParticle(p:Particle):void {
        p.enable = false;
        p.x = int.MAX_VALUE;
        p.y = int.MAX_VALUE;
    }

    private function update(evt:Event):void {
        for (var i:int = 0; i < EMIT_NUM; i++)
            emit();

        canvas.lock();
        canvas.fillRect(canvas.rect, 0xFFFFFFFF);

        for (i = 0; i < MAX_NUM; i++){
            var p:Particle = particles[i];
            if (p.enable){
                p.x += p.vx;
                p.y += p.vy;
                p.vx *= FRICTION;
                p.vy *= FRICTION;
                p.vy += GRAVITY;
                if (p.y > 465){
                    hideParticle(p);
                } else {
                    canvas.copyPixels(orijinal, orijinal.rect, new Point(p.x, p.y), null, null, true);
                }
            }
        }

        canvas.unlock();
    }
}

/** Particleクラス */
internal final class Particle {
    public var x:Number = 0;
    public var y:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var enable:Boolean = false;
}
