/**
 * Copyright o_healer ( http://wonderfl.net/user/o_healer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oCwC
 */

/*
　「Same Direction」
　・飛んでくる弾と同じ方向キーを押して撃ち落とすゲーム

　操作方法
　・↑、↓、←、→
　　・対応する弾を撃ち落とす

　その他
　・Hoobastankとは特に関係ありません
*/

/*
ToDo

対応
・スコアのランキング対応？
*/


package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
    import flash.ui.*;
    import net.wonderfl.utils.WonderflAPI;
 
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]
    public class GameMain extends Sprite {
        //==Const==

        //画面の大きさ
        static public const VIEW_W:int = 465;
        static public const VIEW_H:int = 465;

        //この回数ミスしたらゲームオーバー
        static public const MISS_END_NUM:int = 5;

        //ミスマークのグラフィック
        static public const MISS_LINE_W:int = 8;
        static public const MISS_WIDTH:int = 16;

        //Dir
        static public var DirIter:int = 0;
        static public const DIR_U:int    = DirIter++;
        static public const DIR_R:int    = DirIter++;
        static public const DIR_D:int    = DirIter++;
        static public const DIR_L:int    = DirIter++;
        static public const DIR_NUM:int    = DirIter;

        //弾の出現パターン
        static public const BULLET_DATA:Array = [
//*
            //チュートリアル：上下左右
            {Dir:DIR_U, RatioX:0.5, RatioY:0.0, Time:1.0, MoveTime:2.5},
            {Dir:DIR_D, RatioX:0.5, RatioY:1.0, Time:1.0, MoveTime:2.5},
            {Dir:DIR_L, RatioX:0.0, RatioY:0.5, Time:1.0, MoveTime:2.5},
            {Dir:DIR_R, RatioX:1.0, RatioY:0.5, Time:1.0, MoveTime:2.5},

            //チュートリアル：斜めを見せることで、あくまで表示方向を押すことを示す
            {Dir:DIR_U, RatioX:1.0, RatioY:0.0, Time:1.0, MoveTime:2.5},
            {Dir:DIR_D, RatioX:1.0, RatioY:1.0, Time:1.0, MoveTime:2.5},
            {Dir:DIR_R, RatioX:0.0, RatioY:1.0, Time:1.0, MoveTime:2.5},
            {Dir:DIR_L, RatioX:0.0, RatioY:0.0, Time:1.0, MoveTime:2.5},

            //チュートリアル：来る方向と表示方向が逆の上下左右
            {Dir:DIR_U, RatioX:0.5, RatioY:1.0, Time:1.0, MoveTime:2.5},
            {Dir:DIR_D, RatioX:0.5, RatioY:0.0, Time:1.0, MoveTime:2.5},
            {Dir:DIR_L, RatioX:1.0, RatioY:0.5, Time:1.0, MoveTime:2.5},
            {Dir:DIR_R, RatioX:0.0, RatioY:0.5, Time:1.0, MoveTime:2.5},

            //同時出現：上下
            {Dir:DIR_U, RatioX:0.5, RatioY:0.0, Time:2.0, MoveTime:2.5},
            {Dir:DIR_D, RatioX:0.5, RatioY:1.0, Time:0.0, MoveTime:2.5},

            //同時出現：左右
            {Dir:DIR_L, RatioX:0.0, RatioY:0.5, Time:2.0, MoveTime:2.5},
            {Dir:DIR_R, RatioX:1.0, RatioY:0.5, Time:0.0, MoveTime:2.5},

            //同時出現：ランダム×２
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:2.0, MoveTime:2.5},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.0, MoveTime:2.5},

            //同時出現：ランダム×２
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:2.0, MoveTime:2.5},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.0, MoveTime:2.5},

            //同時出現：上下左右
            {Dir:DIR_U, RatioX:0.5, RatioY:0.0, Time:3.0, MoveTime:2.5},
            {Dir:DIR_D, RatioX:0.5, RatioY:1.0, Time:0.0, MoveTime:2.5},
            {Dir:DIR_L, RatioX:0.0, RatioY:0.5, Time:0.0, MoveTime:2.5},
            {Dir:DIR_R, RatioX:1.0, RatioY:0.5, Time:0.0, MoveTime:2.5},

            //同時出現：ランダム×４
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:2.5, MoveTime:3.0},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.0, MoveTime:3.0},
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:0.0, MoveTime:3.0},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.0, MoveTime:3.0},

            //同時出現：ランダム×４
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:3.0, MoveTime:2.5},
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.0, MoveTime:2.5},
            {Dir:-1, RatioX:0.0, RatioY:0.5, Time:0.0, MoveTime:2.5},
            {Dir:-1, RatioX:1.0, RatioY:0.5, Time:0.0, MoveTime:2.5},

            //同時出現：ランダム×８：低速
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:3.0, MoveTime:6.0},
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:0.0, MoveTime:6.0},
            {Dir:-1, RatioX:1.0, RatioY:0.5, Time:0.0, MoveTime:6.0},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.0, MoveTime:6.0},
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.0, MoveTime:6.0},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.0, MoveTime:6.0},
            {Dir:-1, RatioX:0.0, RatioY:0.5, Time:0.0, MoveTime:6.0},
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:0.0, MoveTime:6.0},

            //同時出現：ランダム×８：中速
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:5.0, MoveTime:5.0},
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:0.0, MoveTime:5.0},
            {Dir:-1, RatioX:1.0, RatioY:0.5, Time:0.0, MoveTime:5.0},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.0, MoveTime:5.0},
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.0, MoveTime:5.0},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.0, MoveTime:5.0},
            {Dir:-1, RatioX:0.0, RatioY:0.5, Time:0.0, MoveTime:5.0},
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:0.0, MoveTime:5.0},

            //同時出現：ランダム×８：高速
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:4.0, MoveTime:4.0},
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:0.0, MoveTime:4.0},
            {Dir:-1, RatioX:1.0, RatioY:0.5, Time:0.0, MoveTime:4.0},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.0, MoveTime:4.0},
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.0, MoveTime:4.0},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.0, MoveTime:4.0},
            {Dir:-1, RatioX:0.0, RatioY:0.5, Time:0.0, MoveTime:4.0},
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:0.0, MoveTime:4.0},

            //大量の同方向（きっちり表示された数を押す）
            {Dir:DIR_U, RatioX:0.25, RatioY:0.00, Time:3.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.50, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.75, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:1.00, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:1.00, RatioY:0.25, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:1.00, RatioY:0.50, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:1.00, RatioY:0.75, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:1.00, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.25, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.50, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.75, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.00, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.00, RatioY:0.25, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.00, RatioY:0.50, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.00, RatioY:0.75, Time:0.0, MoveTime:6.0},
            {Dir:DIR_U, RatioX:0.00, RatioY:0.00, Time:0.0, MoveTime:6.0},

            {Dir:DIR_D, RatioX:0.25, RatioY:0.00, Time:6.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.50, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.75, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:1.00, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:1.00, RatioY:0.25, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:1.00, RatioY:0.50, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:1.00, RatioY:0.75, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:1.00, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.25, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.50, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.75, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.00, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.00, RatioY:0.25, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.00, RatioY:0.50, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.00, RatioY:0.75, Time:0.0, MoveTime:6.0},
            {Dir:DIR_D, RatioX:0.00, RatioY:0.00, Time:0.0, MoveTime:6.0},

            {Dir:DIR_L, RatioX:0.25, RatioY:0.00, Time:5.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.50, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.75, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:1.00, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:1.00, RatioY:0.25, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:1.00, RatioY:0.50, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:1.00, RatioY:0.75, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:1.00, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.25, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.50, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.75, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.00, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.00, RatioY:0.25, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.00, RatioY:0.50, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.00, RatioY:0.75, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.00, RatioY:0.00, Time:0.0, MoveTime:6.0},

            //１つだけ別
            {Dir:DIR_R, RatioX:0.25, RatioY:0.00, Time:4.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:0.50, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:0.75, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:1.00, RatioY:0.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:1.00, RatioY:0.25, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:1.00, RatioY:0.50, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:1.00, RatioY:0.75, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:1.00, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:0.25, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:0.50, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:0.75, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:0.00, RatioY:1.00, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:0.00, RatioY:0.25, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:0.00, RatioY:0.50, Time:0.0, MoveTime:6.0},
            {Dir:DIR_L, RatioX:0.00, RatioY:0.75, Time:0.0, MoveTime:6.0},
            {Dir:DIR_R, RatioX:0.00, RatioY:0.00, Time:0.0, MoveTime:6.0},

            //螺旋：ランダム×８：低速
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:5.0, MoveTime:3.0},
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:0.8, MoveTime:3.0},
            {Dir:-1, RatioX:1.0, RatioY:0.5, Time:0.8, MoveTime:3.0},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.8, MoveTime:3.0},
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.8, MoveTime:3.0},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.8, MoveTime:3.0},
            {Dir:-1, RatioX:0.0, RatioY:0.5, Time:0.8, MoveTime:3.0},
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:0.8, MoveTime:3.0},

            //螺旋：ランダム×８：中速
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.7, MoveTime:2.2},
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:0.6, MoveTime:2.0},
            {Dir:-1, RatioX:1.0, RatioY:0.5, Time:0.6, MoveTime:2.0},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.6, MoveTime:2.0},
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.6, MoveTime:2.0},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.6, MoveTime:2.0},
            {Dir:-1, RatioX:0.0, RatioY:0.5, Time:0.6, MoveTime:2.0},
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:0.6, MoveTime:2.0},

            //螺旋：ランダム×８：高速
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.5, MoveTime:1.8},
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:1.0, RatioY:0.5, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.0, RatioY:0.5, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:0.4, MoveTime:1.6},

            //螺旋：ランダム×８：高速もう一周
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:1.0, RatioY:0.5, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.0, RatioY:0.5, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:0.4, MoveTime:1.6},

            //螺旋：ランダム×８：高速さらにもう一周
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:1.0, RatioY:0.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:1.0, RatioY:0.5, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:1.0, RatioY:1.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.0, RatioY:1.0, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.0, RatioY:0.5, Time:0.4, MoveTime:1.6},
            {Dir:-1, RatioX:0.0, RatioY:0.0, Time:0.4, MoveTime:1.6},

            //高速弾：導入
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:3.0, MoveTime:2.4},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:2.0, MoveTime:2.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:1.8, MoveTime:2.0},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:1.4, MoveTime:1.8},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:1.0, MoveTime:1.6},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.8, MoveTime:1.4},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},

            //高速弾：連射
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},

            //高速弾：不意打ち
            {Dir:-1, RatioX:0.5, RatioY:1.0, Time:0.4, MoveTime:1.2},

            //高速弾：連射
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
            {Dir:-1, RatioX:0.5, RatioY:0.0, Time:0.4, MoveTime:1.2},
//*/

            //End～Random
            {Dir:DIR_L, RatioX:0.0, RatioY:0.0, Time:4.0, MoveTime:2.5},
        ];


        //==Var==

        //Pseudo Singleton
        static public var Instance:GameMain;

        //レイヤー
        public var m_Layer_Root:Sprite = new Sprite();
        public var  m_Layer_BG:Sprite = new Sprite();
        public var  m_Layer_Bullet:Sprite = new Sprite();
        public var  m_Layer_Effect:Sprite = new Sprite();

        //弾管理
        public var m_BulletTimer:Number = 0;
        public var m_BulletIter:int = 0;
        public var m_BulletInterval:Number = 1.0;

        //スコア
        public var m_Score:int = 0;

        //ミス
        public var m_MissCount:int = 0;
        public var m_MissGraphic:Vector.<Sprite> = new Vector.<Sprite>(MISS_END_NUM);

        //テキスト
        public var m_Text_Score:TextField = new TextField();
        public var m_Text_GameOver:TextField = new TextField();

        //==Function==

        //Init
        public function GameMain() {
            var i:int;
            var g:Graphics;

            //Pseudo Singleton
            {
                Instance = this;
            }

            //Static Init
            {
                ScoreWindowLoader.init(this, new WonderflAPI(loaderInfo.parameters));
            }

            //Layer
            {
                //Root
                addChild(m_Layer_Root);

                {
                    //背景
                    m_Layer_Root.addChild(m_Layer_BG);

                    //弾
                    m_Layer_Root.addChild(m_Layer_Bullet);

                    //エフェクト
                    m_Layer_Root.addChild(m_Layer_Effect);
                }
            }

            //背景
            {
                m_Layer_BG.addChild(new Bitmap(new BitmapData(VIEW_W, VIEW_H, false, 0x000000)));
            }

            //プレイヤー的なもの
            {
                var player:Sprite = new Sprite();

                player.x = VIEW_W/2;
                player.y = VIEW_H/2;

                g = player.graphics;
                g.lineStyle(1.5*Bullet.CIRCLE_W, Bullet.COLOR, 1.0);
                g.drawCircle(0,0, Bullet.RAD);
                player.filters = [new GlowFilter(Bullet.SOUSAI_COLOR,1.0, Bullet.GLOW_W,Bullet.GLOW_W)];

                m_Layer_BG.addChild(player);
            }

            //
            {
                var s:Sprite;
                for(i = 0; i < MISS_END_NUM; i++){
                    s = new Sprite();

                    s.x = 8 + (MISS_WIDTH + MISS_LINE_W*2) * i;
                    s.y = 0;

                    g = s.graphics;
                    g.lineStyle(MISS_LINE_W, 0x444444, 1.0);
                    g.moveTo(MISS_LINE_W, MISS_LINE_W);
                    g.lineTo(MISS_LINE_W + MISS_WIDTH, MISS_LINE_W + MISS_WIDTH);
                    g.moveTo(MISS_LINE_W + MISS_WIDTH, MISS_LINE_W);
                    g.lineTo(MISS_LINE_W, MISS_LINE_W + MISS_WIDTH);

                    m_Layer_BG.addChild(s);

                    m_MissGraphic[i] = s;
                }
            }


            //Text
            {
                m_Text_Score.selectable = false;
                m_Text_Score.autoSize = TextFieldAutoSize.RIGHT;
                m_Text_Score.defaultTextFormat = new TextFormat('Verdana', 16, 0xFFFFFF, true);
                m_Text_Score.text = '0';
                m_Text_Score.filters = [new GlowFilter(0x00FFFF,1.0, 4,4)];

                m_Text_Score.x = VIEW_W - 32;
                m_Text_Score.y = 0;

                addChild(m_Text_Score);
            }
            {
                m_Text_GameOver.selectable = false;
                m_Text_GameOver.autoSize = TextFieldAutoSize.LEFT;
                m_Text_GameOver.defaultTextFormat = new TextFormat('Verdana', 60, 0xFFFF00, true);
                m_Text_GameOver.text = '';
                m_Text_GameOver.filters = [new GlowFilter(0xFF0000,1.0, 8,8)];

                addChild(m_Text_GameOver);
            }

            //Key
            {
                //キー入力を見る
                stage.addEventListener(KeyboardEvent.KEY_DOWN, OnKeyDown);
                stage.addEventListener(KeyboardEvent.KEY_UP, OnKeyUp);
            }

            //Update
            {
                addEventListener(Event.ENTER_FRAME, Update);
            }
        }

        //Update
        public function Update(e:Event=null):void{
            var DeltaTime:Number = 1.0 / stage.frameRate;

            //弾
            Update_Bullet(DeltaTime);

            //エフェクト
            Update_Effect(DeltaTime);
        }

        //Update : Bullet
        public function Update_Bullet(in_DeltaTime:Number):void{
            var i:int;
            var num:int;

            var bullet:Bullet;

            //Check
            if(MISS_END_NUM <= m_MissCount){
                return;
            }

            //生成
            {
                //画面端だと画像の一部がいきなり表示されるので、もう少し外に表示するためのオフセット
                const Offset:int = 32;

                m_BulletTimer += in_DeltaTime;

                num = BULLET_DATA.length;

                for(;;){
                    bullet = null;
                    if(m_BulletIter < num){
                        //指定されたデータがある
                        var BulletData:Object = BULLET_DATA[m_BulletIter];
                        var t:Number = BulletData.Time;

                        if(t <= m_BulletTimer){
                            m_BulletTimer -= t;
                            ++m_BulletIter;

                            var Dir:int = BulletData.Dir;
                            if(Dir < 0){Dir = DIR_NUM * Math.random();}
                            var SrcX:int = -Offset + (VIEW_W + 2*Offset) * BulletData.RatioX;
                            var SrcY:int = -Offset + (VIEW_H + 2*Offset) * BulletData.RatioY;

                            bullet = new Bullet(Dir, SrcX, SrcY, BulletData.MoveTime);
                            //- 厳密にはbulletのローカルタイマーがズレてるので、m_BulletTimer-in_DeltaTimeでUpdateすべきだが
                        }
                    }else{
                        //指定されたデータがなければランダム
//                        const Interval:Number = 0.1;
                        const IntervaRatio:Number = 0.95;
                        const IntervalMin:Number = 0.1;
                        const MoveTime:Number = 2.0;

                        if(m_BulletInterval <= m_BulletTimer){
                            m_BulletTimer -= m_BulletInterval;
                            m_BulletInterval *= IntervaRatio;
                            if(m_BulletInterval < IntervalMin){m_BulletInterval = IntervalMin;}

                            switch((int)(4 * Math.random())){
                            case 0:
                                bullet = new Bullet(DIR_NUM * Math.random(), VIEW_W * Math.random(), -Offset, MoveTime);
                                break;
                            case 1:
                                bullet = new Bullet(DIR_NUM * Math.random(), VIEW_W * Math.random(),  VIEW_H+Offset, MoveTime);
                                break;
                            case 2:
                                bullet = new Bullet(DIR_NUM * Math.random(), -Offset, VIEW_H * Math.random(), MoveTime);
                                break;
                            case 3:
                                bullet = new Bullet(DIR_NUM * Math.random(), VIEW_W+Offset, VIEW_H * Math.random(), MoveTime);
                                break;
                            }
                        }
                    }

                    if(bullet != null){
                        m_Layer_Bullet.addChild(bullet);
                    }else{
                        break;
                    }
                }
            }

            //更新
            {
                num = m_Layer_Bullet.numChildren;
                for(i = 0; i < num; i++){
                    bullet = m_Layer_Bullet.getChildAt(i) as Bullet;

                    //更新
                    bullet.Update(in_DeltaTime);

                    //消失チェック
                    if(bullet.parent == null){//登録が解除された
                        num -= 1;//更新
                        i--;//相殺
                        continue;
                    }
                }
            }
        }


        //Update : Effect
        public function Update_Effect(in_DeltaTime:Number):void{
            var i:int;
            var num:int;

            var effect:Effect;

            //更新
            {
                num = m_Layer_Effect.numChildren;
                for(i = 0; i < num; i++){
                    effect = m_Layer_Effect.getChildAt(i) as Effect;

                    //更新
                    effect.Update(in_DeltaTime);

                    //消失チェック
                    if(effect.parent == null){//登録が解除された
                        num -= 1;//更新
                        i--;//相殺
                        continue;
                    }
                }
            }
        }

        //Update : Input
        private var m_PressFlag:uint = 0;
        private function OnKeyDown(event:KeyboardEvent):void{
            //Check
            if(MISS_END_NUM <= m_MissCount){
                return;
            }

            //対応する方向を求める（なければ負の数）
            var Dir:int = -1;
            {
                switch(event.keyCode){
                case Keyboard.LEFT:  Dir = DIR_L; break;
                case Keyboard.RIGHT: Dir = DIR_R; break;
                case Keyboard.UP:    Dir = DIR_U; break;
                case Keyboard.DOWN:  Dir = DIR_D; break;
                default: return;
                }
            }

            //Releaseされてなければスキップ（押しっぱの連打は無視）
            if((m_PressFlag & (1 << Dir)) != 0){
                return;
            }
            m_PressFlag |= (1 << Dir);

            //該当する弾を見つける
            var num:int = m_Layer_Bullet.numChildren;
            for(var i:int = 0; i < num; i++){
                var bullet:Bullet = m_Layer_Bullet.getChildAt(i) as Bullet;

                //方向が違えばスキップ
                if(bullet.m_Dir != Dir){
                    continue;
                }

                //すでに相殺弾が撃たれていたらスキップ
                if(bullet.IsSousai()){
                    continue;
                }

                //=この弾に決定=

                //相殺処理（Bullet側に任せる）
                bullet.CreateSousai();

                return;
            }

            //該当する弾がないので、失敗として扱いワンミス
            onMiss();
        }
        private function OnKeyUp(event:KeyboardEvent):void{
            //Check
            if(MISS_END_NUM <= m_MissCount){
                return;
            }

            //対応する方向を求める（なければ負の数）
            var Dir:int = -1;
            {
                switch(event.keyCode){
                case Keyboard.LEFT:  Dir = DIR_L; break;
                case Keyboard.RIGHT: Dir = DIR_R; break;
                case Keyboard.UP:    Dir = DIR_U; break;
                case Keyboard.DOWN:  Dir = DIR_D; break;
                default: return;
                }
            }

            m_PressFlag &= ~(1 << Dir);
        }


        public function onMiss():void{
            //ミスエフェクト
            {
                var effect:Effect = new Effect();

                effect.x = VIEW_W/2;
                effect.y = VIEW_H/2;

                m_Layer_Effect.addChild(effect);
            }

            //ミスマーク
            {
                var s:Sprite = m_MissGraphic[m_MissCount];

                var g:Graphics = s.graphics;
                g.lineStyle(MISS_LINE_W, 0xFF4444, 1.0);
                g.moveTo(MISS_LINE_W, MISS_LINE_W);
                g.lineTo(MISS_LINE_W + MISS_WIDTH, MISS_LINE_W + MISS_WIDTH);
                g.moveTo(MISS_LINE_W + MISS_WIDTH, MISS_LINE_W);
                g.lineTo(MISS_LINE_W, MISS_LINE_W + MISS_WIDTH);
            }

            //ミスの数＋１
            {
                ++m_MissCount;
            }

            //ミスの数が規定数を超えたらおしまい
            if(MISS_END_NUM <= m_MissCount){
                //Text
                m_Text_GameOver.text = 'GAME OVER';

                //Centering
                m_Text_GameOver.x = (VIEW_W - m_Text_GameOver.width) / 2;
                m_Text_GameOver.y = (VIEW_H - m_Text_GameOver.height) / 2;

                //スコア表示
                {
                    ScoreWindowLoader.show(m_Score);
                }
            }
        }

        public function onSousai():void{
            ++m_Score;

            m_Text_Score.text = m_Score.toString();
        }

    }
}


import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
import flash.net.*;
import flash.system.*;
import flash.ui.*;
import net.wonderfl.utils.WonderflAPI;


//#Utility
function Lerp(in_Src:Number, in_Dst:Number, in_Ratio:Number):Number{
    return (in_Src * (1.0 - in_Ratio)) + (in_Dst * in_Ratio);
}


//#Bullet
class Bullet extends Sprite
{
    //==Constt==

    //Graphic
    static public const COLOR:uint = 0xFFFFFF;
    static public const RAD:int = 16;
    static public const CIRCLE_W:int = 2;
    static public const LINE_W:int = RAD/4;
    static public const GLOW_COLOR:uint = 0xFF0000;
    static public const GLOW_W:int = 8;
    static public const SOUSAI_COLOR:uint = 0x0080FF;


    //==Var==

    //Dir
    public var m_Dir:int = 0;

    //MovePos
    public var m_SrcX:int = 0;
    public var m_SrcY:int = 0;
    public var m_DstX:int = 0;
    public var m_DstY:int = 0;

    //Local Timer
    public var m_Timer:Number = 0;
    public var m_MoveTime:Number = 0;
    public var m_SousaiTimer:Number = 0;

    //Sprite
    public var m_BulletSprite:Sprite;
    public var m_SousaiSprite:Sprite;


    //==Function==

    //Init
    public function Bullet(in_Dir:int, in_X:int, in_Y:int, in_MoveTime:Number){
        //Param
        {
            m_SrcX = in_X;
            m_SrcY = in_Y;

            m_DstX = GameMain.VIEW_W/2;
            m_DstY = GameMain.VIEW_H/2;

            var GapX:Number = m_DstX - m_SrcX;
            var GapY:Number = m_DstY - m_SrcY;
            var Distance:Number = Math.sqrt(GapX*GapX + GapY*GapY);
//            var Vel:Number = GameMain.VIEW_W / 2;//１秒で何ドット進むか
            //var Vel:Number = GameMain.VIEW_W / 4;//１秒で何ドット進むか
            //m_MoveTime = Distance / Vel;
            m_MoveTime = in_MoveTime;

            m_SousaiTimer = m_MoveTime;

            m_Dir = in_Dir;
        }

        //Graphic
        {
            m_BulletSprite = CreateGraphic(in_Dir, true);
            addChild(m_BulletSprite);
        }
    }

    static public function CreateGraphic(in_Dir:int, in_IsBullet:Boolean):Sprite{
        var sprite:Sprite = new Sprite();

        var g:Graphics = sprite.graphics;

        //Circle
        g.lineStyle(CIRCLE_W, COLOR, 1.0);
        g.drawCircle(0,0, RAD);

        //Arrow
        var theta:Number = Math.PI/2 * in_Dir;
        var r:Number = 0.7 * RAD;
        var SrcX:int = r *  Math.sin(theta);
        var SrcY:int = r * -Math.cos(theta);
        g.lineStyle(LINE_W, COLOR, 1.0);
        g.moveTo(SrcX, SrcY);
        g.lineTo(-SrcX, -SrcY);
        g.moveTo(SrcX, SrcY);
        g.lineTo( SrcY, -SrcX);
        g.moveTo(SrcX, SrcY);
        g.lineTo(-SrcY,  SrcX);

        //Filter
        var color:uint = in_IsBullet? GLOW_COLOR: SOUSAI_COLOR;
        sprite.filters = [new GlowFilter(color,1.0, GLOW_W,GLOW_W)];

        return sprite;
    }

    //Update
    public function Update(in_DeltaTime:Number):void{
        var Ratio:Number;

        //Timer
        if(m_Timer < m_SousaiTimer)
        {
            m_Timer += in_DeltaTime;

            if(IsSousai()){
                const VelRatio:Number = 2.0;//通常の弾の倍速で動く
                m_SousaiTimer -= VelRatio * in_DeltaTime;
            }
        }

        //Check End
        {
            if(m_SousaiTimer <= m_Timer){
                if(! IsSousai()){
                    //プレイヤーに当たったのでワンミス
                    GameMain.Instance.onMiss();

                    //Kill
                    parent.removeChild(this);//描画登録の解除で実現
                }else{
                    //相殺時はすぐには消えない
                    if(m_BulletSprite != null){
                        //元の弾の画像は消す
                        removeChild(m_BulletSprite);
                        m_BulletSprite = null;

                        //相殺弾をエフェクト代わりに使う
                        m_SousaiSprite.filters = [new GlowFilter(0xFFFFFF,1.0, GLOW_W,GLOW_W)];

                        //タイマーを互いの中間位置で固定（位置固定）
                        m_Timer = (m_Timer + m_SousaiTimer)/2;
                        m_SousaiTimer = m_Timer;
                    }

                    const ScaleVel:Number = 5.0;
                    const ScaleThr:Number = 2.0;
                    var scl:Number = m_SousaiSprite.scaleX + ScaleVel * in_DeltaTime;
                    if(ScaleThr < scl){scl = ScaleThr;}
                    m_SousaiSprite.scaleX = m_SousaiSprite.scaleY = scl;
                    m_SousaiSprite.alpha = (ScaleThr - scl) / (ScaleThr - 1);

                    if(m_SousaiSprite.alpha <= 0){
                        //スコア＋＋
                        GameMain.Instance.onSousai();

                        //Kill
                        parent.removeChild(this);//描画登録の解除で実現
                    }
                }

                return;
            }
        }

        //Move
        if(m_BulletSprite != null)
        {
            Ratio = m_Timer / m_MoveTime;
            m_BulletSprite.x = Lerp(m_SrcX, m_DstX, Ratio);
            m_BulletSprite.y = Lerp(m_SrcY, m_DstY, Ratio);
        }

        //Move:Sousai
        if(m_SousaiSprite != null)
        {
            Ratio = m_SousaiTimer / m_MoveTime;
            m_SousaiSprite.x = Lerp(m_SrcX, m_DstX, Ratio);
            m_SousaiSprite.y = Lerp(m_SrcY, m_DstY, Ratio);
        }
    }

    //Sousai
    public function IsSousai():Boolean{
        return (m_SousaiSprite != null);
    }

    public function CreateSousai():void{
        //すでに作られてたら何もしない
        if(IsSousai()){
            return;
        }

        //相殺弾の画像を生成
        m_SousaiSprite = CreateGraphic(m_Dir, false);
        m_SousaiSprite.x = m_DstX;
        m_SousaiSprite.y = m_DstY;
        addChild(m_SousaiSprite);
    }
}


//#Effect
class Effect extends Sprite
{
    //==Const==

    static public const LINE_W:int = 3;
    static public const RAD:int = 16;


    //==Function==

    //Init
    public function Effect(){
        //Graphic
        {
            var sprite:Sprite = new Sprite();

            var g:Graphics = sprite.graphics;

            //円
            g.lineStyle(LINE_W, 0xFFDD00, 1.0);
            g.drawCircle(0, 0, RAD);

            //×
            const cos:Number = 0.707;
            g.moveTo( RAD * cos,  RAD * cos);
            g.lineTo(-RAD * cos, -RAD * cos);
            g.moveTo(-RAD * cos,  RAD * cos);
            g.lineTo( RAD * cos, -RAD * cos);

            addChild(sprite);

            this.filters = [new GlowFilter(0xFF0000,1.0, 8,8)];
        }
    }

    //Update
    public function Update(in_DeltaTime:Number):void{
        const ScaleVel:Number = 5.0;
        const ScaleThr:Number = 4.0;

        var scl:Number = this.scaleX + ScaleVel * in_DeltaTime;
        this.scaleX = this.scaleY = scl;

        this.alpha = (ScaleThr - scl) / (ScaleThr - 1);

        if(this.alpha <= 0){
            //Kill
            parent.removeChild(this);//描画登録の解除で実現
        }
    }
}





//bkzenさんのコードを利用
//@see http://wonderfl.net/c/cuY4
//@see http://wonderfl.net/c/kYyY
class ScoreWindowLoader
{
    private static var _top: DisplayObjectContainer;
    private static var _api: WonderflAPI;
    private static var _content: Object;
    //private static const URL: String = "wonderflScore.swf";
    private static const URL: String = "http://swf.wonderfl.net/swf/usercode/5/57/579a/579a46e1306b5770d429a3738349291f05fec4f3.swf";
    private static const TWEET: String = "Playing Same Direction [score: %SCORE%] #wonderfl";
    
    public static function init(top: DisplayObjectContainer, api: WonderflAPI): void 
    {
        _top = top, _api = api;
        var loader: Loader = new Loader();
        var comp: Function = function(e: Event): void
        {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, comp);
            _content = loader.content;
//            handler();
        }
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, comp);
        loader.load(new URLRequest(URL), new LoaderContext(true));
    }
    
    /**
     * Wonderfl の Score API 用
     * ランキング表示から Tweet までをひとまとめにしたSWF素材を使う
     * @param    score            : 取得スコア
     * @param    closeHandler    : Window が閉じるイベントハンドら
     */
    public static function show( score: int): void
    {
        var window: DisplayObject = _content.makeScoreWindow(_api, score, "Same Direction", 1, TWEET);
//        var close: Function = function(e: Event): void
//        {
//            window.removeEventListener(Event.CLOSE, close);
//            closeHandler();
//        }
//        window.addEventListener(Event.CLOSE, close);
        _top.addChild(window);
    }
    
}
