/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oCYg
 */

/*
 * ■電通（単体）月次売上高推移（単位：百万円）
 * http://www.dentsu.co.jp/ir/zaimu/uriage.html
 * 
 * 
 * ↓の内容を取得して、グラフを描く。
 * https://spreadsheets.google.com/pub?key=0Akpu7nsnVtwIdHhKd3l5VmFHRjJBd0Y1RHFyYlpldXc&hl=ja&output=html
 *
*/
package
{
    import com.bit101.components.*;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFormat;

    /**
     * ...
     * @author umhr
     */
    [SWF(backgroundColor = 0xF5F5F5)]
    public class Main extends Sprite
    {
        private var _inputText:Text;
        private var _loadRSSButton:PushButton;
        private var _cb3:CheckBox;
        private var _cb4:CheckBox;
        private var _cb5:CheckBox;
        private var _cb6:CheckBox;
        private var _cb7:CheckBox;
        private var _cb8:CheckBox;
        private var _cb9:CheckBox;
        private var _cb10:CheckBox;
        private var _graph:Sprite;
        private var suii:Array;
        private var maxObj:Object;
        public function Main():void
        {
            stage.scaleMode = "noScale";
            stage.align = "TL";
            _inputText = new Text(this, 0, 0, "http://spreadsheets.google.com/feeds/cells/0Akpu7nsnVtwIdHhKd3l5VmFHRjJBd0Y1RHFyYlpldXc/od6/public/basic?alt=rss");
            _inputText.width = stage.stageWidth;
            _inputText.height = 36;
            _loadRSSButton = new PushButton(this, 0, 36, "Load GoogleDocs rss", doLoadRSS);
            doLoadRSS(null);
        }
        public function doLoadRSS(event:Event):void {
            this.removeChild(_loadRSSButton);
            var myURLLoader:URLLoader = new URLLoader();
            myURLLoader.addEventListener (Event.COMPLETE, onCompRSS);
            //YahooPipesの汎用feedProxy
            var xmlURL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=f4f6c98189a88373b9bfd4fe6128c018&_render=rss&url=";
            //encodeURIComponentでエスケープして、feedProxyにくっつける。
            xmlURL += encodeURIComponent(_inputText.text + "&rand="+Math.random()+5);
            myURLLoader.load(new URLRequest(xmlURL));
        }
        private function onCompRSS(event:Event):void {
            //trace(event.target.data);
            _inputText.visible = false;
            var xml:XML = new XML(event.target.data);
            var data:Data = new Data();
            var obj:Object = { };
            var maxLine:int = 0;
            var maxColumn:int = 0;
            var n:int = xml.channel.item.length();
            for (var i:int = 0; i < n; i++) {
                var title:String = String(xml.channel.item[i].title);
                var lineNum:Number = Number(title.replace(/[A-Z]/g,""))-1;
                var columnNum:Number = title.replace(/[0-9]/g,"").charCodeAt() - 65;
                maxLine = (maxLine < lineNum)?lineNum:maxLine;
                maxColumn = (maxColumn < columnNum)?columnNum:maxColumn;
                obj[lineNum + "_" + columnNum] = xml.channel.item[i].description;
            }
            for (i = 0; i < (maxLine+0); i++) {
                for (var j:int = 0; j < (maxColumn + 0); j++) {
                    data.setData(obj[i + "_" + j]?obj[i + "_" + j]:"", i, j);
                }
            }
            
            n = Math.ceil(maxLine / 12);
            suii = [];
            maxObj = { };
            maxObj["新聞"] = 0;
            maxObj["雑誌"] = 0;
            maxObj["ラジオ"] = 0;
            maxObj["テレビ"] = 0;
            maxObj["インタラクティブメディア"] = 0;
            maxObj["OOHメディア"] = 0;
            maxObj["クリエーティブ"] = 0;
            maxObj["マーケティング／プロモーション"] = 0;
            var kubun:Object = { };
            for (i = 0; i < n; i++) {
                var k:int = n - i - 1;
                
                for (j = 1; j < maxColumn; j++) {
                    
                    var object:Object = { };
                    object["業務区分"] = data.getData(k * 12 + 1, j).replace(/\/0/g,'/');
                    object["合計"] = data.getData(k * 12 + 2, j);
                    if (object["合計"]) {
                        object["新聞"] = Number(data.getData(k * 12 + 3, j));
                        object["雑誌"] = Number(data.getData(k * 12 + 4, j));
                        object["ラジオ"] = Number(data.getData(k * 12 + 5, j));
                        object["テレビ"] = Number(data.getData(k * 12 + 6, j));
                        object["インタラクティブメディア"] = Number(data.getData(k * 12 + 7, j));
                        object["OOHメディア"] = Number(data.getData(k * 12 + 8, j));
                        object["クリエーティブ"] = Number(data.getData(k * 12 + 9, j));
                        object["マーケティング／プロモーション"] = Number(data.getData(k * 12 + 10, j));
                        suii.push(object);
                        maxObj["新聞"] = Math.max(object["新聞"], maxObj["新聞"]);
                        maxObj["雑誌"] = Math.max(object["雑誌"], maxObj["雑誌"]);
                        maxObj["ラジオ"] = Math.max(object["ラジオ"], maxObj["ラジオ"]);
                        maxObj["テレビ"] = Math.max(object["テレビ"], maxObj["テレビ"]);
                        maxObj["インタラクティブメディア"] = Math.max(object["インタラクティブメディア"], maxObj["インタラクティブメディア"]);
                        maxObj["OOHメディア"] = Math.max(object["OOHメディア"], maxObj["OOHメディア"]);
                        maxObj["クリエーティブ"] = Math.max(object["クリエーティブ"], maxObj["クリエーティブ"]);
                        maxObj["マーケティング／プロモーション"] = Math.max(object["マーケティング／プロモーション"], maxObj["マーケティング／プロモーション"]);
                    }
                }
            }
            
            
            var stageWidth:int = stage.stageWidth - 40;
            var stageHeight:int = stage.stageHeight - 40;
            _graph = new Sprite();
            _graph.graphics.beginFill(0xFFFFFF);
            _graph.graphics.drawRect(0, 0, stageWidth, stageHeight);
            _graph.graphics.endFill();
            _graph.x = 32;
            _graph.y = 24;
            this.addChild(_graph);
            
            
            Style.embedFonts = false;
            Style.fontName = "_sans";
            Style.fontSize = 9;
            _cb3 = new CheckBox(this, 2, 4, "新聞" , checked);
            _cb3.selected = false;
            _cb4 = new CheckBox(this, 40, 4, "雑誌" ,checked);
            _cb4.selected = true;
            _cb5 = new CheckBox(this, 78, 4, "ラジオ" ,checked);
            _cb5.selected = true;
            _cb6 = new CheckBox(this, 120, 4, "テレビ" ,checked);
            _cb6.selected = false;
            _cb7 = new CheckBox(this, 160, 4, "インタラクティブメディア" ,checked);
            _cb7.selected = true;
            _cb8 = new CheckBox(this, 270, 4, "OOHメディア" ,checked);
            _cb8.selected = true;
            _cb9 = new CheckBox(this, 340, 4, "クリエーティブ" ,checked);
            _cb9.selected = false;
            _cb10 = new CheckBox(this, 410, 4, "マーケティング／プロモーション" ,checked);
            _cb10.selected = false;
            
            var colorBG:Sprite = new Sprite();
            colorBG.graphics.beginFill(0xFF9999);
            colorBG.graphics.drawRect(0, 14, 38, 1);
            colorBG.graphics.beginFill(0x339933);
            colorBG.graphics.drawRect(38, 14, 38, 1);
            colorBG.graphics.beginFill(0x9999FF);
            colorBG.graphics.drawRect(76, 14, 42, 1);
            colorBG.graphics.beginFill(0xFF9900);
            colorBG.graphics.drawRect(118, 14, 40, 1);
            
            colorBG.graphics.beginFill(0xFF0000);
            colorBG.graphics.drawRect(158, 14, 110, 1);
            colorBG.graphics.beginFill(0x00FFFF);
            colorBG.graphics.drawRect(268, 14, 70, 1);
            colorBG.graphics.beginFill(0xFF00FF);
            colorBG.graphics.drawRect(338, 14, 70, 1);
            colorBG.graphics.beginFill(0x999999);
            colorBG.graphics.drawRect(408, 14, 120, 1);
            this.addChildAt(colorBG,0);
            
            checked(null);
        }
        private function checked(event:Event):void {
            draw();
        }
        
        private function draw():void {
            while (_graph.numChildren > 0) {
                _graph.removeChildAt(0);
            }
            
            var stageWidth:int = stage.stageWidth - 40;
            var stageHeight:int = stage.stageHeight - 40;
            _graph.width = stageWidth;
            
            var maxNum:Number =  Math.max(1000);
            if (_cb3.selected) {
                maxNum = Math.max(maxNum, maxObj["新聞"]);
            }
            if (_cb4.selected) {
                maxNum = Math.max(maxNum, maxObj["雑誌"]);
            }
            if (_cb5.selected) {
                maxNum = Math.max(maxNum, maxObj["ラジオ"]);
            }
            if (_cb6.selected) {
                maxNum = Math.max(maxNum, maxObj["テレビ"]);
            }
            if (_cb7.selected) {
                maxNum = Math.max(maxNum, maxObj["インタラクティブメディア"]);
            }
            if (_cb8.selected) {
                maxNum = Math.max(maxNum, maxObj["OOHメディア"]);
            }
            if (_cb9.selected) {
                maxNum = Math.max(maxNum, maxObj["クリエーティブ"]);
            }
            if (_cb10.selected) {
                maxNum = Math.max(maxNum, maxObj["マーケティング／プロモーション"]);
            }
            
            
            var maxInt:int = Math.ceil(maxNum / 1000);
            var n:int = suii.length;
            var w:Number = (stageWidth / n);
            
            if (_cb3.selected) {
                var line3:Sprite = getLine(0xFF9999, "新聞");
                _graph.addChild(line3);
            }
            if (_cb4.selected) {
                var line4:Sprite = getLine(0x339933, "雑誌");
                _graph.addChild(line4);
            }
            if (_cb5.selected) {
                var line5:Sprite = getLine(0x9999FF, "ラジオ");
                _graph.addChild(line5);
            }
            if (_cb6.selected) {
                var line6:Sprite = getLine(0xFF9900, "テレビ");
                _graph.addChild(line6);
            }
            if (_cb8.selected) {
                var line8:Sprite = getLine(0x00FFFF, "OOHメディア");
                _graph.addChild(line8);
            }
            if (_cb9.selected) {
                var line9:Sprite = getLine(0xFF00FF, "クリエーティブ");
                _graph.addChild(line9);
            }
            if (_cb10.selected) {
                var line10:Sprite = getLine(0x999999, "マーケティング／プロモーション");
                _graph.addChild(line10);
            }
            if (_cb7.selected) {
                var line7:Sprite = getLine(0xFF0000, "インタラクティブメディア");
                _graph.addChild(line7);
            }
            
            function getLine(color:int,str:String):Sprite {
                var line:Sprite = new Sprite();
                line.graphics.lineStyle(0, color);
                line.graphics.moveTo(0, stageHeight * (1 - suii[0][str] / (maxInt*1000)));
                for (var i:int = 0; i < n; i++) {
                    line.graphics.lineTo(i * w, stageHeight * (1 - suii[i][str] / (maxInt * 1000)));
                }
                return line;
            }
            
            var baseLine:Sprite = new Sprite();
            n = Math.ceil(n / 6);
            baseLine.graphics.lineStyle(1,0xDDDDDD);
            for (var i:int = 0; i < n; i++) {
                if (i > 0) {
                    baseLine.graphics.moveTo((i) * w * 6, 0);
                    baseLine.graphics.lineTo((i) * w * 6, stageHeight);
                }
                if (i % 2 == 1) { continue };
                var tf:TextField = new TextField();
                tf.text = suii[i*6]["業務区分"].substr(2);
                tf.setTextFormat(new TextFormat("_sans", 10, 0x999999));
                tf.selectable = false;
                tf.autoSize = "center";
                tf.x = i * w * 6 - tf.width / 2;
                tf.y = stageHeight;
                _graph.addChild(tf);
            }
            
            baseLine.graphics.lineStyle(1,0xEEEEEE);
            for (i = 0; i < maxInt; i++) {
                baseLine.graphics.moveTo(0, (stageHeight*i)/maxInt);
                baseLine.graphics.lineTo(stageWidth, (stageHeight*i)/maxInt);
                var tfN:TextField = new TextField();
                tfN.text = String((maxInt - i) * 1000);
                tfN.setTextFormat(new TextFormat("_sans", 10, 0x999999));
                tfN.selectable = false;
                tfN.autoSize = "right";
                tfN.x = -tfN.width;
                tfN.y = (stageHeight * i) / maxInt - tfN.height / 2;
                _graph.addChild(tfN);
            }
            baseLine.graphics.lineStyle(1,0x000000);
            baseLine.graphics.moveTo(0, 0);
            baseLine.graphics.lineTo(0, stageHeight);
            baseLine.graphics.lineTo(stageWidth, stageHeight);
            _graph.addChildAt(baseLine,0);
            
        }
    }
}
//https://spreadsheets.google.com/ccc?key=0Akpu7nsnVtwIdHhKd3l5VmFHRjJBd0Y1RHFyYlpldXc&hl=ja#gid=0

//データを管理するためのクラス
class Data {
    private var _obj:Object;
    private var _array:Array;
    //ともかく入れた数
    private var _trLength:int;
    private var _tdLength:int;

    private var _charge:String;
    private var _team:String;
    public function Data() {
        _obj = { };
        _trLength = 0;
    }
    public function setData(str:String, trNum:int, tdNum:int):void {
        _trLength = (_trLength < trNum)?trNum:_trLength;
        _tdLength = (_tdLength < tdNum)?tdNum:_tdLength;

        if (tdNum == 0) {
            if (str == "") {
                str = _team;
            }else{
                _team = str;
            }
        }else if (tdNum == 1) {
            if (str == "") {
                str = _charge;
            }else{
                _charge = str;
            }
        }

        _obj[String(trNum + "_" + tdNum)] = str;
    }
    public function getData(trNum:int, tdNum:int):String {
        return _obj[String(trNum + "_" + tdNum)];
    }
    public function get trLength():int {
        return _trLength;
    }
    public function get tdLength():int {
        return _tdLength;
    }
    public function getTr(trNum:int):Array {
        var array:Array = [];
        for (var i:int = 0; i < _tdLength; i++) {
            array[i] = _obj[String(trNum + "_" + i)]
        }
        return array;
    }
    //有効設定数
    public function get validLength():int {
        if(!_array){
            _array = [];
            for (var i:int = 0; i < _trLength; i++) {
                var array:Array = getTr(i);
                if (array[3] || array[4]) {
                    _array.push(array);
                }
            }
        }
        return _array.length;
    }
    public function getValidData(num:int):Array {
        if(!_array){
            validLength;
        }
        return _array[num];
    }

}

//fileの読み込み
import flash.display.Loader;
import flash.events.Event;
import flash.net.FileReference;
import flash.system.LoaderContext;
class LoadFile{
    private var _fileReference:FileReference;
    public var atComplete:Function = function(event:Event):void{};
    /**
     * 開始
     *
     */
    public function start():void
    {
        if(_fileReference){
            return;
        }
        _fileReference = new FileReference();
        _fileReference.browse();
        _fileReference.addEventListener(Event.SELECT,atSelect);
    }
    /**
     * ファイルの選択が完了すると動く
     * @param event
     *
     */
    private function atSelect(event:Event):void {
        _fileReference.removeEventListener(Event.SELECT,atSelect);
        _fileReference.addEventListener(Event.COMPLETE, atFileComplete);
        _fileReference.load();
    }
    /**
     * 選択したファイルを読み込み完了すると動く
     * @param event
     *
     */
    private function atFileComplete(event:Event):void{
        _fileReference.removeEventListener(Event.COMPLETE, atFileComplete);
        //trace(_fileReference.type)
        if (_fileReference.type == ".xhtml") {
            atComplete(event);
            return;
        }
        var loader:Loader = new Loader();
        loader.loadBytes(event.target.data, new LoaderContext());
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, atBytesComplete);
    }
    /**
     * 読み込んだファイルのバイトアレイを変換完了で動く
     * @param event
     *
     */
    private function atBytesComplete(event:Event):void{
        event.target.removeEventListener(Event.COMPLETE,atBytesComplete);
        atComplete(event);
    }
}
