/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oCRa
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;

    import jp.progression.commands.*;
    import jp.progression.commands.display.*;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.tweens.*;
    import jp.progression.events.ExecuteEvent;
    import com.flashdynamix.utils.SWFProfiler;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]

    public class Main extends Sprite
    {
        private var _messages:Array;
        private var _txt:TextField;
        private var _sp:Sprite;
        private var _bm:Bitmap;
        private var _exe:CommandList;

        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            //  setup stage.
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.HIGH;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            //  setup debugger.
            SWFProfiler.init(this);

            _txt = new TextField();
            _txt.defaultTextFormat = new TextFormat("Arial", 96);
            _txt.autoSize = TextFieldAutoSize.LEFT;

            _bm = new Bitmap();
            _bm.smoothing = true;
            _bm.filters = [
                new BlurFilter(4, 4, BitmapFilterQuality.MEDIUM),
            ];

            _sp = new Sprite();
            _sp.addChild(_bm);
            _sp.x = stage.stageWidth >> 1;
            _sp.y = stage.stageHeight >> 1;
            _sp.blendMode = BlendMode.INVERT;

            addChild(_sp);

            var i:uint, l:uint;

            l = MESSAGES.length;

            _exe = new LoopList();
            _exe.addCommand(
                new Func(splitMessages)
            );
            for (i=0; i<l; i++)
            {
                _exe.addCommand(
                    new Func(setNextChar),
                    new Prop(_sp, {
                        scaleX: 5,
                        scaleY: 5,
                        alpha: 1,
                        rotation: 0
                    }),
                    new DoTweener(_sp, {
                        scaleX: 0,
                        scaleY: 0,
                        alpha: 0,
                        //rotation: Math.random() * 360 - 180,
                        time: .1,
                        transition: "easeOutSine"
                    })
                );
            }
            _exe.execute();
        }

        private function splitMessages():void
        {
            _messages = MESSAGES.split("");
        }

        private function setNextChar():void
        {
            var d:BitmapData;

            _txt.text = _messages.shift();

            d = new BitmapData(_txt.width, _txt.height, true, 0);
            d.draw(_txt);

            _bm.bitmapData = d;
            _bm.x = int(0 - _bm.width / 2);
            _bm.y = int(0 - _bm.height / 2);
        }

        private static const MESSAGES:String = "にうむさん　おたんじょうび　おめでとーございまーす！　おないどし　おないどし　またあぶりしめさば　くいにいこう！ ";
    }
}
