/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oCA5
 */

// forked from tkinjo's RingParticle
// forked from tkinjo's リングクラス
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * RingParticle
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private const MIN_INTERVAL:Number = 0;
        private const MAX_INTERVAL:Number = 1000;
        
        private const RING_RADIUS:Number = 100;
        private const RING_INNER_RADIUS:Number = 80;
        
        private var ringParticles:RingParticle;
        private var lastRingParticle:RingParticle;
        private var ringFactoryTimer:Timer;
        
        public function Main() 
        {
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            ringParticles = new RingParticle( 0 );
            lastRingParticle = ringParticles;
            
            ringFactoryTimer = new Timer( 0 );
            ringFactoryTimer.addEventListener(TimerEvent.TIMER, ringFactoryTimerEventHandler);
            ringFactoryTimer.start();
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            var previousRingParticle:RingParticle = ringParticles;
            var ringParticle:RingParticle;
            
            while ( ringParticle = previousRingParticle.next ) {
                
                ringParticle.scaleX = ringParticle.scaleY += 0.01;
                
                if ( ringParticle.fadeIn ) {
                    
                    ringParticle.alpha += 0.02;
                    
                    if ( ringParticle.alpha >= 0.5 ) 
                        ringParticle.fadeIn = false;
                    
                    previousRingParticle = ringParticle;
                    
                } else {
                    
                    ringParticle.alpha -= 0.01;
                    
                    if ( ringParticle.alpha <= 0 ) {
                        
                        removeChild( ringParticle );
                        previousRingParticle.next = ringParticle.next;
                        
                        if ( lastRingParticle == ringParticle )
                            lastRingParticle = previousRingParticle;
                        
                    } else {
                        
                        previousRingParticle = ringParticle;
                    }
                }
            }
        }
        
        private function ringFactoryTimerEventHandler( event:TimerEvent ):void {
            
            var ringParticle:RingParticle = new RingParticle( RING_RADIUS, RING_INNER_RADIUS, 0 );
            ringParticle.alpha = 0;
            ringParticle.x = Math.random() * stage.stageWidth;
            ringParticle.y = Math.random() * stage.stageHeight;
            addChild( ringParticle );
            
            lastRingParticle.next = ringParticle;
            lastRingParticle = ringParticle;
            
            ringFactoryTimer.delay = Math.random() * ( MAX_INTERVAL - MIN_INTERVAL );
        }
    }
    
}

import flash.display.*;

internal class RingParticle extends Sprite {
    
    public var fadeIn:Boolean = true;
    
    private var _ring:Ring;
    public function get ring():Ring {
        return _ring;
    }
    
    public var next:RingParticle;
    
    public function RingParticle( radius:Number, innerRadius:Number = 0, color:Number = 0 ):void {
        
        _ring = new Ring( radius, innerRadius, color );
        ring.x = -radius;
        ring.y = -radius;
        addChild( ring );
    }
}

internal class Ring extends Sprite {
    
    public function get radius():Number { return _radius; }
    public function set radius(value:Number):void 
    {
        _radius = value;
        draw();
    }
    private var _radius:Number;
    
    
    
    public function get innerRadius():Number { return _innerRadius; }
    public function set innerRadius(value:Number):void 
    {
        _innerRadius = value;
        draw();
    }
    private var _innerRadius:Number;
    
    
    
    public function get color():Number { return _color; }
    public function set color(value:Number):void 
    {
        _color = value;
        draw();
    }
    private var _color:Number;
    
    
    
    public function Ring( radius:Number, innerRadius:Number = 0, color:Number = 0 ) {
        
        _radius = radius;
        _innerRadius = innerRadius;
        _color = color;
        
        draw();
    }
    
    
    
    private function draw():void {
        
        graphics.clear();
        graphics.beginFill( color );
        graphics.drawCircle( radius, radius, radius);
        if ( innerRadius != 0 )
            graphics.drawCircle( radius, radius, innerRadius );
        graphics.endFill();
    }
}