/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oBf5
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.display.Bitmap;
    import flash.display.BitmapData;
	import flash.filters.BlurFilter;
	
	[SWF(width = "500", height = "500", backgroundColor = "0x000000", fps = "30")] 
	public class Practice15 extends Sprite{
		private var item:Vector.<Point>;
		private var bitmap:BitmapData;
		private var blur:BlurFilter = new BlurFilter(4, 4, 6);
		private var point:Point = new Point();
		private var count:uint;
		private var pointer:Pointer;

		public function Practice15() {
			item = new Vector.<Point>();
			bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
			var img:Bitmap = new Bitmap(bitmap);
			stage.addChild(img);
			pointer = new Pointer();
			pointer.x = 500 * Math.random();
			pointer.y = 500 * Math.random();
			pointer.vx = 3;
			pointer.vy = 2;
			stage.addEventListener(Event.ENTER_FRAME,update);
		}
		
		private function update(e:Event):void {
			for (var i:int = 0; i < this.numChildren; i++) {
				var obj:Object = this.getChildAt(i);
				if (obj is Whirlpool) {
					(obj as Whirlpool).update();
				}
			}
			bitmap.lock()
			bitmap.applyFilter(bitmap, bitmap.rect, point, blur)
			bitmap.draw(this);
			bitmap.unlock();
			pointer.update();
			count = (count + 1) % 10;
			if (count== 0) {
				var w:Whirlpool = new Whirlpool(pointer.x, pointer.y);
				this.addChild(w);
			}
		}
	}
}
import flash.display.MovieClip;
import flash.geom.Point;

class Pointer {
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;

	public function update():void {
		x += vx;
		y += vy;
		if (x < 0||x>500) vx *= -1;
		if (y < 0||y>500) vy *= -1;
	}
}

class Whirlpool extends MovieClip {
	private var cx:Number;
	private var cy:Number;
	private var radius:Number;
	private var rad:Number;
	private var list:Vector.<Point>;
	public function Whirlpool(x:Number,y:Number):void {
		cx = x;
		cy = y;
		radius = 60;
		rad = Math.random();
		list = new Vector.<Point>();
	}
	
	public function update():void {
		graphics.clear();
		radius *= 0.99;
		rad += 0.2;
		var px:Number = radius * Math.cos(rad) + cx;
		var py:Number = radius * Math.sin(rad) + cy;
		var len:Number = Math.sqrt(Math.pow(cx - px, 2) + Math.pow(cy - py, 2));
		if (len < 1) {
			this.parent.removeChild(this);
		}else {
			list.push(new Point(px, py));
			for (var i:int = 0; i < list.length; i++) {
				graphics.lineStyle(4,getColor(i/list.length));
				if (i == 0) {
					graphics.moveTo(list[i].x,list[i].y);
				}else {
					graphics.lineTo(list[i].x,list[i].y);
				}
			}
			if (list.length > 100) list.shift();
		}
	}
	
	private function getColor(v:Number):Number {
		var r:Number = Math.cos(Math.PI * ((v - 0.81) * 1.1)) * 255;
		var g:Number = Math.cos(Math.PI * ((v - 0.50) * 1.0)) * 255;
		var b:Number = Math.cos(Math.PI * ((v - 0.19) * 1.1)) * 255;
		r = Math.min(255, r);
		r = Math.max(0, r);
		g = Math.min(255, g);
		g = Math.max(0, g);
		b = Math.min(255, b);
		b = Math.max(0, b);
		return (r<<16)+(g<<8)+b;
	}
	
	
}