/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oBHa
 */






package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.BlendMode;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.display.BitmapDataChannel;
    import flash.filters.DisplacementMapFilter;

    [SWF(width=465,height=465,backgroundColor=0,frameRate=30)]
    public class FlashTest extends Sprite {
        
        private var bmpdata:BitmapData;
        private var sprite:Sprite;
        private var matrix:Matrix;
        public var colortrans:ColorTransform;
        private var bmpcolortrans:ColorTransform;
        public var filter:DisplacementMapFilter;
       
        public function FlashTest() {
            // write as3 code here..

            bmpdata = new BitmapData(465,465,false,0);
            addChild( new Bitmap(bmpdata) );
            
            sprite = newFig(0,0,40,0xFFFFFF);
              
            matrix = new Matrix();
            colortrans = new ColorTransform();  
            bmpcolortrans = new ColorTransform(0.99, 0.99, 0.999);
   
            
            var mapBitmap:BitmapData = new BitmapData(465,465,false,0);
            var mapPoint:Point       = mapBitmap.rect.topLeft;
            var componentX:uint      = BitmapDataChannel.RED;
            var componentY:uint      = BitmapDataChannel.GREEN;
            var scaleX:Number        = 4;
            var scaleY:Number        = 4;
            mapBitmap.perlinNoise(240,240,2,0,false,false);

            filter = new DisplacementMapFilter( mapBitmap, mapPoint,
                            componentX, componentY, scaleX, scaleY );
                          
            addEventListener( Event.ENTER_FRAME, enterframe );
            stage.addEventListener( MouseEvent.CLICK, reset );   
                
        }
        
        private function enterframe(e:Event):void{
            bmpdata.applyFilter( bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
            bmpdata.colorTransform( bmpdata.rect, bmpcolortrans);
            matrix.identity();
            var s:Number = 4;         
            matrix.scale( s, s );
            matrix.rotate( Math.PI*Math.random() );
            matrix.translate( mouseX, mouseY);
            
            colortrans.greenMultiplier = mouseX / 465;
            colortrans.blueMultiplier = mouseY / 465;
            colortrans.alphaMultiplier = Math.random();
            
            bmpdata.draw(sprite, matrix, colortrans, BlendMode.ADD);
        }

        private function reset(e:MouseEvent):void{
            var back:uint = Math.random()*0xFFFFFF;
            var black:uint = 0x000000;
            bmpdata.fillRect( bmpdata.rect, black);
        }

        
        private function newFig(cx:Number,cy:Number,size:Number,col:uint):Sprite{
            var shape:Sprite = new Sprite();
            shape.graphics.lineStyle(0,0x00000,0.3);
            shape.graphics.beginFill( col );
            shape.graphics.drawCircle(cx, cy, size*0.5);
            shape.graphics.drawCircle(cx,cy,size*0.45);
            var w:Number=size*0.6;
            var h:Number=size*0.15;
            //shape.graphics.drawRect( cx - w/2, cy - h/2,w,h);
            shape.graphics.endFill();
            return shape;
        }

        
        
    }
}