/**
 * Copyright aaharu ( http://wonderfl.net/user/aaharu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oAfb
 */

/*
クリックしたところに隕石が降ってきて、クレーターができます。
お月さんかわいそうです(´；ω；`) 
もっと爆発した感じがだせるといいね。
Loaderめんどい・・・

追記
裏側だとクレーター見えないって言われたので改造。
クレーターにはPhongShaderのバンプマッピング使ってたため、
ライトが当たらないといけないのでライトも動かしてみた。
*/
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.net.URLRequest;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.BitmapMaterial;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.shaders.PhongShader;
	import org.papervision3d.materials.shaders.ShadedMaterial;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.objects.special.ParticleField;
	import org.papervision3d.view.BasicView;
    import net.wonderfl.utils.SequentialLoader;
	
	[SWF(backgroundColor=0x000000)]
	public class Meteor extends BasicView {
		private var shader:PhongShader;
		private var light:PointLight3D = new PointLight3D();
		private var bumpBmpData:BitmapData;
		private var moonBmpData:BitmapData;
		private var mouseDownX:Number = 0;
		private var distanceX:Number = 0;
		private var radianX:Number = 0;
		private var rot:Number = 0;
		
		private var imageArray:Array = [];
		/**
		 * constructor
		 */
		public function Meteor() {
			super(640, 480, true, true);
			camera.focus = 15;
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			
			SequentialLoader.loadImages(["http://assets.wonderfl.net/images/related_images/7/75/756d/756d4e45c50bca7ae7647c47568d8553aebd93a4", "http://assets.wonderfl.net/images/related_images/e/e9/e978/e978b55099c8d056d15861de179ca591eb5c157b"], imageArray, onMapComplete);
			//var loader:Loader = new Loader();
			//loader.load(new URLRequest("http://aaharuapp.appspot.com/data/changeBump/moonbump1k.jpg"));
			//loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onBumpComplete);
			startRendering();
		}
		
		private function onMouseDown(e:MouseEvent):void {
			mouseDownX = mouseX;
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		private function onMouseMove(e:MouseEvent):void {
			distanceX = mouseX - mouseDownX;
			radianX += distanceX / 180 * Math.PI;
			mouseDownX = mouseX;
		}
		
		private function onMouseUp(e:MouseEvent):void {
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		/*private function onBumpComplete(e:Event):void {
			var bmpData:BitmapData = new BitmapData(e.target.loader.width, e.target.loader.height);
			bmpData.draw(e.target.loader);
			bumpBmpData = bmpData;
			
			var loader:Loader = new Loader();
			loader.load(new URLRequest("http://aaharuapp.appspot.com/data/changeBump/moonmap1k.jpg"));
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onMapComplete);
		}*/
		
		//private function onMapComplete(e:Event):void {
		private function onMapComplete():void {
			//var bmpData:BitmapData = new BitmapData(e.target.loader.width, e.target.loader.height);
			var loader1:Loader = imageArray.pop();
			var bmpData:BitmapData = new BitmapData(loader1.width, loader1.height);
			bmpData.draw(loader1);
			moonBmpData = bmpData;
			var loader2:Loader = imageArray.pop();
			bmpData = new BitmapData(loader2.width, loader2.height);
			bmpData.draw(loader2);
			bumpBmpData = bmpData;
			scene.addChild(light);
			
			shader = new PhongShader(light, 0xFFFFFF, 0x666666, 0, bumpBmpData);
			var material:ShadedMaterial = new ShadedMaterial(new BitmapMaterial(moonBmpData), shader);
			material.interactive = true;
			material.smooth = true;
			var sphere:Sphere = new Sphere(material, 100, 15, 15);
			sphere.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, onObjectClick);
			scene.addChild(sphere);
			
			var particles:ParticleField = new ParticleField(new ParticleMaterial(0xffffff, 1, 1), 200, 2, 500, 500, 500);
			scene.addChild(particles);
		}
		
		private function onObjectClick(e:InteractiveScene3DEvent):void {
			var ball:Sphere = new Sphere(new ColorMaterial(0xEEEEEE), 10);
			scene.addChild(ball);
			var tween:ITween = BetweenAS3.tween(ball, {x: e.renderHitData.x * 0.9, y: e.renderHitData.y * 0.9, z: e.renderHitData.z * 0.9}, {x: e.renderHitData.x * 3.5, y: e.renderHitData.y * 3.5, z: e.renderHitData.z * 3.5});
			tween.play();
			tween.onComplete = function():void {
				var sp:Sprite = new Sprite();
				sp.graphics.beginFill(0xFFFFFF);
				sp.graphics.drawCircle(25, 25, 20);
				sp.graphics.endFill();
				sp.graphics.beginFill(0x000000);
				sp.graphics.drawCircle(25, 25, 17);
				sp.graphics.endFill();
				var bmpData:BitmapData = new BitmapData(50, 50, true, 0x00000000);
				bmpData.draw(sp);
				bumpBmpData.draw(bmpData, new Matrix(1, 0, 0, 1, e.x * 1000 - 25, e.y * 500 - 25));
				shader.bumpmap = bumpBmpData;
				scene.removeChild(ball);
			}
		}
		
		override protected function onRenderTick(event:Event=null):void {
			rot += (radianX - rot) * 0.3;
			camera.x = light.x = 400 * Math.sin(rot);
			camera.z = light.z = 400 * Math.cos(rot);
			super.onRenderTick(event);
		}
	}
}