/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oAHZ
 */

package  {
	
	/**
	* ...
	* @author 393
	* 道っぽい表現をつくりたかったけど
	* なんだかいまいちな感じ。。。
	* 
	* self ｆork
	* 影で進行方向へのスピード感を出したかったのだけど
	* イマイチ伝わらない。。。
	* 
	* self fork
	* 動きをマウスでインタラクティブに
	* 目標の動きに近づいた感じ
	* 
	* self fork
	* パラメータを設定できるように
	* ビットマップの処理が重いのかな･･･
	* 

	*/	
	import adobe.utils.CustomActions;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.GradientType;
	import flash.display.InterpolationMethod;
	import flash.display.SpreadMethod;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import net.hires.debug.Stats;
  
	[SWF(width = 465, height = 465, backgroundColor = 0x666666, frameRate = 30)]	
	
	/**
	 * ...
	 * ドキュメントクラス
	 * @author 393
	 */
	
	public class Main extends Sprite {
		private var sp:Sprite;
		private var pointArray:Array;
		
		private var mousePoint:MousePoint;
		private var par:Number = 1;
		private var maxPoint:uint = 19;
		private var leftPoint:uint;
		private var ii:Number = 0;
		private var cTra:ColorTransform;
		private var matrix:Matrix;
		private var rect:Rectangle;
		private var bmd:BitmapData;
		private var tfArray:Array;
		
		private var spring:Number = .06;
		private var friction:Number = .8;
		private var gravityX:Number = 2;
		private var gravityY:Number = 2;
		private var eTfArray:Array;
		
		public function Main() {
			
			//stageの初期設定
			stage.quality = StageQuality.MEDIUM;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			//マウスポイント用オブジェクト
			mousePoint = new MousePoint();
			addChild(mousePoint);
			
			cTra = new ColorTransform( 1, 1, .8, 1);
			matrix = new Matrix();
			rect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
			
			//左側のポイント数
			leftPoint = Math.ceil(maxPoint / 2);
			//ポイント格納用配列
			pointArray = [];
			for (var i:Number = 0; i < maxPoint; i++){
				pointArray.push(new CustomPoint(this.stage.stageWidth, this.stage.stageHeight));
			}
			sp = new Sprite();
			addChild(sp);
			sp.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			
			//STATSメモリ管理
			var sprite:Sprite = addChild( new Stats() ) as Sprite;
			
			//コントローラー
			createController();
		}
		
		private function createController():void{
			//
			tfArray = [];
			eTfArray = [];
			var tfm:TextFormat = new TextFormat();
			tfm.align = TextFormatAlign.RIGHT;
			tfm.color = 0xFFFFFF;
			var prevHeight:Number = 0;
			//テキストフィールド設定
			for (var i:uint = 0; i < 5; i++){
				var tf:TextField = new TextField();
				addChild(tf);
				tf.restrict = "0-9\\-.";
				tf.width = 30;
				tf.height = 20;
				tf.background = true;
				tf.backgroundColor = 0xFFFFFF;
				tf.type =  TextFieldType.INPUT;
				tfArray.push(tf);
				tf.x = stage.stageWidth - tf.width;
				tf.y = tf.height * i * 1.2 + 5;
				
				var eTf:TextField = new TextField();
				eTf.width = 200;
				eTf.defaultTextFormat = tfm;
				addChild(eTf);
				eTfArray.push(eTf);
				eTf.y = tf.y;
				eTf.x = tf.x-200 ;
			}
			//ポイント数
			tfArray[0].text = maxPoint;
			eTfArray[0].text = "道を描くパスのポイント数";
			//ポイントスプリング
			tfArray[1].text = spring
			eTfArray[1].text = "ポイントのバネ定数";
			//ポイントフリクション
			tfArray[2].text = friction
			eTfArray[2].text = "ポイントの摩擦力";
			//重力X
			tfArray[3].text = gravityX;
			eTfArray[3].text = "ポイントの重力X";
			//重力Y
			tfArray[4].text = gravityY;
			eTfArray[4].text = "ポイントの重力Y ";
			
			//更新ボタン
			var sp:Sprite = new Sprite();
			sp.buttonMode = true;
			sp.addEventListener(MouseEvent.CLICK , controllerClickHandler);
			addChild(sp);
			sp.graphics.beginFill(0);
			sp.graphics.drawRect(0, 0, 30, 20);
			sp.graphics.endFill();
			sp.x = stage.stageWidth - sp.width;
			sp.y = tf.y + 40;
			var eBTf:TextField = new TextField();
			addChild(eBTf);
			eBTf.defaultTextFormat = tfm;
			eBTf.x = sp.x -100;
			eBTf.y = sp.y;
			eBTf.text = "更新";
		}
		
		private function controllerClickHandler(e:MouseEvent):void {
			maxPoint = Number(tfArray[0].text);
			spring = Number(tfArray[1].text);
			friction = Number(tfArray[2].text);
			gravityX = Number(tfArray[3].text);
			gravityY = Number(tfArray[4].text);
			
			if (tfArray[0] == "" || tfArray[1] == "" || tfArray[2] == "" || tfArray[3] == "" || tfArray[4] == "") return;
			//左側のポイント数
			leftPoint = Math.ceil(maxPoint / 2);
			trace( "leftPoint : " + leftPoint );
			//ポイント格納用配列
			pointArray = [];
			for (var i:Number = 0; i < maxPoint; i++){
				pointArray.push(new CustomPoint(this.stage.stageWidth, this.stage.stageHeight,spring , friction,gravityX,gravityY));
			}
		}
		
		private function enterFrameHandler(e:Event):void {
			var sp:Sprite = e.target as Sprite;
			//マウスポイント用のオブジェ
			//直接マウスポインタを追いかけさせるのではなく、ワンクッション的なもの
			mousePoint.x += (this.mouseX - mousePoint.x)*0.1;
			mousePoint.y += (this.mouseY - mousePoint.y) * 0.1;
			
			var springLength:Number 
			var targetX:Number
			var targetY:Number
			var ax:Number
			var ay:Number
			var dx:Number;
			var dy:Number;
			var angle:Number;
			var fixedX:Number;
			var fixedY:Number;
			
			//三角形左辺側の作成
			for (var i:Number = 0; i < leftPoint; i++ ) {
				
				//一個目のポイントはマウスポインタオブジェから加速度を設定。
				if (i == 0) {
					targetX = mousePoint.x
					targetY = mousePoint.y
					
					ax = (targetX - pointArray[i].posX) * par;
					ay = (targetY - pointArray[i].posY) * par;
					
					pointArray[i].setKasokudo(ax, ay);
				}
				//2個目以降のポイントは一個前のポイントから加速度を設定
				else {
					targetX = pointArray[i-1].posX;
					targetY = pointArray[i-1].posY;
					ax = (targetX - pointArray[i].posX) * par/i*2 - i*6;
					ay = (targetY - pointArray[i].posY) * par/i;
					
					pointArray[i].setKasokudo(ax, ay);
				}
			}
			ii = 2;
			//三角形右辺側の作成
			for (i = maxPoint-1; i >= leftPoint; i--) {
				if (i == maxPoint-1) {
					targetX = mousePoint.x
					targetY = mousePoint.y
					
					ax = (targetX - pointArray[i].posX) * par;
					ay = (targetY - pointArray[i].posY) * par/1;
					
					pointArray[i].setKasokudo(ax, ay);
				}
				else {
					targetX = pointArray[i+1].posX;
					targetY = pointArray[i+1].posY;
					
					ax = (targetX - pointArray[i].posX) * par/ii*2 + ii*(20-ii*3);
					ay = (targetY - pointArray[i].posY) * par/ii;
					pointArray[i].setKasokudo(ax, ay);
					ii++;
				}

			}
			sp.graphics.clear();
			sp.graphics.lineStyle(2, 0xFFFF33);
			
			drawCurve(pointArray, sp);
			
			var bm:CustomBitmap = new CustomBitmap(bmd);
			bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			bmd.draw(sp,matrix,null,null,new Rectangle(0,0,stage.stageWidth, stage.stageHeight),true);
			bmd.colorTransform(rect,cTra);
			addChildAt(bm, 1);
			bm.x = 5
			bm.y = 20
			bm.addEventListener("dispose", dispose);
		}
		
		private function dispose(e:Event):void {
			removeChild(Bitmap(e.target));
		}
		public  function drawCurve(pointArray: Array, sp: Sprite):void {
			//ポイントの座標の計算
			//sp.graphics.beginFill(0xFFFF00);
			sp.graphics.beginGradientFill(GradientType.RADIAL,
				[0xFFFFcc , 0xFFFFcc , 0xcccc33 , 0x999933 , 0x666600],
				[ 1 , 1 ,  1 ,  1 , 1],
				[ 0 , 64, 127 , 192 , 255],
				new Matrix(
					1 , 0 ,
					0 , 1 ,
					sp.mouseX , sp.mouseY
				),
				SpreadMethod.PAD,
				InterpolationMethod.LINEAR_RGB,
				0.0
			);
			if (pointArray.length > 2) {
				sp.graphics.moveTo(pointArray[0].posX, pointArray[0].posY);  
				for (var i:Number = 1; i < pointArray.length - 1; i++){
					sp.graphics.curveTo(
						pointArray[i].posX, 
						pointArray[i].posY, 
						(pointArray[i].posX + pointArray[i + 1].posX) / 2, 
						(pointArray[i].posY + pointArray[i + 1].posY) / 2
						);      
				}
				sp.graphics.curveTo(
					pointArray[pointArray.length - 1].posX, 
					pointArray[pointArray.length - 1].posY, 
					pointArray[0].posX, 
					pointArray[0].posY
					);
				sp.graphics.endFill();
			}  
		}
	}
	
}


/**
 * ...
 * 頂点が追いかける光
 * @author 393
 */
import flash.display.*;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.filters.BlurFilter;
import flash.geom.Matrix;
import flash.utils.Timer;

class MousePoint extends Sprite {
	
	private var speed:Number;
	
	function MousePoint():void {
		graphics.beginFill(0xeeee00);
		graphics.drawCircle(0, 0, 300);
		graphics.endFill();
		var blur = new BlurFilter(300, 300,2);
		this.filters = [blur];
		speed = 0;
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	private function enterFrameHandler(e:Event):void {
		speed += Math.random() * 0.2;
		var radiusX:Number = Math.random() * 10;
		var radiusY:Number = Math.random() * 10;
		x += radiusX+Math.sin(speed)*radiusX;
		y += radiusY+Math.cos(speed/2)*radiusY;
	}
	
}
/**
 * ...
 * 道を形作るパスを描くためのポイント
 * @author 393
 */
class CustomPoint {
	private var _posX:Number;
	private var _posY:Number;
	private var spring:Number;
	private var friction:Number;
	private var vx:Number = 0;
	private var vy:Number = 0;
	private var ax:Number = 0;
	private var ay:Number = 0;
	private var gravityX:Number;
	private var gravityY:Number;
	
	public function CustomPoint(posX:Number, posY:Number, spring:Number = .06, friction:Number = .8, gravityX:Number = 2, gravityY:Number = 2 ) {
		this.spring = spring;
		this.friction = friction;
		this.gravityX = gravityX;
		this.gravityY = gravityY;
		_posX = posX;
		_posY = posY;
		var timer:Timer = new Timer(33);
		timer.addEventListener(TimerEvent.TIMER, timerHandler);
		timer.start();
	}
	
	private function timerHandler(e:TimerEvent):void {
		ax = ax * spring;
		vx += ax;
		vx += gravityX;
		vx *= friction;
		_posX += vx;
		
		ay = ay * spring;
		vy += ay;
		vy += gravityY;
		vy *= friction;
		_posY += vy;
		
	}
	public function setKasokudo(aax:Number, aay:Number):void {
		ax = aax;
		ay = aay;
	}
	
	public function get posX():Number { return _posX; }
	public function get posY():Number { return _posY; }
	
}

/**
 * ...
 * 道の残像
 * @author 393
 */
class CustomBitmap extends Bitmap {
	public function CustomBitmap(bmd:BitmapData):void {
		super(bmd);
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	private function enterFrameHandler(e:Event):void {
		x+= 10;
		y+= 40;
		alpha -= .3
		if (alpha <= 0){
			removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
			dispatchEvent(new Event("dispose"));
		}
	}
}