/**
 * Copyright signedvoid ( http://wonderfl.net/user/signedvoid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o9Ud
 */

// forked from DaniilTutubalin's Game of Life. Universal. GUI
// forked from DaniilTutubalin's Game of Life. Universal
/* Game of Life by Daniil Tutubalin

The idea was invented partially by me, partially by other people.
Quasimondo  http://www.quasimondo.com/archives/000680.php 
was the first who got an idea to use paletteMap for Game of Life.
My initial idea was to use threshold method, 
but it required to be called twice and it was much less adapting for different rules. 
Using paletteMap is one line shorter and more adapting.

So, this code allows you to experiment with different rules of Game of Life
*/

package {
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.display.MovieClip;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.geom.Point;
    import flash.filters.ConvolutionFilter;
    import flash.display.Bitmap;
    import flash.events.*;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.text.*;
    public class Life extends Sprite {
        
        
        /* 
            Also try these rules:

            3 : 23        
               Classic rules: cell borns if and only if 3 neighbors are nearby, cell survive if 2 or 3 neighbors
        
            45678 : 2345
               Walled Cities - best with density = 17%
                   
            23 : 12345
               Maze generation
           
            368 : 245
               Space travellers
        
            More rules can be found here: http://en.wikipedia.org/wiki/Life-like_cellular_automaton
        */        
                       
        // Convolution filter. 
        // 1 for every neighbor, 9 for cell itself
        // so empty cell result in 0..8 depending on number of neighbors
        // live cell result in 9..17
        private const LIFE_FILTER:ConvolutionFilter = new ConvolutionFilter(3, 3, [1,1,1,1,9,1,1,1,1], 255, 0, true, false, 0, 1);
                
        private const POINT_ZERO:Point = new Point();
        private const EMPTY_ARRAY:Array = [];
        
        private var gameField:BitmapData;
        private var bitmap:Bitmap;
        private var palette:Array;
        
        private var inputBorn:TextField;
        private var inputLife:TextField;
        private var inputDensity:TextField;
        
        private var btnGo:Sprite;
        
        public function Life() {            
            if (stage) {
                init();
            } else {
                addEventListener(Event.ADDED_TO_STAGE, init);
            }
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);            
            initGUI();            
            reset();            
            addEventListener(Event.ENTER_FRAME, run);
        }

        private function run(e:Event = null):void {
            gameField.lock();
            gameField.applyFilter(gameField,gameField.rect, POINT_ZERO, LIFE_FILTER);
            gameField.paletteMap(gameField,gameField.rect, POINT_ZERO, palette, [], []);
            //gameField.applyFilter(gameField,gameField.rect, POINT_ZERO, new GlowFilter(0xFFFFFF, 1, 5, 5, 2, 2));
            gameField.unlock();
        }

        private function reset(e:Event = null):void {
            // init palette array
            palette = [];
            
            var born:String = inputBorn.text;
            var survive:String = inputLife.text;            
            
            // 0..8 - to burn
            for (var i:int = 0; i<9; i++) {
                if (born.indexOf(String(i)) != -1) {
                    palette.push(0xFFFFFF);
                } else {
                    palette.push(0x000000);
                }
            }
            // 9..17 - to survive
            for (i = 0; i<9; i++) {
                if (survive.indexOf(String(i)) != -1) {
                    palette.push(0xFFFFFF);
                } else {
                    palette.push(0x000000);
                }
            }
            
            // make some noise
            var colorMin:int;
            var colorMax:int;
            var density:Number = Number(inputDensity.text);
            if (density <= 50) {
                colorMin = 0;
                colorMax = 5.1 * density;                  
            } else {
                colorMin = 5.1 * (density-50)
                colorMax = 255;
            }
            gameField.noise(int(Math.random()*int.MAX_VALUE),colorMin,colorMax,1,true);
        }
        
        private function initGUI():void {
            // create labels
            var format:TextFormat = new TextFormat("Arial");
            var labelBorn:TextField = new TextField();
            labelBorn.height = 20;
            labelBorn.defaultTextFormat = format;
            labelBorn.text = "Birth:";
            labelBorn.selectable = false;
            addChild(labelBorn);
            
            var labelLife:TextField = new TextField();
            labelLife.height = 20;
            labelLife.x = 130;
            labelLife.defaultTextFormat = format;
            labelLife.text = "Life:";
            labelLife.selectable = false;
            addChild(labelLife);
            
            var labelDensity:TextField = new TextField();
            labelDensity.height = 20;
            labelDensity.x = 255;
            labelDensity.defaultTextFormat = format;
            labelDensity.text = "Density:";
            labelDensity.selectable = false;
            addChild(labelDensity);
            
            // create inputs
            
            inputBorn = new TextField();   
            inputBorn.type = TextFieldType.INPUT;
            inputBorn.defaultTextFormat = format;
            inputBorn.x = 35;
            inputBorn.height = 18;
            inputBorn.width = 90;
            inputBorn.border = true;
            inputBorn.borderColor = 0x000000;
            inputBorn.text = "3,4,5,6,7";
            addChild(inputBorn);
            
            inputLife = new TextField();   
            inputLife.type = TextFieldType.INPUT;
            inputLife.defaultTextFormat = format;
            inputLife.x = 160;
            inputLife.width = 90;
            inputLife.height = 18;
            inputLife.border = true;
            inputLife.borderColor = 0x000000;
            inputLife.text = "5,6,7";
            addChild(inputLife);
            
            inputDensity = new TextField();   
            inputDensity.type = TextFieldType.INPUT;
            inputDensity.defaultTextFormat = format;
            inputDensity.x = 300;
            inputDensity.width = 60;
            inputDensity.height = 18;
            inputDensity.border = true;
            inputDensity.borderColor = 0x000000;
            inputDensity.text = "13.6";
            addChild(inputDensity);
            
            // create button
            
            btnGo = new Sprite();
            btnGo.useHandCursor = true;
            btnGo.graphics.beginFill(0x000000,1);
            btnGo.graphics.drawRoundRect(0,0,80,18,12);
            btnGo.graphics.endFill();
            
            var formatGo:TextFormat = new TextFormat("Arial",14,0x000000,true);
            var labelGo:TextField = new TextField();
            labelGo.defaultTextFormat = formatGo;
            labelGo.text = "GO!";
            labelGo.selectable = false;
            labelGo.x = 25;
            labelGo.textColor = 0xFFFFFF;
            
            btnGo.addChild(labelGo);            
            btnGo.x = 380;
            addChild(btnGo);
            
            btnGo.addEventListener(MouseEvent.CLICK, reset);
              
            
            // create field
            gameField = new BitmapData(stage.stageWidth, stage.stageHeight-24, false, 0x000000);
            
            // put on stage            
            bitmap = new Bitmap(gameField);
            bitmap.y = 24;
            bitmap.filters = [new BlurFilter(3,3,3)];
            addChild(bitmap);
        }

    }
}