/**
 * Copyright nausicaa ( http://wonderfl.net/user/nausicaa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o9Th
 */

// forked from yd_niku's flash on 2009-9-7
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    public class PagerSample extends Sprite{

        private var _currentPage:int;
        private var _totalPages:int;
        
        private var _numField:TextField;

        public function PagerSample () {
            _currentPage = 0;
            _totalPages= 10;
            
            _numField = new TextField();
            _numField.width = 60;
            _numField.height= 24;
            addChild( _numField );
            
            var btnPrev:Sprite = new PageButton("PREV");
            var btnNext:Sprite  = new PageButton("NEXT");
            
            btnPrev.x = 70;
            btnNext.x = 110;
            
            addChild( btnPrev );
            addChild( btnNext );
            
            btnPrev.addEventListener( MouseEvent.CLICK, prevPage );
            btnNext.addEventListener( MouseEvent.CLICK, nextPage );
            
            updatePager();
        }
        
        private function nextPage( e:MouseEvent ) :void {
            _currentPage = Math.min( _totalPages -1, _currentPage +1 );
            
            updatePager();
        }
        
        private function prevPage( e:MouseEvent ) :void {
            _currentPage = Math.max( 0, _currentPage -1 );
            
            updatePager();
        }
        
        
        private function updatePager():void {
            _numField.text = String( _currentPage +1 ) + "/" + _totalPages + " Page";
        }

    }

}

import flash.display.Sprite;
import flash.text.TextField;

class PageButton extends Sprite {
    public function PageButton ( label:String ) {
        var textField: TextField = new TextField();
        textField.width = 36;
        textField.height= 24;
        textField.text = label;
        addChild( textField );
        mouseChildren = false;
        buttonMode = true;
    }
}
