/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o8gx
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    import flash.geom.Point;
    
    [SWF(width = "465", height = "465", frameRate="60")]
    
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        
        private var particles:/*Particle*/Array;
        private var particleNum:int;
        private var canvas:BitmapData;
        
        private var press:Boolean = false;
        
        private static const POWER_RANGE:Number = 150;
                
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            
            particles = [];
            particleNum = 0;
            for ( var y:int = 0; y < (HEIGHT / 3); y++ )
            {
                for ( var x:int = 0; x < (WIDTH / 3); x++ )
                {
                    var p:Particle = new Particle();
                    p.x = x * 3;
                    p.y = y * 3;
                    p.basex = p.x;
                    p.basey = p.y;
                    
                    particles.push( p );
                    particleNum++;
                }
            }
            
            canvas = new BitmapData( WIDTH, HEIGHT, true, 0 );
            addChild( new Bitmap( canvas ) );
            
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
            stage.addEventListener( MouseEvent.MOUSE_DOWN, MouseDownHandler );
            stage.addEventListener( MouseEvent.MOUSE_UP, MouseUpHandler );
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {
            var i:int;
            
            if ( press )
            {
                var mx:Number = stage.mouseX;
                var my:Number = stage.mouseY;
                
                var powerRange:Number = POWER_RANGE * POWER_RANGE;
                
                for ( i = 0; i < particleNum; i++ )
                {
                    var disx:Number = particles[i].x - mx;
                    var disy:Number = particles[i].y - my;
                    var dislength:Number = (disx * disx) + (disy * disy);
                    var prevx:Number = particles[i].x;
                    var prevy:Number = particles[i].y;
                    
                    if ( dislength <= powerRange )
                    {
                        var power:Number = (1 - (dislength / powerRange)) * 10;
                        var rad:Number = power * Math.PI / 180;
                        var cos:Number = Math.cos( rad );
                        var sin:Number = Math.sin( rad );
                        var newx:Number = mx + (disx * cos - disy * sin) * 0.9;
                        var newy:Number = my + (disx * sin + disy * cos) * 0.9;
                            
                        particles[i].x = newx;
                        particles[i].y = newy;
                                                                        
                    }                    
                }
            }else
            {
                for ( i = 0; i < particleNum; i++ )
                {
                    
                    particles[i].x += particles[i].exx;
                    particles[i].y += particles[i].exy;
                    particles[i].exx *= 0.9;
                    particles[i].exy *= 0.9;                    
                                        
                    particles[i].x += (particles[i].basex - particles[i].x) * 0.2;
                    particles[i].y += (particles[i].basey - particles[i].y) * 0.2;
                    if ( Math.abs( (particles[i].basex - particles[i].x) * (particles[i].basex - particles[i].x) + (particles[i].basey - particles[i].y) * (particles[i].basey - particles[i].y) ) < 0.1 )
                    {
                        particles[i].x = particles[i].basex;
                        particles[i].y = particles[i].basey;
                    }
                }    
            }
            
            canvas.lock();
            canvas.fillRect( canvas.rect, 0 );
            for ( i = 0; i < particleNum; i++ )
            {
                canvas.setPixel32( particles[i].x, particles[i].y, 0xFFFFFFFF );
                
            }
            canvas.unlock();
        }
        
        private function MouseDownHandler( e:MouseEvent ) : void
        {
            press = true;
        }
        
        private function MouseUpHandler( e:MouseEvent ) : void
        {
            press = false;
            
            var mx:Number = stage.mouseX;
            var my:Number = stage.mouseY;
                        
            for ( var i:int = 0; i < particleNum; i++ )
            {                                
                var distance:Number = Math.sqrt( (particles[i].x - mx) * (particles[i].x - mx) + (particles[i].y - my) * (particles[i].y - my) );
                
                if ( distance > 200 )
                {
                    particles[i].exx = 0;
                    particles[i].exy = 0;
                }else
                {
                    particles[i].exx = (particles[i].x - mx) / distance * (1-(distance/200)) * 100;
                    particles[i].exy = (particles[i].y - my) / distance * (1-(distance/200)) * 100;
                }
            }    
        }
    }
    
}

class Particle {

    public var x:Number;
    public var y:Number;
    public var basex:Number;
    public var basey:Number;
    
    public var compressCount:int = 0;
    public var explosionAngle:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public var exx:Number = 0;
    public var exy:Number = 0;
}