/**
 * Copyright hacker__a05fz1a ( http://wonderfl.net/user/hacker__a05fz1a )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o8gB
 */

// forked from uwi's forked from: PV3Dでパーティクル回転
// forked from azzip's PV3Dでパーティクル回転
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	import flash.geom.Point;
	
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.objects.special.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.core.render.filter.*;
	import org.papervision3d.view.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.core.math.*;
	import org.papervision3d.core.utils.*;
	import org.papervision3d.events.*;
	import org.papervision3d.core.geom.*;
	import org.papervision3d.core.geom.renderables.*;
	import org.papervision3d.core.effects.*;
	
	/**
	 * ...
	 * @author 
	 */
	public class Main extends BasicView 
	{
		private var particles:ParticleField;
		
		
		public function Main() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		//
		//-------------------------------------
		//  init
		//-------------------------------------
		private function init(e:Event = null):void 
		{
			stage.align = "TL";
			stage.scaleMode = "noScale";
			

			var material:ParticleMaterial = new ParticleMaterial(0xFF0000, 1, 1, 4);
			
			particles = new ParticleField(material, 500, 2, 2000, 2000, 2000);
			scene.addChild(particles); 
			
			// ごり押し
			for each(var p : Particle in particles.particles){
				p.material = new ParticleMaterial(colorHSV(Math.random(), 1, 1), 1, 1, 4);
			}
			
			startRendering();
			
			
			addEventListener(Event.ENTER_FRAME, enterHandler);
			
		}
		
		private function enterHandler(e:Event):void 
		{
			var mouseP:Point = new Point(stage.mouseX,stage.mouseY);
			mouseP.offset(-stage.stageWidth/2,-stage.stageHeight/2);
			particles.rotationY += mouseP.y/40;
			particles.rotationX += mouseP.x/40;	

			
		}
		
		private function colorHSV(h : Number, s : Number, v : Number) : uint
		{
			v *= 255;
			var r : int, g : int, b : int;
			if(s > 0){
				h = ((h < 0) ? h % 1 + 1 : h % 1) * 6;
				if(h < 1){
					r = Math.round(v);
					g = Math.round(v * (1 - s * (1 - h)));
					b = Math.round(v * (1 - s));
				}else if(h < 2){
					r = Math.round(v * (1 - s * (h - 1)));
					g = Math.round(v);
					b = Math.round(v * (1 - s));
				}else if(h < 3){
					r = Math.round(v * (1 - s));
					g = Math.round(v);
					b = Math.round(v * (1 - s * (3 - h)));
				}else if(h < 4){
					r = Math.round(v * (1 - s));
					g = Math.round(v * (1 - s * (h - 3)));
					b = Math.round(v);
				}else if(h < 5){
					r = Math.round(v * (1 - s * (5 - h)));
					g = Math.round(v * (1 - s));
					b = Math.round(v);
				}else{
					r = Math.round(v);
					g = Math.round(v * (1 - s));
					b = Math.round(v * (1 - s * (h - 5)));
				}
			}else{
				r = g = b = Math.round(v);
			}
			return r << 16 | g << 8 | b;
		}
	}
}