/**
 * Copyright mirkofresa ( http://wonderfl.net/user/mirkofresa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o8ZS
 */

// forked from mirkofresa's forked from: [PV3D] Typography
// forked from clockmaker's [PV3D] Typography
/**
* 3D Typography
* 参照 : http://clockmaker.jp/blog/2008/12/papervision_vector_font/
*/
package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.typography.fonts.HelveticaBold;
	import org.papervision3d.typography.Text3D;
	import caurina.transitions.properties.CurveModifiers;
	import caurina.transitions.Tweener;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	[SWF(width = "560", height = "100", frameRate = "30", backgroundColor = "0xffffff")]
	
	public class Main extends BasicView 
	{
		public function Main():void 
		{
			CurveModifiers.init()
			stage.quality = StageQuality.MEDIUM;
 			motion();
			stage.addEventListener(MouseEvent.CLICK, motion);
			startRendering();
		}
		
		private function motion(e:Event = null):void
		{
			// create letter
			var text:TextField = new TextField();
			text.htmlText = "<font face='Arial' size='20'>PROGRAMMING</font>";
			text.autoSize = "left";
			
			var cap:BitmapData = new BitmapData(text.textWidth, text.textHeight, true, 0xFFFFFFFF);
			cap.draw(text);
			//addChild(new Bitmap(cap))
			
			var wrap:DisplayObject3D = scene.addChild(new DisplayObject3D());
			
			// particle motion
			var cnt:int = 0;
			for (var i:int = 0; i < text.textWidth; i++ )
			{
				for (var j:int = 0; j < text.textHeight; j++ )
				{
					if (cap.getPixel(i, j) == 0xFFFFFF) continue;
					
					// A-Z
					var char:String = String.fromCharCode(55 + 60 * Math.random() | 0);
					
					// letter
					var lettermat:Letter3DMaterial = new Letter3DMaterial();
					lettermat.fillColor = 0x227373;
					var word:Text3D = new Text3D(char , new HelveticaBold() , lettermat);
					
					word.x = 1000 * Math.random() - 500 - 500;
					word.y = 1000 * Math.random() - 500;
					word.z = -5000;
					word.scale = 1;
					word.rotationZ = 720 * Math.random();
					wrap.addChild(word);
					
					Tweener.addTween(word,
					{
						x : (i - text.textWidth / 2) * 30,
						y : (text.textHeight / 2 - j) * 30,
						z : 0,
						scale : 0.5,
						rotationZ: 0,
						_bezier : [{x : 1000, y : 0}],
						time : 6,
						transition : "easeInOutExpo",
						delay : cnt++ * 0.0175
					});
				}
			}
			
			// wrap motion
			wrap.z = 3000;
			Tweener.addTween(wrap,
			{
				z : -3600,
				time : 30,
				transition : "easeInExpo",
				onComplete : function():void
				{
					scene.removeChild(wrap);
					CurveModifiers.init();
					motion();
				}
			});
            
			// camera motion
			camera.x = -100;
			Tweener.addTween(camera,
			{
				x : -800,
				time : 29,
				transition : "easeInExpo"
				
			});
			
		}
		
	}
	
}