/**
 * Copyright milkmidi ( http://wonderfl.net/user/milkmidi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o8Wl
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.net.*;
	import flash.system.*;
	import gs.*;
	import gs.easing.*;
import flash.text.TextField;
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#cccccc")]
	public class MassiveImageParticle2 extends Sprite {
		private var bmd		:BitmapData;		
		private var localX	:int;
		private var localY	:int;		
		private var pArr	:Vector.<Point>;		
		private var pReady	:Boolean = false;		
		private var canvas	:Bitmap;
		private var sh		:int = 480;
		private var sw		:int = 700;
		private var _pixelW	:int = 10;
		private var _pixelH	:int = 10;
		private var w		:int;
		private var h		:int;
		private var src		:BitmapData;
		private var ctm		:ColorTransform;		
		public function MassiveImageParticle2() {
			
			var _ldr:Loader = new Loader();
			_ldr.load(new URLRequest("http://assets.wonderfl.net/images/related_images/e/ee/eed8/eed824227b0f145757eb3dd9b03027d90829cca6"),new LoaderContext(true ));
			_ldr.contentLoaderInfo.addEventListener(Event.COMPLETE , _completeHandler);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			TextField(addChild(new TextField)).text = "click stage";
		}
		
		private function _completeHandler(e:Event):void {
			src = Bitmap(e.currentTarget.loader.content).bitmapData;
			sw = src.width;
			sh = src.height;
			w = sw / _pixelW;
			h = sh / _pixelH;
			
			ctm = new ColorTransform(0.8, 0.8, 0.6, .2);							
			stage.addEventListener(MouseEvent.CLICK, onStartClick);			
			trace("w:", w, "h", h);			
			trace(w * h, " particles");			
			pArr = new Vector.<Point>();			
			canvas = new Bitmap();
			localX = (stage.stageWidth - sw) / 2;			
			localY = (stage.stageHeight - sh) / 2;
			addChild(canvas);
		}
		private function onStartClick(e:MouseEvent):void {
			stage.removeEventListener(MouseEvent.CLICK, onStartClick);
			stage.addEventListener(MouseEvent.CLICK, onResetClick);
			onResetClick(e);
			addEventListener(Event.ENTER_FRAME, drawParticle);				
		}
		private function onResetClick(e:MouseEvent):void {
			resetCanvas();
			resetParticle();			
		}
		private function resetCanvas():void {
			bmd = new BitmapData(1000, 600, true, 0);
			canvas.bitmapData = bmd;			
		}
		private function resetParticle():void {			
			var _p2d	:Point;			
			var _index	:int = 0;			
			for (var i:int = 0; i < w; i++) {
				for (var j:int = 0; j < h; j++) {
					if (!pReady){
						_p2d = new Point();						
						pArr.push(_p2d);
					} else {
						_p2d = pArr[_index];						
					}
					_p2d.x = mouseX;
					_p2d.y = mouseY;					
					TweenMax.killTweensOf(_p2d);
					var _time:Number = 0.5 + Math.random() * 1.5;					
					TweenMax.to(_p2d, _time, 
					{
						x		: localX + i * _pixelW, 
						y		: localY + j * _pixelH, 
						ease	: Quad.easeOut,
						delay	: i / 80 + j / 50
					});					
					_index++;
				}
			}
			pReady = true;			
		}		
		private function drawParticle(e:Event):void {						
			bmd.lock();			
			bmd.colorTransform(bmd.rect, ctm);			
			var _index:int = 0;
			var op:Point = new Point();
            for (var i:int = 0; i < w; i++) {
                for (var j:int = 0; j < h; j++) {                    
                    op.x = i * _pixelW;
                    op.y = j * _pixelH;                    
                    var tp:Point =  pArr[_index];                    
                    bmd.copyPixels(src, new Rectangle(op.x, op.y, _pixelW, _pixelH), new Point(tp.x, tp.y));	
					_index++;
                }
            }						
			bmd.unlock();			
		}
	}
}
