/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o80a
 */

// forked from nondelion's BetweenAS3でテキストをtweenしてみる
/**
 * @see http://nondelion.com/archives/2009/09/16/2237
 */
package
{
    import flash.display.Sprite;
    import flash.text.*;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.tweens.ITweenGroup;
    import org.libspark.betweenas3.tweens.IObjectTween;
    import org.libspark.betweenas3.events.TweenEvent;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0x0")]
    
    public class Main extends Sprite
    {
        protected static const COL:int = 460;
        private var str:String = "";
        private var st:SequentialText;
        private var txt:TextField;
        private var tween:ITweenGroup;
        
        public function Main()
        {
            for(var i:int=0; i<COL; i++) {
                str += "民主党が、元党所属国会議員の河村たかし・前名古屋市長（６２）と全面戦争している愛知のダブル選挙";
                if(i < COL-1){ str += "\r"; }
            }
            
            txt = newTextField();
            
            // 等速のテキストトランジションを作成
            st = new SequentialText(txt, 1.6);
            
            var t1:IObjectTween = BetweenAS3.tween( st, {position: st.totalTime}, {position: 0}, st.totalTime, Quad.easeInOut);
            //var r1:ITween = BetweenAS3.reverse(t1); // 逆再生
            tween = BetweenAS3.serial(t1);
            tween.stopOnComplete = false; // ループ設定
            tween.play(); // 再生
            
            //this.addChild(new Stats());
        }
        
        private function newTextField():TextField
        {
            var tf:TextField = addChild( new TextField() ) as TextField;
            tf.defaultTextFormat = new TextFormat("Verdana", 12, 0xffffff);
            tf.text = str;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.selectable = false;
            tf.x = -1;
            return tf;
        }
    }
}

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.text.TextField;

class SequentialText extends EventDispatcher
{
    private var currentIndex:uint;
    private var _text:String;
    private var _speed:Number;
    private var _txt:TextField;
    
    
    // 再生時間
    private var _totalTime:Number;
    public function get totalTime():Number
    {
        return _totalTime;
    }
    
    // 現在時刻
    private var _position:Number;
    public function set position(val:Number):void
    {
        _position = val;
        update();
    }
    
    // コンストラクタ
    public function SequentialText(tf:TextField, time:Number=1.0)
    {
        _txt = tf;
        _text = tf.text;
        _totalTime = time;
        _speed = 100/_text.length; // 速度を求める
        _txt.text = "";
    }
        
    private function update():void
    {
        // 現在のテキストを取得
        currentIndex = Math.floor(_position/_speed);
        _txt.text = currentIndex > 0 ? _text.substr(0, currentIndex) : "";
        
        // 現在のテキストが正しい文字列になったら終了
        if(_totalTime <= _position) {
            _txt.text = _text;
            dispatchEvent(new Event(Event.COMPLETE));
        }
    }
}