/**
 * Copyright beyazdavsan ( http://wonderfl.net/user/beyazdavsan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o7SV
 */

// forked from ll_koba_ll's Threadライブラリそうめんで作る簡単スライドショー サンプルコード 
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.system.Security;
    import org.libspark.thread.Thread;
    import org.libspark.thread.EnterFrameThreadExecutor;
    

    public class Slideshow extends Sprite {
        public function Slideshow() {
            // Threadライブラリの初期化
            Thread.initialize(new EnterFrameThreadExecutor());
            addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event):void {
            stage.scaleMode = "noScale";
            stage.align = "LT";
            var context:Context = new Context();
            context.root = this;
            context.photoList = [];
            context.stage = stage;
            // メインスレッドスタート
            new MainThread(context).start();
        }
    }
}

import flash.display.DisplayObjectContainer; 
import flash.display.DisplayObject;
import flash.display.Stage;
import flash.display.Bitmap;
import flash.net.URLRequest;
import flash.net.URLVariables;
import flash.net.URLLoader;
import org.libspark.thread.Thread;
import org.libspark.thread.threads.net.URLLoaderThread;
import org.libspark.thread.utils.SerialExecutor;
import org.libspark.thread.utils.ParallelExecutor;
import org.libspark.thread.threads.display.LoaderThread;
import org.libspark.thread.threads.tweener.TweenerThread;
import com.adobe.serialization.json.JSON;
import flash.system.Security;

class Context {
    public var photoList:Array;
    public var root:DisplayObjectContainer;
    public var stage:Stage;
}


class MainThread extends Thread {
    private var _context:Context;

    public function MainThread(context:Context) {
        _context = context;
    }

    protected override function run():void {
        // 写真の読み込みの後、スライドショウ
        var se:SerialExecutor = new SerialExecutor();
        se.addThread(new LoadPhotoThread(_context));
        se.addThread(new SlideshowThread(_context));
        se.start();
    }
}

class LoadPhotoThread extends Thread {
    private var _context:Context;
    private var _urlLoaderThread:URLLoaderThread;
    private var _imageLoaders:ParallelExecutor;

    public function LoadPhotoThread(context:Context) {
        _context = context;
    }

    protected override function run():void {
        // crossdomain.xml指定
        Security.loadPolicyFile("http://query.yahooapis.com/crossdomain.xml");  
        // YQLでflickrにある特定setsの写真リストをJSON形式で取得
        var req:URLRequest = new URLRequest("http://query.yahooapis.com/v1/public/yql");
        var data:URLVariables = new URLVariables();
        data["q"] = "select * from flickr.photosets.photos where photoset_id='72157622583449428' limit 5";
        data["format"] = "json";
        req.data = data;
        var l:URLLoader = new URLLoader();
        _urlLoaderThread = new URLLoaderThread(req, l);
        _urlLoaderThread.start(); // 実行
        _urlLoaderThread.join(); // 終了まで待機
        next(dataLoaded); // 終了したら次のメソッドへ
    }


    private function dataLoaded():void {
        var json:Object = JSON.decode(_urlLoaderThread.loader.data);
        // 並列処理で画像を読み込み
        _imageLoaders = new ParallelExecutor();
        for each(var o:Object in json.query.results.photo) {
            Security.loadPolicyFile("http://farm" + o.farm + 
                                    ".static.flickr.com/" + "crossdomain.xml");
            var url:String = "http://farm" + o.farm + ".static.flickr.com/" 
                             + o.server + "/" + o.id + "_" + o.secret + ".jpg";
            _imageLoaders.addThread(new LoaderThread(new URLRequest(url)));
        }
        _imageLoaders.start();
        _imageLoaders.join();
        next(imageLoadCompete);
    }

    private function imageLoadCompete():void {
        // 読み込んだ画像を配列に格納
        for (var i:int = 0; i < _imageLoaders.numThreads; i++) {
            var l:LoaderThread = LoaderThread(_imageLoaders.getThreadAt(i));
            Bitmap(l.loader.content).smoothing = true;
            _context.photoList.push(l.loader);
        }
    }

}


class SlideshowThread extends Thread {
    private var _context:Context;
    private var _currentPhotoIndex:int = 0;
    public function SlideshowThread(context:Context) {
        _context = context;
    }

    protected override function run():void {
        nextPhoto();
    }

    private function nextPhoto():void {
        // 次の写真取得
        var p:DisplayObject = _context.photoList[_currentPhotoIndex]
        _context.root.addChild(p);

        // 大きさをSWFの表示サイズに合わせる
        var scale:Number;
        if (p.width > p.height) {
            scale = _context.stage.stageWidth/p.width;
        } else {
            scale = _context.stage.stageHeight/p.height;
        }
        p.scaleX = scale;
        p.scaleY = scale;
        p.y = _context.stage.stageHeight/2 - p.height/2;
        p.x = _context.stage.stageWidth/2 - p.width/2;
        p.alpha = 0;

        // フェードインして、1秒とまってフェードアウト
        var se:SerialExecutor = new SerialExecutor();
        se.addThread(new TweenerThread(p, {time:2, alpha:1}));
        //se.addThread(new WaitThread(1000));
        se.addThread(new TweenerThread(p, {time:2, alpha:0}));
        se.addThread(new FunctionThread(function():void {
            _context.root.removeChild(p);
            _currentPhotoIndex++;
            p.scaleX = p.scaleY = 1;
            if (_currentPhotoIndex > _context.photoList.length - 1) _currentPhotoIndex = 0;
        }));
        se.start();
        se.join();
        // アニメーショんが終わったら次の写真へ
        next(nextPhoto);
    }
}

import org.libspark.thread.Thread;

// http://www.libspark.org/browser/as3/Thread/trunk/src/org/libspark/thread/threads/utils/FunctionThread.as
class FunctionThread extends Thread
{
    private var _func:Function;
    private var _params:Array;

    /**
     * 新しい FunctionThread インスタンスを作成します.
     * 
     * @param func 実行したい関数です.
     * @param params 関数に渡す引数です.
     */
    public function FunctionThread(func:Function, ...params):void
    {
        _func = func;
        _params = params;
    }

    override protected function run():void 
    {
        _func.apply(null, _params);
    }

    override protected function finalize():void 
    {
        _func = null;
        _params = null;
    }
}

import flash.events.TimerEvent;
import flash.utils.Timer;

// http://www.libspark.org/browser/as3/Thread/trunk/src/org/libspark/thread/threads/utils/WaitThread.as
class WaitThread extends Thread
{
    private var _timer:Timer;

    /**
     * 新しい WaitThread インスタンスを作成します.
     * 
     * @param time 待機したいミリ秒です.
     */
    public function WaitThread(time:int):void
    {
        _timer = new Timer(time, 2);
    }

    override protected function run():void 
    {
        event(_timer, TimerEvent.TIMER_COMPLETE, function () {});
        _timer.start();
    }

    override protected function finalize():void 
    {
        _timer = null;
    }
}
