/**
 * Copyright Kitosan1986 ( http://wonderfl.net/user/Kitosan1986 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o78r
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.net.URLRequest;
    import flash.utils.*;
    
    //[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]
    
    public class FlashTest extends Sprite {
        
        public const CHANNEL_LENGTH:int = 256;
        public const gx:Number = 30;
        public const pHeight:Number = stage.stageHeight/3;
        public const fftColor:Number = 0x669900;
        public const lColor:Number = 0x990066;
        public var bytes:ByteArray = new ByteArray();
        public var bytesFFT:ByteArray = new ByteArray();
        public var sd:Sound = new Sound();
        public var channel:SoundChannel;
        public var lsp:Sprite = new Sprite();
        public var fsp:Sprite = new Sprite();
        public var lmap:Graphics;
        public var fmap:Graphics;
        
        public function FlashTest() {
            // write as3 code here..
            sd.load( new URLRequest( "http://funky-radio.com/sound/08-feb-2011.mp3" ));
            channel = sd.play();
            addEventListener( Event.ENTER_FRAME, myEnterFrame );
            channel.addEventListener( Event.SOUND_COMPLETE, myComplete );
            
            lsp.x = gx;
            lsp.y = pHeight;
            lmap = lsp.graphics;
            addChild( lsp );
            
            fsp.x = gx + CHANNEL_LENGTH + 30;
            fsp.y = pHeight;
            fmap = fsp.graphics;
            addChild( fsp );
            
        }
        
        private function myEnterFrame( e:Event ):void{
            SoundMixer.computeSpectrum( bytes );
            SoundMixer.computeSpectrum( bytesFFT, true );
            lmap.clear();
            lmap.beginFill( lColor );
            
            lmap.moveTo( 0, 0 );
            var i:int;
            var fy:Number;
            for (i = 0; i < CHANNEL_LENGTH; i++){
                fy = bytes.readFloat()*pHeight;
                lmap.lineTo( i, fy );               
            }
            lmap.lineTo( i, fy );
            lmap.endFill();
            fmap.clear();
            fmap.beginFill( fftColor );
            fmap.moveTo( 0, 0 );
            for(i = 0; i < CHANNEL_LENGTH; i++){
                fy = bytesFFT.readFloat()*pHeight;
                fmap.lineTo( i, -fy );              
            }
            fmap.lineTo( i, 0);
            fmap.endFill();            
        } 
             
        private function myComplete( e:Event = null ):void{
            removeEventListener( Event.ENTER_FRAME, myEnterFrame );
            channel.removeEventListener( Event.SOUND_COMPLETE, myComplete );
        }
        
       
    }
    
}