/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o6tEU
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * ...
     * @author gaina
     */
    public class Main extends Sprite 
    {
        private var _arr:Array;
        private var ground:Sprite;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            _arr = [];
            
            ground = new Sprite();
            
            addChild(ground);
            
            addEventListener(Event.ENTER_FRAME, loop, false,0,true);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMoveEvent);
        }
        
        private function onMoveEvent(e:MouseEvent):void 
        {
            var _sp:Qruqru = new Qruqru();
            _sp.x = mouseX;
            _sp.y = mouseY;
            stage.addChild(_sp);
            _arr.push(_sp);
        }
        
        private function loop(e:Event):void 
        {
            ground.graphics.clear();
            if (_arr.length > 0)
            {
                for (var i:int = 0; i < _arr.length; i++) {
                    var q:Qruqru = _arr[i] as Qruqru;
                    q.draw(18);
                    
                    ground.graphics.lineStyle(1, 0);
                    
                    if (i == 0)
                    {
                        ground.graphics.moveTo(_arr[i].x, _arr[i].y);
                    }
                    
                    if (i > 2) {
                        if (i == Math.round(_arr.length / 2))
                        {
                            ground.graphics.lineTo(_arr[i].x, _arr[i].y);
                        }
                    }
                    
                    if (i == _arr.length - 1)
                    {
                        ground.graphics.lineTo(_arr[i].x, _arr[i].y);
                        ground.graphics.lineTo(_arr[0].x, _arr[0].y);
                    }
                    
                    
                    if (q.y > stage.stageHeight + 10) {
                        q = null;
                        stage.removeChild(_arr[i] as Qruqru);
                        _arr.splice(i, 1);
                        i--;
                    }
                }
            }
            ground.graphics.endFill();
        }
        
    }
    
}

import flash.display.Sprite;
class Qruqru extends Sprite
{
    private var vy:Number = 0.3;
    public function Qruqru()
    {
    }
        
    public function draw(rotate:int = 1):void
    {
        graphics.clear();
        graphics.lineStyle(2, 0);
        graphics.moveTo(-10, 0);
        graphics.lineTo(10, 0);
        graphics.endFill();
        this.rotation += rotate;
        this.y += vy;
        vy++;
    }
    
}