/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o6Q1
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import flash.net.URLRequestMethod;
    import flash.net.URLVariables;
    import flash.utils.ByteArray;
    import org.si.sion.events.SiONTrackEvent;
    import org.si.sion.SiONData;
    import org.si.sion.SiONDriver;
    import org.si.sion.SiONVoice;
    import org.si.sion.utils.SiONPresetVoice;
    
    /**
     * GoogleTTSを使ったもの2個目
     * @author paq89
     */
    [SWF(width=465, height=465, backgroundColor=0xFFFFFF, frameRate=60)]
    public class Main extends Sprite 
    {
        private var _driver:SiONDriver;
        private var _preset:SiONPresetVoice;
        private var _backing:SiONData;
        private var _voice:SiONVoice;
        private var _request:URLRequest;
        private var _variable:URLVariables;
        private var _soundDict:Object;
        private var _soundLoaded:int;
        private var _soundTotal:int;
        private var _data:Vector.<Number>;
        private var _byteArray:ByteArray;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            _driver = new SiONDriver();
            _preset = new SiONPresetVoice();
            _driver.play();
            
            _byteArray = new ByteArray();
            _data = new Vector.<Number>();
            
            _request = new URLRequest("http://paq-web.appspot.com/proxy");
            _request.method=URLRequestMethod.POST;
            _variable = new URLVariables();
            _request.data = _variable;
            
            _soundDict = {};
            _soundLoad(["key", "rah", "he", "car", "ru", "oh", "saw", "raw", "noh", "ho", "see", "yor"]);
        }
        
        private function _soundLoad(textArray:Array):void
        {
            for (var i:int = 0, len:int = textArray.length; i < len; i++) 
            {
                var text:String = textArray[i];
                _variable.url = "http://translate.google.com/translate_tts?tl=" + "en" + "&q=" + encodeURI(text);
                _soundDict[text] = new Sound();
                _soundDict[text].load(_request);
                _soundDict[text].addEventListener(Event.COMPLETE, (function(count:int):Function {
                    return function(event:Event):void {
                        _soundLoaded++;
                        _driver.setPCMSound(count, event.target as Sound);
                        if (_soundLoaded >= _soundTotal)
                        {
                            _play();
                            event.target.removeEventListener(Event.COMPLETE, arguments.callee);
                            stage.addEventListener(MouseEvent.CLICK, _play);
                        }
                    };
                })(i));
            }
            _soundTotal = textArray.length;
        }
        
        private function _play(event:Event = null):void 
        {
            var mml:String = "t100%7@0o5l4v10[@0c@1c@0g@1g@2a@3a@4g2@5f@6f@7e@8e@9d@10d@11c2]1"
            var melody:SiONData = _driver.compile(mml);
            _driver.play(melody);
        }
    }
    
}