/**
 * Copyright John_Blackburne ( http://wonderfl.net/user/John_Blackburne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o4sv
 */

// forked from John_Blackburne's Cross product shader
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.LoaderContext;

	public class FlashTest extends Sprite {

		public var fX:Number, fY:Number, fZ:Number;
		public var iMode:int;
                public var cmFilter:ColorMatrixFilter;
                public var m1:myMatrix, m2:myMatrix;

		
		function FlashTest() {
			Make();
		}
		
		public function Make():void {

                   var loader :Loader = new Loader;
                   loader.load(new URLRequest(
                    'http://assets.wonderfl.net/images/related_images/c/cf/cf1f/cf1fd3623e30ac888f91916d71f4d02e72bc933b'),
                       new LoaderContext( true )
                   );
 
                    loader.contentLoaderInfo.addEventListener(
                        Event.COMPLETE, function(e :Event) :void {
                            var bd :BitmapData 
                            = new BitmapData(stage.stageWidth,stage.stageHeight);
                            var bitmap :Bitmap = new Bitmap( bd );
                            bd.draw( loader );
                            addChild( bitmap );
                        });

			stage.addEventListener(MouseEvent.MOUSE_MOVE, Move);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, Click);
			fX = fY = fZ = -1;
                        cmFilter = new ColorMatrixFilter();
                        m1 = new myMatrix();
                        m1.appendScale(2, 2, 2);
                        m1.appendTranslation(-1, -1, -1);
                        m2 = new myMatrix();
                        m2.appendScale(0.5, 0.5, 0.5);
                        m2.appendTranslation(0.5, 0.5, 0.5);
		}
		
		public function Move(ev:MouseEvent):void {
                        var mCross:myMatrix, v:Vector3D, vRaw:Vector.<Number>;

			fX = -1 + 2 * (ev.stageX / stage.stageWidth);
			fY = -1 + 2 * (ev.stageY / stage.stageHeight);
			
			switch (iMode) {
				case 0:
                                        v = new Vector3D(fX, fY, fZ);
					break;
				case 1:
                                        v = new Vector3D(fY, fZ, fX);
					break;
				case 2:
                                        v = new Vector3D(fZ, fX, fY);
					break;
			}

//                      vRaw = new Vector.<Number>([
//                                           0.0, -v.z,  v.y,  0.0,
//                                           v.z,  0.0, -v.x,  0.0,
//                                          -v.y,  v.x,  0.0,  0.0,
//                                           0.0,  0.0,  0.0,  1.0]);

                        mCross = new myMatrix();
                        vRaw = mCross.rawData;
                        vRaw[0] = 0;
                        vRaw[1] = v.z;
                        vRaw[2] = -v.y;
                        
                        vRaw[4] = -v.z;
                        vRaw[5] = 0;
                        vRaw[6] = v.x;

                        vRaw[8] = v.y;
                        vRaw[9] = -v.x;
                        vRaw[10] = 0;
                        mCross.rawData = vRaw;
                        mCross.append(m1);
                        mCross.prepend(m2);
                        vRaw = mCross.rawData;
                        cmFilter.matrix =
                           [vRaw[0], vRaw[1], vRaw[2], 0, vRaw[3] * 255,
                            vRaw[4], vRaw[5], vRaw[6], 0, vRaw[7] * 255,
                            vRaw[8], vRaw[9], vRaw[10], 0, vRaw[11] * 255,
                            0, 0, 0, 1, 0];

			filters = [cmFilter];
		}

		public function Click(ev:MouseEvent):void {
			iMode = (iMode + 1) % 3;
			fZ = fY;
			Move(ev);
		}
	}
}

import flash.geom.*;

class myMatrix extends Matrix3D {
}

/*
<languageVersion: 1.0;>
    evaluatePixel()
    {
        float4 col = sampleNearest(src, outCoord());

        float3 ortho = col.xyz;
        ortho = ortho * 2.0 - float3(1.0, 1.0, 1.0);
        ortho = cross(ortho, adj);
        ortho = (ortho + float3(1.0, 1.0, 1.0)) * 0.5;
        dst = float4(ortho.x, ortho.y, ortho.z, 1.0);
    }
*/