/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o40R
 */

// forked from esukei's マスクを試す
/**
 * 透明度を適用するためのおまじない追加
 * 
 * 鏡面反射への使用例
 * http://wonderfl.kayac.com/code/1374160b2f062c37212eeb12951fee19c6ec1184
 */
package {
    import flash.display.Sprite;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    public class MaskTest extends Sprite {
        
        public var targetSprite:TargetObject;
        public var maskSprite:Sprite;
        
        public function MaskTest() {
            targetSprite = new TargetObject();
            addChild(targetSprite);
            
            targetSprite.x = 200;
            targetSprite.y = 200;
            
            
            maskSprite = new Sprite();
            
            //ターゲットとマスクの両方の cacheAsBitmap の値を true にするとマスクの透明度を適用できます。
            maskSprite.graphics.beginFill(0x005555,0.5);
            maskSprite.graphics.drawRect(0,0,80,80);
            maskSprite.graphics.endFill();
            
            // 透明度を適用するためのおまじない
            targetSprite.cacheAsBitmap = true;
            maskSprite.cacheAsBitmap = true;
            
            //ここはaddChildしなくても適用される
            maskSprite.x = 200;
            maskSprite.y = 200;
            
            //この動きはaddChildしないと適用されない
            var tween:ITween = BetweenAS3.serial(
                BetweenAS3.tween(maskSprite,{x:200,y:210}),
                BetweenAS3.tween(maskSprite,{x:210,y:210}),
                BetweenAS3.tween(maskSprite,{x:210,y:200}),
                BetweenAS3.tween(maskSprite,{x:200,y:200})
            );
            
            tween.play();
            
            //これするか、しないかで挙動変わる。
            addChild(maskSprite);
            
            targetSprite.mask = maskSprite;
        }
    }
}
import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
class TargetObject extends Sprite
{

    private var spriteA:Sprite;
    private var spriteB:Sprite;

    public function TargetObject() {
        
        spriteA = new Sprite();
        spriteA.graphics.beginFill(0x000055);
        spriteA.graphics.drawRect(0,0,100,100);
        spriteA.graphics.endFill();
        
        addChild(spriteA);
        
        spriteB = new Sprite();
        spriteB.graphics.beginFill(0x990000);
        spriteB.graphics.drawCircle(0,0,25);
        spriteB.graphics.endFill();
        
        addChild(spriteB);
        
        var tween:ITween = BetweenAS3.serial(
            BetweenAS3.tween(spriteB,{x:100,y:0}),
            BetweenAS3.tween(spriteB,{x:100,y:100}),
            BetweenAS3.tween(spriteB,{x:0,y:100}),
            BetweenAS3.tween(spriteB,{x:0,y:0})
        );
        
        tween.play();
        
    }

}