/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o3Dj
 */

package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.utils.Timer;

    [SWF(backgroundColor="#000000", frameRate="60", width="465", height="465")]
    public class MyDotTest extends Sprite
    {
        private var sw : int;
        private var sh : int;
        private var dots : Sprite;
        private var dg : Graphics;
        private var timer : Timer;
        private var bg : Sprite;
        private var bgg : Graphics;
        public function MyDotTest()
        {
            if(stage) _initialize(null); 
            else  addEventListener(Event.ADDED_TO_STAGE, _initialize);
        }

        private function _initialize(event : Event) : void
        {
            removeEventListener(Event.ADDED_TO_STAGE, _initialize);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            sw = stage.stageWidth;
            sh = stage.stageHeight;

            // ----------------------------------
            // bg
            // ----------------------------------
            bg = addChild(new Sprite()) as Sprite;
            bgg = bg.graphics;
            bgg.beginFill(0x0);
            bgg.drawRect(0, 0, sw, sh);
            bgg.endFill();

            // ----------------------------------
            // dot
            // ----------------------------------
            dots = addChild(new Sprite()) as Sprite;
            dg = dots.graphics;

            // ----------------------------------
            // timer
            // ----------------------------------
            timer = new Timer(500, 0);
            timer.addEventListener(TimerEvent.TIMER, timerHander);
            timer.start();

//            addEventListener(MouseEvent.CLICK, onRandomCreate);
        }

        private function timerHander(event : TimerEvent) : void
        {
            onRandomCreate();
        }

        private function onRandomCreate(event : MouseEvent = null) : void
        {
            var type : int = int(Math.random() * 3);
            
            var radius : Number = Math.random() * 10 + 2;

            var xi : Number = sw / (radius * 2);
            var yi : Number = sh / (radius * 2);
            
            bgg.clear();
            bgg.beginFill(0xffffff * Math.random());
            bgg.drawRect(0, 0, sw, sh);
            bgg.endFill();
            
            dg.clear();
            dg.beginFill(0xffffff*Math.random());
            for (var j : int = 0; j < yi; j++) {
                for (var i : int = 0; i < xi; i++) {
                    
                    var xx : Number = i * radius * 2;
                    var yy : Number = j * radius * 2;

                    var mRadius : Number ;
                    switch(type) {
                        case 0:
                            mRadius = Math.cos(yy * 0.1) + Math.sin(xx * 0.1) + 1;
                            break;
                        case 1:
                            mRadius = (  Math.sin(yy * xx) + 1 ) * 2;
                            break;
                        case 2:
                            var offset : Number = Math.sin(Math.cos(Math.sin(yy * radius) + Math.cos(xx * radius))) + 1;
                            mRadius = offset * offset * 1.8;
                            break;
                        default:
                    }
                    dg.drawCircle((i) * radius * 2, (j) * radius * 2, mRadius);
                }
            }
            dg.endFill();
        }
    }
}
