/**
 * Copyright Co-Tam ( http://wonderfl.net/user/Co-Tam )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o3BE
 */

package {
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.display.BlendMode;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.FilterShortcuts;
    
    [SWF(width="465",height="465",backgroundColor="0x000000")]
    public class Main extends Sprite {
        private var bmpData:BitmapData;
        private var sprite:Sprite;
        private var bmp:BitmapData;
        private var matrix:Matrix;
        private var colorTrans:ColorTransform;
        private var bmpColorTrans:ColorTransform;
        private var filter:BlurFilter;
        private var mouceFlg:Boolean = true;
        
        public function Main() {
            FilterShortcuts.init();
            
            // BitmapDataを表示リストに追加
            bmpData = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
            addChild(new Bitmap(bmpData));
            
            //グラフィックの作成
            sprite = newFig(1, 1, 20, 0xFFFFFF);
            //Matrixをインスタンス化
            matrix = new Matrix();
            //ColorTransformをインスタンス化
            colorTrans = new ColorTransform;
            bmpColorTrans = new ColorTransform(1,1 ,1 , 1);
            //エフェクトをインスタンス化
            filter = new BlurFilter(Math.random()*2, Math.random()*2, 1);
            
            //イベント登録
            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.CLICK, mouseDownHandler);
        }
        
        private function enterFrameHandler(in_e:Event):void {
            //Matrix
            matrix.identity();
            var s:Number = Math.random()*2;
            matrix.scale(s, s);
            matrix.rotate(Math.PI*Math.random());
            matrix.translate(mouseX, mouseY);
            //色変換
            colorTrans.greenMultiplier = mouseX / 465;
            colorTrans.blueMultiplier = mouseY /465;
            colorTrans.alphaMultiplier = Math.random();
            
            //BitMapへ描画
            bmpData.draw(sprite, matrix, colorTrans,BlendMode.ADD);
            //BitMapへエフェクトを適用
            bmpData.colorTransform(bmpData.rect, bmpColorTrans);
            //BitMapへフィルターの適用
            bmpData.applyFilter(bmpData, bmpData.rect, bmpData.rect.topLeft,filter);
        }
        
        private function mouseDownHandler(in_e:MouseEvent):void{
                bmpData.fillRect(bmpData.rect , 0x000000);
        }

        
        private function newFig( cx:Number, cy:Number, size:Number, col:uint):Sprite{
            var shape:Sprite = new Sprite();
            
            shape.graphics.lineStyle(0, 0x000000, 0.3);
            shape.graphics.beginFill(col);
            shape.graphics.drawCircle(cx, cy, size*0.5);
            shape.graphics.drawCircle(cx, cy, size*0.4);
            shape.graphics.endFill();
            
            return shape;
        }
    }
}