/**
 * Copyright _katsuren ( http://wonderfl.net/user/_katsuren )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/o2M6
 */

// forked from _katsuren's EventDispach と Callback のテスト4
// forked from _katsuren's EventDispach と Callback のテスト3
// forked from _katsuren's EventDispach と Callback のテスト2
// forked from _katsuren's EventDispach と Callback のテスト
package {
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.EventDispatcher;

    public class FlashTest extends Sprite {
        public static const TEST_COUNT:int = 1000000;
        
        private var _tf:TextField = new TextField();
        private var _dispatcher:EventDispatcher;
        private var _callback:Callback;
        private var _callback2:Callback2;
        private var _callback3:Callback3;
        private var _callback4:Callback4;
        
        private var _count:int = 0;
        
        public function FlashTest() {
            var i:int;
            
            _tf.x = 0;
            _tf.y = 0;
            _tf.width = 150;
            _tf.height = 200;
            addChild(_tf);
            
            _dispatcher = new EventDispatcher();
            _dispatcher.addEventListener("test", onEvent);
            
            _callback = new Callback();
            _callback.addCallback("test", onCallback);
            
            _callback2 = new Callback2();
            _callback2.addCallback("test", onCallback2);
            
            _callback3 = new Callback3();
            _callback3.addCallback("test", onCallback3);
            
            _callback4 = new Callback4();
            _callback4.addCallback("test", onCallback4);
            
            stage.frameRate = 1;
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function onEnterFrame(e:Event):void {
            if (_count == 0)
                testEventDispatcher();
            else if (_count == 1)
                testCallback();
            else if (_count == 2)
                testCallback2();
            else if (_count == 3)
                testCallback3();
            else if (_count == 4)
                testCallback4();
            else
                stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            _count++;
        }
        
        public function testEventDispatcher():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _dispatcher.dispatchEvent(new Event("test"));
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Event takes : " + time + "ms");
        }
        public function onEvent(e:Event):void {}
        
        public function testCallback():void {
            var start:Number = new Date().getTime();
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback.call("test");
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback takes : " + time + "ms");
        }
        public function onCallback():void {}
        
        public function testCallback2():void {
            var start:Number = new Date().getTime();
            var obj:CallbackObject = new CallbackObject("test");
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback2.call(obj);
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback2 takes : " + time + "ms");
        }
        public function onCallback2(o:CallbackObject):void {}
        
        public function testCallback3():void {
            var start:Number = new Date().getTime();
            var obj:CallbackObject2 = new CallbackObject2("test");
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback3.call(obj);
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback3 takes : " + time + "ms");
        }
        public function onCallback3(o:CallbackObject2):void {}
        
        public function testCallback4():void {
            var start:Number = new Date().getTime();
            var obj:CallbackObject3 = new CallbackObject3("test");
            for (var i:int=0; i<TEST_COUNT; i++) {
                _callback4.call(obj);
            }
            var end:Number = new Date().getTime();
            var time:String = (end-start).toString();
            appendText("Callback4 takes : " + time + "ms");
        }
        public function onCallback4(o:CallbackObject3):void {}
        
        public function appendText(str:String):void {
            _tf.appendText(str+"\n");
        }
    }
}

import flash.events.Event;

class Callback {
    private var _map:Object = {};
    public function Callback() {}
    public function addCallback(type:String, func:Function):Boolean {
        if (_map[type] == undefined)
            _map[type] = new Vector.<Function>();
        _map[type].push(func);
        return true;
    }
    public function removeCallback(type:String, func:Function):Boolean {
        try {
            var list:Vector.<Function> = _map[type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error){ return false; }
        for (var i:int=0; i<length; i++) {
            if (list[i] == func) {
                list.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    public function call(type:String):void {
        try {
            var list:Vector.<Function> = _map[type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error){}
        for (var i:int=0; i<length; i++) {
            list[i]();
        }
    }
    public function hasCallback(type:String):Boolean {
        try {
            var list:Vector.<Function> = _map[type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error) { return false; }
        if (length>0)
            return true;
        return false;
    }
    public function willTrigger(type:String):Boolean {
        return hasCallback(type);
    }
}

class Callback2 {
    private var _map:Object = {};
    public function Callback2() {}
    public function addCallback(type:String, func:Function):Boolean {
        if (_map[type] == undefined )
            _map[type] = new Vector.<Function>();
        _map[type].push(func);
        return true;
    }
    
    public function removeCallback(type:String, func:Function):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error){ return false; }
        for (var i:int=0; i<length; i++) {
            if (list[i] == func) {
                list.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    
    public function call(obj:CallbackObject):void {
        try {
            var list:Vector.<Function> = _map[obj.type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error) {}
        for (var i:int=0; i<length; i++) {
            list[i].apply(this, [obj]);
        }
    }
    
    public function hasCallback(type:String):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error) { return false; }
        if (length>0)
            return true;
        return false;
    }
    
    public function willTrigger(type:String):Boolean {
        return hasCallback(type);
    }
}

class Callback3 {
    private var _map:Object = {};
    public function Callback3() {}
    public function addCallback(type:String, func:Function):Boolean {
        if (_map[type] == undefined )
            _map[type] = new Vector.<Function>();
        _map[type].push(func);
        return true;
    }
    
    public function removeCallback(type:String, func:Function):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error){ return false; }
        for (var i:int=0; i<length; i++) {
            if (list[i] == func) {
                list.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    
    public function call(obj:CallbackObject2):void {
        try {
            var list:Vector.<Function> = _map[obj.type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error) {}
        for (var i:int=0; i<length; i++) {
            list[i].apply(this, [obj]);
        }
    }
    
    public function hasCallback(type:String):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error) { return false; }
        if (length>0)
            return true;
        return false;
    }
    
    public function willTrigger(type:String):Boolean {
        return hasCallback(type);
    }
}

class Callback4 {
    private var _map:Object = {};
    public function Callback4() {}
    public function addCallback(type:String, func:Function):Boolean {
        if (_map[type] == undefined )
            _map[type] = new Vector.<Function>();
        _map[type].push(func);
        return true;
    }
    
    public function removeCallback(type:String, func:Function):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error){ return false; }
        for (var i:int=0; i<length; i++) {
            if (list[i] == func) {
                list.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    
    public function call(obj:CallbackObject3):void {
        try {
            var list:Vector.<Function> = _map[obj.type] as Vector.<Function>;
            var length:uint = list.length;
        }catch(err:Error) {}
        for (var i:int=0; i<length; i++) {
            list[i].apply(this, [obj]);
        }
    }
    
    public function hasCallback(type:String):Boolean {
        try {
            var list:Vector.<Function> = _map[type];
            var length:uint = list.length;
        }catch(err:Error) { return false; }
        if (length>0)
            return true;
        return false;
    }
    
    public function willTrigger(type:String):Boolean {
        return hasCallback(type);
    }
}

class CallbackObject {
    public var type:String;
    public function CallbackObject(type:String) { this.type = type; }
}

class CallbackObject2 {
    public function get type():String { return _type; }
    private var _type:String;
    
    public function get bubbles():Boolean { return _bubbles; }
    private var _bubbles:Boolean;
    
    public function get cancelable():Boolean { return _cancelable }
    private var _cancelable:Boolean;
    
    public function get currentTarget():Object { return _currentTarget; }
    private var _currentTarget:Object;
    
    public function get target():Object { return _target; }
    private var _target:Object;
    
    public function get eventPhase():uint { return _eventPhase; }
    private var _eventPhase:uint;
    
    public function CallbackObject2(type:String, bubbles:Boolean=false, cancelable:Boolean=false) {
        _type = type;
        _bubbles = bubbles;
        _cancelable = cancelable;
    }
}

class CallbackObject3 {
    public function get type():String { return _type; }
    private var _type:String;
    
    public function get bubbles():Boolean { return _bubbles; }
    private var _bubbles:Boolean;
    
    public function get cancelable():Boolean { return _cancelable }
    private var _cancelable:Boolean;
    
    public function get currentTarget():Object { return _currentTarget; }
    private var _currentTarget:Object;
    
    public function get target():Object { return _target; }
    private var _target:Object;
    
    public function get eventPhase():uint { return _eventPhase; }
    private var _eventPhase:uint;
    
    public function CallbackObject3(type:String, bubbles:Boolean=false, cancelable:Boolean=false) {
        _type = type;
        _bubbles = bubbles;
        _cancelable = cancelable;
    }
    
    public function clone():CallbackObject3 {
        return new CallbackObject3(_type, _bubbles, _cancelable);
    }
    
    public function formatToString(className:String, ...args):String {
        return "CallbackObject3";
    }
    
    public function isDefaultPrevented():Boolean {
        return false;
    }
    
    public function preventDefault():void {
        
    }
    
    public function stopImmidiatePropagation():void {
        
    }
    
    public function stopPropagation():void {
        
    }
    
    public function toString():String {
        return "CallbackObject3";
    }

}

















































